/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.monitor.impl;

import com.alibaba.otter.manager.biz.config.alarm.AlarmRuleService;
import com.alibaba.otter.manager.biz.monitor.impl.AbstractRuleMonitor;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRule;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRuleStatus;
import com.alibaba.otter.shared.common.model.config.alarm.MonitorName;
import com.alibaba.otter.shared.communication.model.arbitrate.NodeAlarmEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class ExceptionRuleMonitor
extends AbstractRuleMonitor {
    private static final String MESAGE_FORMAT = "pid:%s nid:%s exception:%s";
    @Resource(name="alarmRuleService")
    private AlarmRuleService alarmRuleService;

    @Override
    public void explore(List<AlarmRule> rules) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void feed(Object data, Long pipelineId) {
        if (!(data instanceof NodeAlarmEvent)) {
            return;
        }
        NodeAlarmEvent alarmEvent = (NodeAlarmEvent)data;
        String message = String.format(MESAGE_FORMAT, alarmEvent.getPipelineId(), alarmEvent.getNid(), alarmEvent.getMessage());
        this.logRecordAlarm(pipelineId, alarmEvent.getNid(), MonitorName.EXCEPTION, message);
        List<AlarmRule> rules = this.alarmRuleService.getAlarmRules(pipelineId, AlarmRuleStatus.ENABLE);
        Date now = new Date();
        ArrayList<AlarmRule> exceptionRules = new ArrayList<AlarmRule>();
        for (AlarmRule rule : rules) {
            if (!MonitorName.EXCEPTION.equals((Object)rule.getMonitorName()) || !this.checkEnable(rule, now)) continue;
            exceptionRules.add(rule);
        }
        if (CollectionUtils.isEmpty(exceptionRules)) {
            return;
        }
        for (AlarmRule rule : exceptionRules) {
            this.check(rule, alarmEvent);
        }
    }

    private boolean checkEnable(AlarmRule rule, Date now) {
        return rule.getPauseTime() == null || rule.getPauseTime().before(now);
    }

    private void check(AlarmRule rule, NodeAlarmEvent alarmEvent) {
        String[] matchValues;
        if (!this.inPeriod(rule)) {
            return;
        }
        String matchValue = rule.getMatchValue();
        matchValue = StringUtils.substringBeforeLast((String)matchValue, (String)"@");
        for (String match : matchValues = StringUtils.split((String)matchValue, (String)",")) {
            if (!StringUtils.containsIgnoreCase((String)alarmEvent.getMessage(), (String)match)) continue;
            String message = String.format(MESAGE_FORMAT, alarmEvent.getPipelineId(), alarmEvent.getNid(), alarmEvent.getMessage());
            this.sendAlarm(rule, message);
            break;
        }
    }
}

