/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.monitor.impl;

import com.alibaba.otter.manager.biz.monitor.impl.AbstractRuleMonitor;
import com.alibaba.otter.manager.biz.statistics.delay.DelayStatService;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRule;
import com.alibaba.otter.shared.common.model.config.alarm.MonitorName;
import com.alibaba.otter.shared.common.model.statistics.delay.DelayStat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class DelayStatRuleMonitor
extends AbstractRuleMonitor {
    private static final String DELAY_TIME_MESSAGE = "pid:%s delay_time:%s seconds";
    private static final String DELAY_UPDATE_MESSAGE = "pid:%s delay %s seconds no update";
    private static final String DELAY_TIME_UPDATE_MESSAGE = "pid:%s delay_time:%s seconds, but delay %s seconds no update";
    private DelayStatService delayStatService;

    @Override
    public void explore(List<AlarmRule> rules) {
        if (CollectionUtils.isEmpty(rules)) {
            return;
        }
        Long pipelineId = rules.get(0).getPipelineId();
        DelayStat delayStat = this.delayStatService.findRealtimeDelayStat(pipelineId);
        Long delayTime = 0L;
        Long delayUpdate = 0L;
        if (delayStat.getDelayTime() != null) {
            delayTime = delayStat.getDelayTime() / 1000L;
        }
        if (delayStat.getGmtCreate() != null) {
            delayUpdate = (new Date().getTime() - delayStat.getGmtCreate().getTime()) / 1000L;
        }
        boolean delayTimeFlag = false;
        boolean delayUpdateFlag = false;
        for (AlarmRule rule : rules) {
            if (!rule.getMonitorName().isDelayTime() || !(delayTimeFlag |= this.checkDelayTime(rule, delayTime))) continue;
            delayUpdateFlag |= this.checkDelayTime(rule, delayUpdate);
        }
        if (delayTimeFlag && !delayUpdateFlag) {
            this.logRecordAlarm(pipelineId, MonitorName.DELAYTIME, String.format(DELAY_TIME_MESSAGE, pipelineId, delayTime));
        } else if (delayTimeFlag && delayUpdateFlag) {
            this.logRecordAlarm(pipelineId, MonitorName.DELAYTIME, String.format(DELAY_TIME_UPDATE_MESSAGE, pipelineId, delayTime, delayUpdate));
        } else if (delayUpdateFlag) {
            this.logRecordAlarm(pipelineId, MonitorName.DELAYTIME, String.format(DELAY_UPDATE_MESSAGE, pipelineId, delayUpdate));
        }
    }

    private boolean checkDelayTime(AlarmRule rule, Long delayTime) {
        if (!this.inPeriod(rule)) {
            return false;
        }
        String matchValue = rule.getMatchValue();
        matchValue = StringUtils.substringBeforeLast((String)matchValue, (String)"@");
        Long maxDelayTime = Long.parseLong(StringUtils.trim((String)matchValue));
        if (delayTime >= maxDelayTime) {
            this.sendAlarm(rule, String.format(DELAY_TIME_MESSAGE, rule.getPipelineId(), delayTime));
            return true;
        }
        return false;
    }

    public void setDelayStatService(DelayStatService delayStatService) {
        this.delayStatService = delayStatService;
    }
}

