/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.monitor.impl;

import com.alibaba.otter.manager.biz.common.alarm.AlarmMessage;
import com.alibaba.otter.manager.biz.monitor.AlarmController;
import com.alibaba.otter.manager.biz.monitor.AlarmRecovery;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRule;
import com.alibaba.otter.shared.common.model.config.alarm.MonitorName;
import com.google.common.collect.OtterMigrateMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DefaultAlarmController
implements AlarmController {
    private Long DEFAULT_THRESHOLD = 1800L;
    private Map<PoolKey, PoolValue> pool = OtterMigrateMap.makeSoftValueMapWithTimeout((long)1L, (TimeUnit)TimeUnit.HOURS);
    private AlarmRecovery restartAlarmRecovery;

    @Override
    public AlarmMessage control(AlarmRule rule, String message, AlarmMessage data) {
        if (rule == null) {
            return data;
        }
        Long threshold = rule.getIntervalTime() == null ? this.DEFAULT_THRESHOLD : rule.getIntervalTime();
        PoolKey key = new PoolKey(rule, message, data);
        PoolValue value = this.pool.get(key);
        boolean needAlarm = true;
        Long now = System.currentTimeMillis();
        if (value == null) {
            value = new PoolValue(now);
            this.pool.put(key, new PoolValue(now));
        } else {
            Long latest = value.getLastAlarmTime();
            if (now - latest > threshold * 1000L) {
                value.updateAlarmTime(now);
                this.pool.put(key, value);
            } else {
                value.addSuppressTimes();
                this.pool.put(key, value);
                needAlarm = false;
            }
        }
        if (rule.getAutoRecovery().booleanValue()) {
            this.restartAlarmRecovery.recovery(rule, value.getSuppressTimes());
        }
        if (needAlarm) {
            return data;
        }
        return null;
    }

    public void setRestartAlarmRecovery(AlarmRecovery restartAlarmRecovery) {
        this.restartAlarmRecovery = restartAlarmRecovery;
    }

    private static class PoolValue {
        private Long lastAlarmTime;
        private long suppressTimes = 1L;

        public PoolValue(Long happendTime) {
            this.lastAlarmTime = happendTime;
        }

        public void addSuppressTimes() {
            ++this.suppressTimes;
        }

        public long getSuppressTimes() {
            return this.suppressTimes;
        }

        public Long getLastAlarmTime() {
            return this.lastAlarmTime;
        }

        public void updateAlarmTime(Long lastAlarmTime) {
            this.lastAlarmTime = lastAlarmTime;
        }
    }

    private static class PoolKey {
        private Long pipelineId;
        private MonitorName monitorName;
        private String receiveKey;
        private String matchValue;

        public PoolKey(AlarmRule rule, String messageToSend, AlarmMessage data) {
            this.pipelineId = rule.getPipelineId();
            this.monitorName = rule.getMonitorName();
            this.receiveKey = rule.getReceiverKey();
            this.matchValue = rule.getMatchValue();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.matchValue == null ? 0 : this.matchValue.hashCode());
            result = 31 * result + (this.monitorName == null ? 0 : this.monitorName.hashCode());
            result = 31 * result + (this.pipelineId == null ? 0 : this.pipelineId.hashCode());
            result = 31 * result + (this.receiveKey == null ? 0 : this.receiveKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PoolKey other = (PoolKey)obj;
            if (this.matchValue == null ? other.matchValue != null : !this.matchValue.equals(other.matchValue)) {
                return false;
            }
            if (this.monitorName != other.monitorName) {
                return false;
            }
            if (this.pipelineId == null ? other.pipelineId != null : !this.pipelineId.equals(other.pipelineId)) {
                return false;
            }
            return !(this.receiveKey == null ? other.receiveKey != null : !this.receiveKey.equals(other.receiveKey));
        }
    }
}

