/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.monitor.impl;

import com.alibaba.otter.manager.biz.common.arbitrate.DeadNodeListener;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class AlarmRecoveryDelayed
implements Delayed {
    private static final long MILL_ORIGIN = System.currentTimeMillis();
    private long ruleId;
    private long channelId;
    private boolean stop = false;
    private long now;
    private long timeout;

    public AlarmRecoveryDelayed(long channelId, long ruleId, boolean stop, long timeout) {
        this.channelId = channelId;
        this.ruleId = ruleId;
        this.stop = stop;
        this.timeout = timeout;
        this.now = System.currentTimeMillis() - MILL_ORIGIN;
    }

    public long getChannelId() {
        return this.channelId;
    }

    public long getRuleId() {
        return this.ruleId;
    }

    public long getNow() {
        return this.now;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long currNow = System.currentTimeMillis() - MILL_ORIGIN;
        long d = unit.convert(this.now + this.timeout - currNow, TimeUnit.MILLISECONDS);
        return d;
    }

    @Override
    public int compareTo(Delayed other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof AlarmRecoveryDelayed) {
            AlarmRecoveryDelayed x = (AlarmRecoveryDelayed)other;
            long diff = this.now + this.timeout - (x.now + x.timeout);
            return diff == 0L ? 0 : (diff < 0L ? 1 : -1);
        }
        long d = this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS);
        return d == 0L ? 0 : (d < 0L ? 1 : -1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.channelId ^ this.channelId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeadNodeListener.DeadNodeDelayed)) {
            return false;
        }
        AlarmRecoveryDelayed other = (AlarmRecoveryDelayed)obj;
        return this.channelId == other.channelId;
    }
}

