/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.monitor.impl;

import com.alibaba.otter.manager.biz.common.alarm.AbstractAlarmService;
import com.alibaba.otter.manager.biz.common.alarm.AlarmMessage;
import com.alibaba.otter.manager.biz.config.record.LogRecordService;
import com.alibaba.otter.manager.biz.monitor.AlarmController;
import com.alibaba.otter.manager.biz.monitor.Monitor;
import com.alibaba.otter.manager.biz.monitor.PassiveMonitor;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRule;
import com.alibaba.otter.shared.common.model.config.alarm.MonitorName;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.common.model.config.record.LogRecord;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuleMonitor
implements Monitor,
PassiveMonitor {
    protected static final Logger log = LoggerFactory.getLogger((String)"monitorInfo");
    @Resource(name="alarmService")
    private AbstractAlarmService alarmService;
    @Resource(name="logRecordService")
    private LogRecordService logRecordService;
    @Resource(name="alarmController")
    private AlarmController alarmController;

    @Override
    public void explore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void explore(Long ... pipelineIds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void feed(Object data, Long pipelineId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void feed(Object data, List<AlarmRule> rules) {
        throw new UnsupportedOperationException();
    }

    protected void sendAlarm(AlarmRule rule, String message) {
        AlarmMessage data = new AlarmMessage();
        data.setMessage(message);
        data.setReceiveKey(rule.getReceiverKey());
        data = this.alarmController.control(rule, message, data);
        this.postProcessAlarmData(data);
        if (data == null) {
            log.info("has suppressed alarm : " + message);
            return;
        }
        this.alarmService.sendAlarm(data);
        log.info("has send alarm : " + data + "; rule is " + rule);
    }

    protected void logRecordAlarm(Long pipelineId, MonitorName monitorName, String message) {
        this.logRecordAlarm(pipelineId, -1L, monitorName, message);
    }

    protected void logRecordAlarm(Long pipelineId, Long nodeId, MonitorName monitorName, String message) {
        Pipeline pipeline = new Pipeline();
        pipeline.setId(pipelineId);
        LogRecord logRecord = new LogRecord();
        logRecord.setTitle(monitorName.toString());
        logRecord.setNid(nodeId);
        logRecord.setPipeline(pipeline);
        logRecord.setMessage(message);
        this.logRecordService.create(logRecord);
    }

    protected void postProcessAlarmData(AlarmMessage data) {
    }

    protected boolean inPeriod(AlarmRule alarmRule) {
        String rule = alarmRule.getMatchValue();
        if (StringUtils.isEmpty((String)rule)) {
            log.info("rule is empty " + alarmRule);
            return false;
        }
        String periods = StringUtils.substringAfterLast((String)rule, (String)"@");
        if (StringUtils.isEmpty((String)periods)) {
            return this.isInPeriodWhenNoPeriod();
        }
        Calendar calendar = this.currentCalendar();
        periods = StringUtils.trim((String)periods);
        for (String period : StringUtils.split((String)periods, (String)",")) {
            String[] startAndEnd = StringUtils.split((String)period, (String)"-");
            if (startAndEnd == null || startAndEnd.length != 2) {
                log.error("error period time format in rule : " + alarmRule);
                return this.isInPeriodWhenErrorFormat();
            }
            String start = startAndEnd[0];
            String end = startAndEnd[1];
            if (!this.checkInPeriod(calendar, start, end)) continue;
            log.info("rule is in period : " + alarmRule);
            return true;
        }
        log.info("rule is not in period : " + alarmRule);
        return false;
    }

    protected boolean checkInPeriod(Calendar now, String start, String end) {
        return this.isAfter(now, start) && !this.isAfter(now, end);
    }

    protected boolean isAfter(Calendar now, String time) {
        int min;
        int hour;
        String[] hourAndMin = StringUtils.split((String)time, (String)":");
        if (hourAndMin == null || hourAndMin.length != 2) {
            log.error("error period time format in rule : " + time);
            return this.isInPeriodWhenErrorFormat();
        }
        try {
            hour = Integer.parseInt(hourAndMin[0]);
            min = Integer.parseInt(hourAndMin[1]);
        }
        catch (NumberFormatException e) {
            log.error("error period time format in rule : " + time, (Throwable)e);
            return this.isInPeriodWhenErrorFormat();
        }
        if (hour > 24 || min > 60) {
            log.error("error period time format in rule : " + time);
            return this.isInPeriodWhenErrorFormat();
        }
        Calendar when = (Calendar)now.clone();
        when.set(11, hour);
        when.set(12, min);
        return !now.before(when);
    }

    protected boolean isInPeriodWhenErrorFormat() {
        return true;
    }

    protected boolean isInPeriodWhenNoPeriod() {
        return true;
    }

    protected Calendar currentCalendar() {
        Calendar calendar = Calendar.getInstance();
        return calendar;
    }
}

