/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.config.record.impl;

import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.config.channel.ChannelService;
import com.alibaba.otter.manager.biz.config.record.LogRecordService;
import com.alibaba.otter.manager.biz.config.record.dal.LogRecordDAO;
import com.alibaba.otter.manager.biz.config.record.dal.dataobject.LogRecordDO;
import com.alibaba.otter.shared.common.model.config.channel.Channel;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.common.model.config.record.LogRecord;
import com.alibaba.otter.shared.common.utils.Assert;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import com.alibaba.otter.shared.communication.core.model.Event;
import com.alibaba.otter.shared.communication.model.arbitrate.NodeAlarmEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRecordServiceImpl
implements LogRecordService {
    private static final Logger logger = LoggerFactory.getLogger(LogRecordServiceImpl.class);
    private ChannelService channelService;
    private LogRecordDAO logRecordDao;

    @Override
    public void create(Event event) {
        LogRecord logRecord = new LogRecord();
        if (event instanceof NodeAlarmEvent) {
            NodeAlarmEvent nodeAlarmEvent = (NodeAlarmEvent)event;
            Pipeline tempPipeline = new Pipeline();
            tempPipeline.setId(nodeAlarmEvent.getPipelineId());
            logRecord.setPipeline(tempPipeline);
            logRecord.setNid(nodeAlarmEvent.getNid());
            logRecord.setTitle(nodeAlarmEvent.getTitle());
            logRecord.setMessage(nodeAlarmEvent.getMessage());
        }
        this.create(logRecord);
    }

    @Override
    public void create(LogRecord entityObj) {
        Assert.assertNotNull((Object)entityObj);
        this.logRecordDao.insert(this.modelToDo(entityObj));
    }

    @Override
    public void remove(Long identity) {
        Assert.assertNotNull((Object)identity);
        this.logRecordDao.delete(identity);
    }

    @Override
    public void modify(LogRecord entityObj) {
    }

    @Override
    public LogRecord findById(Long identity) {
        return null;
    }

    @Override
    public List<LogRecord> listByPipelineId(Long pipelineId) {
        Assert.assertNotNull((Object)pipelineId);
        List<LogRecordDO> logRecordDos = this.logRecordDao.listByPipelineId(pipelineId);
        return this.doToModel(logRecordDos);
    }

    @Override
    public List<LogRecord> listByPipelineIdWithoutContent(Long pipelineId) {
        Assert.assertNotNull((Object)pipelineId);
        List<LogRecordDO> logRecordDos = this.logRecordDao.listByPipelineIdWithoutContent(pipelineId);
        return this.doToModel(logRecordDos);
    }

    @Override
    public List<LogRecord> listByIds(Long ... identities) {
        return null;
    }

    @Override
    public List<LogRecord> listAll() {
        List<LogRecordDO> logRecordDos = this.logRecordDao.listAll();
        return this.doToModel(logRecordDos);
    }

    @Override
    public List<LogRecord> listByCondition(Map condition) {
        List<LogRecordDO> logRecordDos = this.logRecordDao.listByCondition(condition);
        if (logRecordDos.isEmpty()) {
            logger.debug("DEBUG ## couldn't query any log record by the condition:" + JsonUtils.marshalToString((Object)condition));
            return new ArrayList<LogRecord>();
        }
        return this.doToModel(logRecordDos);
    }

    @Override
    public int getCount() {
        return 0;
    }

    @Override
    public int getCount(Map condition) {
        return this.logRecordDao.getCount(condition);
    }

    private LogRecordDO modelToDo(LogRecord entityObj) {
        LogRecordDO logRecordDo = new LogRecordDO();
        try {
            if (entityObj.getPipeline() != null && entityObj.getPipeline().getId() > 0L) {
                Channel channel = this.channelService.findByPipelineId(entityObj.getPipeline().getId());
                logRecordDo.setChannelId(channel.getId());
                logRecordDo.setPipelineId(entityObj.getPipeline().getId());
            } else {
                logRecordDo.setChannelId(-1L);
                logRecordDo.setPipelineId(-1L);
            }
            logRecordDo.setNid(entityObj.getNid());
            logRecordDo.setTitle(entityObj.getTitle());
            String message = entityObj.getMessage();
            if (message != null && message.length() > 21845) {
                message = message.substring(0, 21845);
            }
            logRecordDo.setMessage(message);
            logRecordDo.setGmtCreate(entityObj.getGmtCreate());
            logRecordDo.setGmtModified(entityObj.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## has an error where write log to db");
            throw new ManagerException(e);
        }
        return logRecordDo;
    }

    private LogRecord doToModel(LogRecordDO logRecordDo) {
        LogRecord logRecord = new LogRecord();
        try {
            logRecord.setId(logRecordDo.getId());
            if (logRecordDo.getPipelineId() > 0L && logRecordDo.getChannelId() > 0L) {
                try {
                    Channel channel = this.channelService.findByPipelineId(logRecordDo.getPipelineId());
                    logRecord.setChannel(channel);
                    for (Pipeline pipeline : channel.getPipelines()) {
                        if (!pipeline.getId().equals(logRecordDo.getPipelineId())) continue;
                        logRecord.setPipeline(pipeline);
                    }
                }
                catch (Exception e) {
                    Channel channel = new Channel();
                    channel.setId(Long.valueOf(0L));
                    logRecord.setChannel(channel);
                    Pipeline pipeline = new Pipeline();
                    pipeline.setId(Long.valueOf(0L));
                    logRecord.setPipeline(pipeline);
                }
            } else {
                Channel channel = new Channel();
                channel.setId(Long.valueOf(-1L));
                logRecord.setChannel(channel);
                Pipeline pipeline = new Pipeline();
                pipeline.setId(Long.valueOf(-1L));
                logRecord.setPipeline(pipeline);
            }
            logRecord.setTitle(logRecordDo.getTitle());
            logRecord.setNid(logRecordDo.getNid());
            logRecord.setMessage(logRecordDo.getMessage());
            logRecord.setGmtCreate(logRecordDo.getGmtCreate());
            logRecord.setGmtModified(logRecordDo.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## ");
            throw new ManagerException(e);
        }
        return logRecord;
    }

    private List<LogRecord> doToModel(List<LogRecordDO> logRecordDos) {
        ArrayList<LogRecord> logRecords = new ArrayList<LogRecord>();
        try {
            for (LogRecordDO logRecordDo : logRecordDos) {
                logRecords.add(this.doToModel(logRecordDo));
            }
        }
        catch (Exception e) {
            logger.error("ERROR ##");
            throw new ManagerException(e);
        }
        return logRecords;
    }

    public ChannelService getChannelService() {
        return this.channelService;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public LogRecordDAO getLogRecordDao() {
        return this.logRecordDao;
    }

    public void setLogRecordDao(LogRecordDAO logRecordDao) {
        this.logRecordDao = logRecordDao;
    }
}

