/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.config.pipeline.impl;

import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.common.exceptions.RepeatConfigureException;
import com.alibaba.otter.manager.biz.config.datamediapair.DataMediaPairService;
import com.alibaba.otter.manager.biz.config.node.NodeService;
import com.alibaba.otter.manager.biz.config.pipeline.PipelineService;
import com.alibaba.otter.manager.biz.config.pipeline.dal.PipelineDAO;
import com.alibaba.otter.manager.biz.config.pipeline.dal.PipelineNodeRelationDAO;
import com.alibaba.otter.manager.biz.config.pipeline.dal.dataobject.PipelineDO;
import com.alibaba.otter.manager.biz.config.pipeline.dal.dataobject.PipelineNodeRelationDO;
import com.alibaba.otter.shared.arbitrate.ArbitrateManageService;
import com.alibaba.otter.shared.arbitrate.ArbitrateViewService;
import com.alibaba.otter.shared.common.model.config.data.DataMediaPair;
import com.alibaba.otter.shared.common.model.config.data.DataMediaPairComparable;
import com.alibaba.otter.shared.common.model.config.node.Node;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.common.utils.Assert;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class PipelineServiceImpl
implements PipelineService {
    private static final Logger logger = LoggerFactory.getLogger(PipelineServiceImpl.class);
    private PipelineDAO pipelineDao;
    private PipelineNodeRelationDAO pipelineNodeRelationDao;
    private DataMediaPairService dataMediaPairService;
    private NodeService nodeService;
    private TransactionTemplate transactionTemplate;
    private ArbitrateManageService arbitrateManageService;
    private ArbitrateViewService arbitrateViewService;

    @Override
    public void create(final Pipeline pipeline) {
        Assert.assertNotNull((Object)pipeline);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    PipelineNodeRelationDO pipelineNodeRelationDo;
                    PipelineDO pipelineDo = PipelineServiceImpl.this.modelToDo(pipeline);
                    pipelineDo.setId(0L);
                    if (!PipelineServiceImpl.this.pipelineDao.checkUnique(pipelineDo)) {
                        String exceptionCause = "exist the same name pipeline under the channel(" + pipelineDo.getChannelId() + ") in the database.";
                        logger.warn("WARN ## " + exceptionCause);
                        throw new RepeatConfigureException(exceptionCause);
                    }
                    PipelineServiceImpl.this.pipelineDao.insert(pipelineDo);
                    ArrayList<PipelineNodeRelationDO> pipelineNodeRelationDos = new ArrayList<PipelineNodeRelationDO>();
                    for (Node node : pipeline.getSelectNodes()) {
                        pipelineNodeRelationDo = new PipelineNodeRelationDO();
                        pipelineNodeRelationDo.setPipelineId(pipelineDo.getId());
                        pipelineNodeRelationDo.setNodeId(node.getId());
                        pipelineNodeRelationDo.setLocation(PipelineNodeRelationDO.Location.SELECT);
                        pipelineNodeRelationDos.add(pipelineNodeRelationDo);
                    }
                    for (Node node : pipeline.getExtractNodes()) {
                        pipelineNodeRelationDo = new PipelineNodeRelationDO();
                        pipelineNodeRelationDo.setPipelineId(pipelineDo.getId());
                        pipelineNodeRelationDo.setNodeId(node.getId());
                        pipelineNodeRelationDo.setLocation(PipelineNodeRelationDO.Location.EXTRACT);
                        pipelineNodeRelationDos.add(pipelineNodeRelationDo);
                    }
                    for (Node node : pipeline.getLoadNodes()) {
                        pipelineNodeRelationDo = new PipelineNodeRelationDO();
                        pipelineNodeRelationDo.setPipelineId(pipelineDo.getId());
                        pipelineNodeRelationDo.setNodeId(node.getId());
                        pipelineNodeRelationDo.setLocation(PipelineNodeRelationDO.Location.LOAD);
                        pipelineNodeRelationDos.add(pipelineNodeRelationDo);
                    }
                    PipelineServiceImpl.this.pipelineNodeRelationDao.insertBatch(pipelineNodeRelationDos);
                    PipelineServiceImpl.this.arbitrateManageService.pipelineEvent().init(pipelineDo.getChannelId(), pipelineDo.getId());
                }
                catch (RepeatConfigureException rce) {
                    throw rce;
                }
                catch (Exception e) {
                    logger.error("ERROR ## create pipeline has an exception!");
                    throw new ManagerException(e);
                }
            }
        });
    }

    @Override
    public void modify(Pipeline pipeline) {
        Assert.assertNotNull((Object)pipeline);
        try {
            PipelineNodeRelationDO pipelineNodeRelationDo;
            PipelineDO pipelineDo = this.modelToDo(pipeline);
            if (!this.pipelineDao.checkUnique(pipelineDo)) {
                String exceptionCause = "exist the same name pipeline under the channel(" + pipelineDo.getChannelId() + ") in the database.";
                logger.warn("WARN ## " + exceptionCause);
                throw new RepeatConfigureException(exceptionCause);
            }
            this.pipelineNodeRelationDao.deleteByPipelineId(pipelineDo.getId());
            this.pipelineDao.update(pipelineDo);
            ArrayList<PipelineNodeRelationDO> pipelineNodeRelationDos = new ArrayList<PipelineNodeRelationDO>();
            for (Node node : pipeline.getSelectNodes()) {
                pipelineNodeRelationDo = new PipelineNodeRelationDO();
                pipelineNodeRelationDo.setPipelineId(pipelineDo.getId());
                pipelineNodeRelationDo.setNodeId(node.getId());
                pipelineNodeRelationDo.setLocation(PipelineNodeRelationDO.Location.SELECT);
                pipelineNodeRelationDos.add(pipelineNodeRelationDo);
            }
            for (Node node : pipeline.getExtractNodes()) {
                pipelineNodeRelationDo = new PipelineNodeRelationDO();
                pipelineNodeRelationDo.setPipelineId(pipelineDo.getId());
                pipelineNodeRelationDo.setNodeId(node.getId());
                pipelineNodeRelationDo.setLocation(PipelineNodeRelationDO.Location.EXTRACT);
                pipelineNodeRelationDos.add(pipelineNodeRelationDo);
            }
            for (Node node : pipeline.getLoadNodes()) {
                pipelineNodeRelationDo = new PipelineNodeRelationDO();
                pipelineNodeRelationDo.setPipelineId(pipelineDo.getId());
                pipelineNodeRelationDo.setNodeId(node.getId());
                pipelineNodeRelationDo.setLocation(PipelineNodeRelationDO.Location.LOAD);
                pipelineNodeRelationDos.add(pipelineNodeRelationDo);
            }
            this.pipelineNodeRelationDao.insertBatch(pipelineNodeRelationDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## modify the pipeline(" + pipeline.getId() + ") has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public void remove(final Long pipelineId) {
        Assert.assertNotNull((Object)pipelineId);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    PipelineDO pipelineDO = (PipelineDO)PipelineServiceImpl.this.pipelineDao.findById(pipelineId);
                    if (pipelineDO != null) {
                        PipelineServiceImpl.this.pipelineDao.delete(pipelineId);
                        PipelineServiceImpl.this.pipelineNodeRelationDao.deleteByPipelineId(pipelineId);
                        String destination = pipelineDO.getParameters().getDestinationName();
                        short clientId = pipelineDO.getId().shortValue();
                        PipelineServiceImpl.this.arbitrateViewService.removeCanal(destination, clientId);
                        PipelineServiceImpl.this.arbitrateManageService.pipelineEvent().destory(pipelineDO.getChannelId(), pipelineId);
                    }
                }
                catch (Exception e) {
                    logger.error("ERROR ## remove the pipeline(" + pipelineId + ") has an exception!");
                    throw new ManagerException(e);
                }
            }
        });
    }

    @Override
    public int getCount() {
        return this.pipelineDao.getCount();
    }

    @Override
    public int getCount(Map condition) {
        return this.pipelineDao.getCount(condition);
    }

    @Override
    public Pipeline findById(Long pipelineId) {
        Assert.assertNotNull((Object)pipelineId);
        List<Pipeline> pipeline = this.listByIds(pipelineId);
        if (pipeline.size() != 1) {
            String exceptionCause = "query pipeline by pipelineId:" + pipelineId + " but return " + pipeline.size() + " pipeline!";
            logger.error("ERROR ## " + exceptionCause);
            throw new ManagerException(exceptionCause);
        }
        return pipeline.get(0);
    }

    @Override
    public List<Pipeline> listByChannelIds(Long ... channelId) {
        Assert.assertNotNull((Object)channelId);
        ArrayList<Pipeline> pipelines = new ArrayList();
        try {
            List<PipelineDO> pipelineDos = this.pipelineDao.listByChannelIds(channelId);
            if (pipelineDos.isEmpty()) {
                logger.debug("DEBUG ## query pipeline by channelId:" + channelId + " return null.");
                return pipelines;
            }
            pipelines = this.doToModel(pipelineDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query pipelines by channelIds:" + channelId.toString() + " has an exception!");
            throw new ManagerException(e);
        }
        return pipelines;
    }

    @Override
    public List<Pipeline> listByChannelIdsWithoutOther(Long ... channelIds) {
        Assert.assertNotNull((Object)channelIds);
        ArrayList<Pipeline> pipelines = new ArrayList();
        try {
            List<PipelineDO> pipelineDos = this.pipelineDao.listByChannelIds(channelIds);
            if (pipelineDos.isEmpty()) {
                logger.debug("DEBUG ## query pipeline by channelId:" + channelIds + " return null.");
                return pipelines;
            }
            pipelines = this.doToModelWithoutOther(pipelineDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query pipelines by channelIds:" + channelIds.toString() + " has an exception!");
            throw new ManagerException(e);
        }
        return pipelines;
    }

    @Override
    public List<Pipeline> listByChannelIdsWithoutColumn(Long ... channelIds) {
        Assert.assertNotNull((Object)channelIds);
        ArrayList<Pipeline> pipelines = new ArrayList();
        try {
            List<PipelineDO> pipelineDos = this.pipelineDao.listByChannelIds(channelIds);
            if (pipelineDos.isEmpty()) {
                logger.debug("DEBUG ## query pipeline by channelId:" + channelIds + " return null.");
                return pipelines;
            }
            pipelines = this.doToModelWithoutColumn(pipelineDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query pipelines by channelIds:" + channelIds.toString() + " has an exception!");
            throw new ManagerException(e);
        }
        return pipelines;
    }

    @Override
    public List<Pipeline> listByNodeId(Long nodeId) {
        Assert.assertNotNull((Object)nodeId);
        List<Pipeline> pipelines = new ArrayList<Pipeline>();
        try {
            List<PipelineNodeRelationDO> relations = this.pipelineNodeRelationDao.listByNodeId(nodeId);
            if (relations.isEmpty()) {
                logger.debug("DEBUG ## query the relation by nodeId:" + nodeId + " return null,maybe hasn't create any relations.");
                return pipelines;
            }
            ArrayList<Long> piplineIds = new ArrayList<Long>();
            for (PipelineNodeRelationDO relation : relations) {
                piplineIds.add(relation.getPipelineId());
            }
            List<PipelineDO> pipelineDos = this.pipelineDao.listByMultiId(piplineIds.toArray(new Long[piplineIds.size()]));
            if (pipelineDos.isEmpty()) {
                String exceptionCause = "query the pipelines by pipelineIds:" + ((Object)piplineIds).toString() + " return null!";
                logger.error("ERROR ## " + exceptionCause);
                throw new ManagerException(exceptionCause);
            }
            pipelines = this.doToModel(pipelineDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query the pipelines by nodeId:" + nodeId + " has an exception!");
            throw new ManagerException(e);
        }
        return pipelines;
    }

    @Override
    public List<Pipeline> listByCondition(Map condition) {
        List<PipelineDO> pipelineDos = this.pipelineDao.listByCondition(condition);
        if (pipelineDos.isEmpty()) {
            logger.debug("DEBUG ## couldn't query any pipelines by the condition:" + JsonUtils.marshalToString((Object)condition));
            return new ArrayList<Pipeline>();
        }
        return this.doToModel(pipelineDos);
    }

    @Override
    public List<Pipeline> listByIds(Long ... identities) {
        List<Pipeline> pipelines = new ArrayList<Pipeline>();
        try {
            List<Object> pipelineDos = new ArrayList();
            if (identities.length < 1) {
                pipelineDos = this.pipelineDao.listAll();
                if (pipelineDos.isEmpty()) {
                    logger.debug("DEBUG ## couldn't query any pipeline, maybe hasn't create any pipeline.");
                    return pipelines;
                }
            } else {
                pipelineDos = this.pipelineDao.listByMultiId(identities);
                if (pipelineDos.isEmpty()) {
                    String exceptionCause = "couldn't query any pipeline by pipelineIds:" + Arrays.toString((Object[])identities);
                    logger.error("ERROR ## " + exceptionCause);
                    throw new ManagerException(exceptionCause);
                }
            }
            pipelines = this.doToModel(pipelineDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query pipelines has an exception!");
            throw new ManagerException(e);
        }
        return pipelines;
    }

    @Override
    public List<Pipeline> listAll() {
        return this.listByIds(new Long[0]);
    }

    @Override
    public boolean hasRelation(Long nodeId) {
        List<PipelineNodeRelationDO> relations = this.pipelineNodeRelationDao.listByNodeId(nodeId);
        return !relations.isEmpty();
    }

    @Override
    public List<Pipeline> listByDestinationWithoutOther(String destination) {
        Assert.assertNotNull((Object)destination);
        ArrayList<Pipeline> pipelines = new ArrayList();
        try {
            List<PipelineDO> pipelineDos = this.pipelineDao.listByDestinationCondition(destination);
            if (pipelineDos.isEmpty()) {
                logger.debug("DEBUG ## query pipeline by destination:" + destination + " return null.");
                return pipelines;
            }
            pipelines = this.doToModelWithoutOther(pipelineDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query pipelines by destination:" + destination + " has an exception!");
            throw new ManagerException(e);
        }
        return pipelines;
    }

    private Pipeline doToModel(PipelineDO pipelineDo) {
        Pipeline pipeline = new Pipeline();
        try {
            pipeline.setId(pipelineDo.getId());
            pipeline.setName(pipelineDo.getName());
            pipeline.setParameters(pipelineDo.getParameters());
            pipeline.setDescription(pipelineDo.getDescription());
            pipeline.setGmtCreate(pipelineDo.getGmtCreate());
            pipeline.setGmtModified(pipelineDo.getGmtModified());
            pipeline.setChannelId(pipelineDo.getChannelId());
            pipeline.getParameters().setMainstemClientId(pipeline.getId().shortValue());
            List<DataMediaPair> pairs = this.dataMediaPairService.listByPipelineId(pipelineDo.getId());
            Collections.sort(pairs, new DataMediaPairComparable());
            pipeline.setPairs(pairs);
            List<PipelineNodeRelationDO> relations = this.pipelineNodeRelationDao.listByPipelineIds(pipelineDo.getId());
            ArrayList<Long> totalNodeIds = new ArrayList<Long>();
            for (PipelineNodeRelationDO relation : relations) {
                Long nodeId = relation.getNodeId();
                if (totalNodeIds.contains(nodeId)) continue;
                totalNodeIds.add(nodeId);
            }
            List totalNodes = this.nodeService.listByIds(totalNodeIds.toArray(new Long[totalNodeIds.size()]));
            ArrayList<Node> selectNodes = new ArrayList<Node>();
            ArrayList<Node> extractNodes = new ArrayList<Node>();
            ArrayList<Node> loadNodes = new ArrayList<Node>();
            for (Node node : totalNodes) {
                for (PipelineNodeRelationDO relation : relations) {
                    if (!node.getId().equals(relation.getNodeId())) continue;
                    if (relation.getLocation().isSelect()) {
                        selectNodes.add(node);
                        continue;
                    }
                    if (relation.getLocation().isExtract()) {
                        extractNodes.add(node);
                        continue;
                    }
                    if (!relation.getLocation().isLoad()) continue;
                    loadNodes.add(node);
                }
            }
            pipeline.setSelectNodes(selectNodes);
            pipeline.setExtractNodes(extractNodes);
            pipeline.setLoadNodes(loadNodes);
        }
        catch (Exception e) {
            logger.error("ERROR ## change the pipeline Do to Model has an exception");
            throw new ManagerException(e);
        }
        return pipeline;
    }

    private Pipeline doToModelWithoutColumn(PipelineDO pipelineDo) {
        Pipeline pipeline = new Pipeline();
        try {
            pipeline.setId(pipelineDo.getId());
            pipeline.setName(pipelineDo.getName());
            pipeline.setParameters(pipelineDo.getParameters());
            pipeline.setDescription(pipelineDo.getDescription());
            pipeline.setGmtCreate(pipelineDo.getGmtCreate());
            pipeline.setGmtModified(pipelineDo.getGmtModified());
            pipeline.setChannelId(pipelineDo.getChannelId());
            pipeline.getParameters().setMainstemClientId(pipeline.getId().shortValue());
            List<DataMediaPair> pairs = this.dataMediaPairService.listByPipelineIdWithoutColumn(pipelineDo.getId());
            Collections.sort(pairs, new DataMediaPairComparable());
            pipeline.setPairs(pairs);
            List<PipelineNodeRelationDO> relations = this.pipelineNodeRelationDao.listByPipelineIds(pipelineDo.getId());
            ArrayList<Long> totalNodeIds = new ArrayList<Long>();
            for (PipelineNodeRelationDO relation : relations) {
                Long nodeId = relation.getNodeId();
                if (totalNodeIds.contains(nodeId)) continue;
                totalNodeIds.add(nodeId);
            }
            List totalNodes = this.nodeService.listByIds(totalNodeIds.toArray(new Long[totalNodeIds.size()]));
            ArrayList<Node> selectNodes = new ArrayList<Node>();
            ArrayList<Node> extractNodes = new ArrayList<Node>();
            ArrayList<Node> loadNodes = new ArrayList<Node>();
            for (Node node : totalNodes) {
                for (PipelineNodeRelationDO relation : relations) {
                    if (!node.getId().equals(relation.getNodeId())) continue;
                    if (relation.getLocation().isSelect()) {
                        selectNodes.add(node);
                        continue;
                    }
                    if (relation.getLocation().isExtract()) {
                        extractNodes.add(node);
                        continue;
                    }
                    if (!relation.getLocation().isLoad()) continue;
                    loadNodes.add(node);
                }
            }
            pipeline.setSelectNodes(selectNodes);
            pipeline.setExtractNodes(extractNodes);
            pipeline.setLoadNodes(loadNodes);
        }
        catch (Exception e) {
            logger.error("ERROR ## change the pipeline Do to Model has an exception");
            throw new ManagerException(e);
        }
        return pipeline;
    }

    private Pipeline doToModelWithoutOther(PipelineDO pipelineDo) {
        Pipeline pipeline = new Pipeline();
        try {
            pipeline.setId(pipelineDo.getId());
            pipeline.setName(pipelineDo.getName());
            pipeline.setParameters(pipelineDo.getParameters());
            pipeline.setDescription(pipelineDo.getDescription());
            pipeline.setGmtCreate(pipelineDo.getGmtCreate());
            pipeline.setGmtModified(pipelineDo.getGmtModified());
            pipeline.setChannelId(pipelineDo.getChannelId());
            pipeline.getParameters().setMainstemClientId(pipeline.getId().shortValue());
        }
        catch (Exception e) {
            logger.error("ERROR ## change the pipeline Do to Model has an exception");
            throw new ManagerException(e);
        }
        return pipeline;
    }

    private List<Pipeline> doToModel(List<PipelineDO> pipelineDos) {
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>();
        for (PipelineDO pipelineDo : pipelineDos) {
            pipelines.add(this.doToModel(pipelineDo));
        }
        return pipelines;
    }

    private List<Pipeline> doToModelWithoutOther(List<PipelineDO> pipelineDos) {
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>();
        for (PipelineDO pipelineDo : pipelineDos) {
            pipelines.add(this.doToModelWithoutOther(pipelineDo));
        }
        return pipelines;
    }

    private List<Pipeline> doToModelWithoutColumn(List<PipelineDO> pipelineDos) {
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>();
        for (PipelineDO pipelineDo : pipelineDos) {
            pipelines.add(this.doToModelWithoutColumn(pipelineDo));
        }
        return pipelines;
    }

    private PipelineDO modelToDo(Pipeline pipeline) {
        PipelineDO pipelineDO = new PipelineDO();
        try {
            pipelineDO.setId(pipeline.getId());
            pipelineDO.setName(pipeline.getName());
            pipelineDO.setParameters(pipeline.getParameters());
            pipelineDO.setDescription(pipeline.getDescription());
            pipelineDO.setChannelId(pipeline.getChannelId());
            pipelineDO.setGmtCreate(pipeline.getGmtCreate());
            pipelineDO.setGmtModified(pipeline.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## change the pipeline Model to Do has an exception");
            throw new ManagerException(e);
        }
        return pipelineDO;
    }

    public void setPipelineDao(PipelineDAO pipelineDao) {
        this.pipelineDao = pipelineDao;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPipelineNodeRelationDao(PipelineNodeRelationDAO pipelineNodeRelationDao) {
        this.pipelineNodeRelationDao = pipelineNodeRelationDao;
    }

    public void setDataMediaPairService(DataMediaPairService dataMediaPairService) {
        this.dataMediaPairService = dataMediaPairService;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setArbitrateManageService(ArbitrateManageService arbitrateManageService) {
        this.arbitrateManageService = arbitrateManageService;
    }

    public void setArbitrateViewService(ArbitrateViewService arbitrateViewService) {
        this.arbitrateViewService = arbitrateViewService;
    }
}

