/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.config.parameter.impl;

import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.config.parameter.SystemParameterService;
import com.alibaba.otter.manager.biz.config.parameter.dal.SystemParameterDAO;
import com.alibaba.otter.manager.biz.config.parameter.dal.dataobject.SystemParameterDO;
import com.alibaba.otter.shared.common.model.config.parameter.SystemParameter;
import com.alibaba.otter.shared.common.utils.Assert;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemParameterServiceImpl
implements SystemParameterService {
    private static final Logger logger = LoggerFactory.getLogger(SystemParameterServiceImpl.class);
    private SystemParameterDAO systemParameterDao;

    @Override
    public void createOrUpdate(SystemParameter systemParameter) {
        Assert.assertNotNull((Object)systemParameter);
        try {
            SystemParameterDO systemParameterDo = this.modelToDo(systemParameter);
            systemParameterDo.setId(1L);
            this.systemParameterDao.insert(systemParameterDo);
        }
        catch (Exception e) {
            logger.error("ERROR ## create SystemParameter has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public SystemParameter find() {
        List systemParameterDos = this.systemParameterDao.listAll();
        if (systemParameterDos.isEmpty()) {
            logger.debug("DEBUG ## couldn't query any SystemParameter, maybe hasn't create any SystemParameter.");
            return new SystemParameter();
        }
        return this.doToModel((SystemParameterDO)systemParameterDos.get(0));
    }

    private SystemParameterDO modelToDo(SystemParameter systemParameter) {
        SystemParameterDO systemParameterDo = new SystemParameterDO();
        systemParameterDo.setValue(systemParameter);
        systemParameterDo.setGmtCreate(new Date());
        systemParameterDo.setGmtModified(new Date());
        return systemParameterDo;
    }

    private SystemParameter doToModel(SystemParameterDO systemParameterDo) {
        return systemParameterDo.getValue();
    }

    public void setsystemParameterDao(SystemParameterDAO systemParameterDao) {
        this.systemParameterDao = systemParameterDao;
    }
}

