/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.config.node.impl;

import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.common.exceptions.RepeatConfigureException;
import com.alibaba.otter.manager.biz.config.autokeeper.AutoKeeperClusterService;
import com.alibaba.otter.manager.biz.config.node.NodeService;
import com.alibaba.otter.manager.biz.config.node.dal.NodeDAO;
import com.alibaba.otter.manager.biz.config.node.dal.dataobject.NodeDO;
import com.alibaba.otter.shared.arbitrate.ArbitrateManageService;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperCluster;
import com.alibaba.otter.shared.common.model.config.node.Node;
import com.alibaba.otter.shared.common.model.config.node.NodeParameter;
import com.alibaba.otter.shared.common.model.config.node.NodeStatus;
import com.alibaba.otter.shared.common.utils.Assert;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class NodeServiceImpl
implements NodeService {
    private static final Logger logger = LoggerFactory.getLogger(NodeServiceImpl.class);
    private NodeDAO nodeDao;
    private TransactionTemplate transactionTemplate;
    private ArbitrateManageService arbitrateManageService;
    private AutoKeeperClusterService autoKeeperClusterService;

    @Override
    public void create(final Node node) {
        Assert.assertNotNull((Object)node);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    NodeDO nodeDo = NodeServiceImpl.this.modelToDo(node);
                    nodeDo.setId(0L);
                    if (!NodeServiceImpl.this.nodeDao.checkUnique(nodeDo)) {
                        String exceptionCause = "exist the same repeat node in the database.";
                        logger.warn("WARN ## " + exceptionCause);
                        throw new RepeatConfigureException(exceptionCause);
                    }
                    NodeServiceImpl.this.nodeDao.insert(nodeDo);
                }
                catch (RepeatConfigureException rce) {
                    throw rce;
                }
                catch (Exception e) {
                    logger.error("ERROR ## create node has an exception!");
                    throw new ManagerException(e);
                }
            }
        });
    }

    @Override
    public void remove(final Long nodeId) {
        Assert.assertNotNull((Object)nodeId);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    NodeServiceImpl.this.nodeDao.delete(nodeId);
                }
                catch (Exception e) {
                    logger.error("ERROR ## remove node(" + nodeId + ") has an exception!");
                    throw new ManagerException(e);
                }
            }
        });
    }

    @Override
    public void modify(final Node node) {
        Assert.assertNotNull((Object)node);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    NodeDO nodeDo = NodeServiceImpl.this.modelToDo(node);
                    if (!NodeServiceImpl.this.nodeDao.checkUnique(nodeDo)) {
                        String exceptionCause = "exist the same repeat node in the database.";
                        logger.warn("WARN ## " + exceptionCause);
                        throw new RepeatConfigureException(exceptionCause);
                    }
                    NodeServiceImpl.this.nodeDao.update(nodeDo);
                }
                catch (RepeatConfigureException rce) {
                    throw rce;
                }
                catch (Exception e) {
                    logger.error("ERROR ## modify node(" + node.getId() + ") has an exception!");
                    throw new ManagerException(e);
                }
            }
        });
    }

    @Override
    public List<Node> listAll() {
        return this.listByIds(new Long[0]);
    }

    @Override
    public Node findById(Long nodeId) {
        Assert.assertNotNull((Object)nodeId);
        List<Node> nodes = this.listByIds(nodeId);
        if (nodes.size() != 1) {
            String exceptionCause = "query nodeId:" + nodeId + " return null.";
            logger.error("ERROR ## " + exceptionCause);
            throw new ManagerException(exceptionCause);
        }
        return nodes.get(0);
    }

    @Override
    public List<Node> listByIds(Long ... identities) {
        List<Node> nodes = new ArrayList<Node>();
        try {
            List<NodeDO> nodeDos = null;
            if (identities.length < 1) {
                nodeDos = this.nodeDao.listAll();
                if (nodeDos.isEmpty()) {
                    logger.debug("DEBUG ## couldn't query any node, maybe hasn't create any channel.");
                    return nodes;
                }
            } else {
                nodeDos = this.nodeDao.listByMultiId(identities);
                if (nodeDos.isEmpty()) {
                    String exceptionCause = "couldn't query any node by nodeIds:" + Arrays.toString((Object[])identities);
                    logger.error("ERROR ## " + exceptionCause);
                    throw new ManagerException(exceptionCause);
                }
            }
            List nodeIds = this.arbitrateManageService.nodeEvent().liveNodes();
            for (NodeDO nodeDo : nodeDos) {
                if (nodeIds.contains(nodeDo.getId())) {
                    nodeDo.setStatus(NodeStatus.START);
                    continue;
                }
                nodeDo.setStatus(NodeStatus.STOP);
            }
            nodes = this.doToModel(nodeDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query nodes has an exception!");
            throw new ManagerException(e);
        }
        return nodes;
    }

    @Override
    public int getCount() {
        return this.nodeDao.getCount();
    }

    @Override
    public int getCount(Map condition) {
        return this.nodeDao.getCount(condition);
    }

    @Override
    public List<Node> listByCondition(Map condition) {
        List<NodeDO> nodeDos = this.nodeDao.listByCondition(condition);
        if (nodeDos.isEmpty()) {
            logger.debug("DEBUG ## couldn't query any node by the condition:" + JsonUtils.marshalToString((Object)condition));
            return new ArrayList<Node>();
        }
        List nodeIds = this.arbitrateManageService.nodeEvent().liveNodes();
        for (NodeDO nodeDo : nodeDos) {
            if (null != nodeIds && nodeIds.contains(nodeDo.getId())) {
                nodeDo.setStatus(NodeStatus.START);
                continue;
            }
            nodeDo.setStatus(NodeStatus.STOP);
        }
        return this.doToModel(nodeDos);
    }

    private NodeDO modelToDo(Node node) {
        NodeDO nodeDo = new NodeDO();
        try {
            nodeDo.setId(node.getId());
            nodeDo.setIp(node.getIp());
            nodeDo.setName(node.getName());
            nodeDo.setPort(node.getPort());
            nodeDo.setDescription(node.getDescription());
            nodeDo.setStatus(node.getStatus());
            nodeDo.setParameters(node.getParameters());
            nodeDo.setGmtCreate(node.getGmtCreate());
            nodeDo.setGmtModified(node.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## change the node Model to Do has an exception");
            throw new ManagerException(e);
        }
        return nodeDo;
    }

    private Node doToModel(NodeDO nodeDo) {
        Node node = new Node();
        try {
            node.setId(nodeDo.getId());
            node.setIp(nodeDo.getIp());
            node.setName(nodeDo.getName());
            node.setPort(nodeDo.getPort());
            node.setDescription(nodeDo.getDescription());
            node.setStatus(nodeDo.getStatus());
            NodeParameter parameter = nodeDo.getParameters();
            if (parameter.getZkCluster() != null) {
                AutoKeeperCluster zkCluster = this.autoKeeperClusterService.findAutoKeeperClusterById(parameter.getZkCluster().getId());
                parameter.setZkCluster(zkCluster);
            }
            node.setParameters(parameter);
            node.setGmtCreate(nodeDo.getGmtCreate());
            node.setGmtModified(nodeDo.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## change the node Do to Model has an exception");
            throw new ManagerException(e);
        }
        return node;
    }

    private List<Node> doToModel(List<NodeDO> nodeDos) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (NodeDO nodeDo : nodeDos) {
            nodes.add(this.doToModel(nodeDo));
        }
        return nodes;
    }

    public void setNodeDao(NodeDAO nodeDao) {
        this.nodeDao = nodeDao;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setArbitrateManageService(ArbitrateManageService arbitrateManageService) {
        this.arbitrateManageService = arbitrateManageService;
    }

    public void setAutoKeeperClusterService(AutoKeeperClusterService autoKeeperClusterService) {
        this.autoKeeperClusterService = autoKeeperClusterService;
    }
}

