/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.config.datamediasource.impl;

import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.common.exceptions.RepeatConfigureException;
import com.alibaba.otter.manager.biz.config.datamediasource.DataMediaSourceService;
import com.alibaba.otter.manager.biz.config.datamediasource.dal.DataMediaSourceDAO;
import com.alibaba.otter.manager.biz.config.datamediasource.dal.dataobject.DataMediaSourceDO;
import com.alibaba.otter.shared.common.model.config.data.DataMediaSource;
import com.alibaba.otter.shared.common.model.config.data.db.DbMediaSource;
import com.alibaba.otter.shared.common.model.config.data.mq.MqMediaSource;
import com.alibaba.otter.shared.common.utils.Assert;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMediaSourceServiceImpl
implements DataMediaSourceService {
    private static final Logger logger = LoggerFactory.getLogger(DataMediaSourceServiceImpl.class);
    private DataMediaSourceDAO dataMediaSourceDao;

    @Override
    public void create(DataMediaSource dataMediaSource) {
        Assert.assertNotNull((Object)dataMediaSource);
        try {
            DataMediaSourceDO dataMediaSourceDo = this.modelToDo(dataMediaSource);
            dataMediaSourceDo.setId(0L);
            if (!this.dataMediaSourceDao.checkUnique(dataMediaSourceDo)) {
                String exceptionCause = "exist the same name source in the database.";
                logger.warn("WARN ## " + exceptionCause);
                throw new RepeatConfigureException(exceptionCause);
            }
            this.dataMediaSourceDao.insert(dataMediaSourceDo);
        }
        catch (RepeatConfigureException rce) {
            throw rce;
        }
        catch (Exception e) {
            logger.error("ERROR ## create dataMediaSource has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public void remove(Long dataMediaSourceId) {
        Assert.assertNotNull((Object)dataMediaSourceId);
        try {
            this.dataMediaSourceDao.delete(dataMediaSourceId);
        }
        catch (Exception e) {
            logger.error("ERROR ## remove dataMediaSource has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public void modify(DataMediaSource dataMediaSource) {
        Assert.assertNotNull((Object)dataMediaSource);
        try {
            DataMediaSourceDO dataMediaSourceDo = this.modelToDo(dataMediaSource);
            if (!this.dataMediaSourceDao.checkUnique(dataMediaSourceDo)) {
                String exceptionCause = "exist the same name source in the database.";
                logger.warn("WARN ## " + exceptionCause);
                throw new RepeatConfigureException(exceptionCause);
            }
            this.dataMediaSourceDao.update(dataMediaSourceDo);
        }
        catch (RepeatConfigureException rce) {
            throw rce;
        }
        catch (Exception e) {
            logger.error("ERROR ## modify dataMediaSource has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public List<DataMediaSource> listAll() {
        return this.listByIds(new Long[0]);
    }

    @Override
    public List<DataMediaSource> listByCondition(Map condition) {
        ArrayList<DataMediaSource> dataMediaSources = new ArrayList();
        try {
            List<DataMediaSourceDO> dataMediaSourceDos = this.dataMediaSourceDao.listByCondition(condition);
            if (dataMediaSourceDos.isEmpty()) {
                logger.debug("DEBUG ## couldn't query any DataMediaSources by the condition:" + JsonUtils.marshalToString((Object)condition));
                return dataMediaSources;
            }
            dataMediaSources = this.doToModel(dataMediaSourceDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query DataMediaSources by condition has an exception!");
            throw new ManagerException(e);
        }
        return dataMediaSources;
    }

    @Override
    public List<DataMediaSource> listByIds(Long ... identities) {
        List<DataMediaSourceDO> dataMediaSourceDos = null;
        if (identities.length < 1) {
            dataMediaSourceDos = this.dataMediaSourceDao.listAll();
            if (dataMediaSourceDos.isEmpty()) {
                logger.debug("DEBUG ## couldn't query any dataMediaSource, maybe hasn't create any dataMediaSource.");
                return new ArrayList<DataMediaSource>();
            }
        } else {
            dataMediaSourceDos = this.dataMediaSourceDao.listByMultiId(identities);
            if (dataMediaSourceDos.isEmpty()) {
                String exceptionCause = "couldn't query any dataMediaSource by dataMediaSourceIds:" + Arrays.toString((Object[])identities);
                logger.error("ERROR ## " + exceptionCause);
                throw new ManagerException(exceptionCause);
            }
        }
        return this.doToModel(dataMediaSourceDos);
    }

    @Override
    public DataMediaSource findById(Long dataMediaSourceId) {
        Assert.assertNotNull((Object)dataMediaSourceId);
        List<DataMediaSource> dataMediaSources = this.listByIds(dataMediaSourceId);
        if (dataMediaSources.size() != 1) {
            String exceptionCause = "query dataMediaSourceId:" + dataMediaSourceId + " but return " + dataMediaSources.size() + " dataMediaSource.";
            logger.error("ERROR ## " + exceptionCause);
            throw new ManagerException(exceptionCause);
        }
        return dataMediaSources.get(0);
    }

    @Override
    public int getCount() {
        return this.dataMediaSourceDao.getCount();
    }

    @Override
    public int getCount(Map condition) {
        return this.dataMediaSourceDao.getCount(condition);
    }

    private DataMediaSourceDO modelToDo(DataMediaSource dataMediaSource) {
        DataMediaSourceDO dataMediaSourceDo = new DataMediaSourceDO();
        try {
            dataMediaSourceDo.setId(dataMediaSource.getId());
            dataMediaSourceDo.setName(dataMediaSource.getName());
            dataMediaSourceDo.setType(dataMediaSource.getType());
            if (dataMediaSource instanceof DbMediaSource) {
                dataMediaSourceDo.setProperties(JsonUtils.marshalToString((Object)((DbMediaSource)dataMediaSource)));
            } else if (dataMediaSource instanceof MqMediaSource) {
                dataMediaSourceDo.setProperties(JsonUtils.marshalToString((Object)((MqMediaSource)dataMediaSource)));
            }
            dataMediaSourceDo.setGmtCreate(dataMediaSource.getGmtCreate());
            dataMediaSourceDo.setGmtModified(dataMediaSource.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## change the dataMediaSource Model to Do has an exception");
            throw new ManagerException(e);
        }
        return dataMediaSourceDo;
    }

    private DataMediaSource doToModel(DataMediaSourceDO dataMediaSourceDo) {
        DbMediaSource dataMediaSource = new DbMediaSource();
        try {
            if (dataMediaSourceDo.getType().isMysql() || dataMediaSourceDo.getType().isOracle()) {
                dataMediaSource = (DataMediaSource)JsonUtils.unmarshalFromString((String)dataMediaSourceDo.getProperties(), DbMediaSource.class);
            } else if (dataMediaSourceDo.getType().isNapoli() || dataMediaSourceDo.getType().isMq()) {
                dataMediaSource = (DataMediaSource)JsonUtils.unmarshalFromString((String)dataMediaSourceDo.getProperties(), MqMediaSource.class);
            }
            dataMediaSource.setId(dataMediaSourceDo.getId());
            dataMediaSource.setGmtCreate(dataMediaSourceDo.getGmtCreate());
            dataMediaSource.setGmtModified(dataMediaSourceDo.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## change the dataMediaSource Do to Model has an exception");
            throw new ManagerException(e);
        }
        return dataMediaSource;
    }

    private List<DataMediaSource> doToModel(List<DataMediaSourceDO> dataMediaSourceDos) {
        ArrayList<DataMediaSource> dataMediaSources = new ArrayList<DataMediaSource>();
        for (DataMediaSourceDO dataMediaSourceDo : dataMediaSourceDos) {
            dataMediaSources.add(this.doToModel(dataMediaSourceDo));
        }
        return dataMediaSources;
    }

    public void setDataMediaSourceDao(DataMediaSourceDAO dataMediaSourceDao) {
        this.dataMediaSourceDao = dataMediaSourceDao;
    }
}

