/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.config.datamediapair.impl;

import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.common.exceptions.RepeatConfigureException;
import com.alibaba.otter.manager.biz.config.datacolumnpair.DataColumnPairGroupService;
import com.alibaba.otter.manager.biz.config.datacolumnpair.DataColumnPairService;
import com.alibaba.otter.manager.biz.config.datamedia.DataMediaService;
import com.alibaba.otter.manager.biz.config.datamediapair.DataMediaPairService;
import com.alibaba.otter.manager.biz.config.datamediapair.dal.DataMediaPairDAO;
import com.alibaba.otter.manager.biz.config.datamediapair.dal.dataobject.DataMediaPairDO;
import com.alibaba.otter.shared.common.model.config.data.ColumnGroup;
import com.alibaba.otter.shared.common.model.config.data.ColumnPair;
import com.alibaba.otter.shared.common.model.config.data.DataMedia;
import com.alibaba.otter.shared.common.model.config.data.DataMediaPair;
import com.alibaba.otter.shared.common.model.config.data.ExtensionData;
import com.alibaba.otter.shared.common.utils.Assert;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMediaPairServiceImpl
implements DataMediaPairService {
    private static final Logger logger = LoggerFactory.getLogger(DataMediaPairServiceImpl.class);
    private DataMediaPairDAO dataMediaPairDao;
    private DataMediaService dataMediaService;
    private DataColumnPairService dataColumnPairService;
    private DataColumnPairGroupService dataColumnPairGroupService;

    @Override
    public void create(DataMediaPair dataMediaPair) {
        this.createAndReturnId(dataMediaPair);
    }

    @Override
    public Long createAndReturnId(DataMediaPair dataMediaPair) {
        Assert.assertNotNull((Object)dataMediaPair);
        try {
            DataMediaPairDO dataMediaPairDo = this.modelToDo(dataMediaPair);
            dataMediaPairDo.setId(0L);
            if (!this.dataMediaPairDao.checkUnique(dataMediaPairDo)) {
                String exceptionCause = "exist the same pair in the database.";
                logger.warn("WARN ## " + exceptionCause);
                throw new RepeatConfigureException(exceptionCause);
            }
            this.dataMediaPairDao.insert(dataMediaPairDo);
            return dataMediaPairDo.getId();
        }
        catch (RepeatConfigureException rcf) {
            throw rcf;
        }
        catch (Exception e) {
            logger.error("ERROR ## create dataMediaPair has an exception!", (Throwable)e);
            throw new ManagerException(e);
        }
    }

    @Override
    public boolean createIfNotExist(DataMediaPair dataMediaPair) {
        Assert.assertNotNull((Object)dataMediaPair);
        try {
            DataMediaPairDO dataMediaPairDo = this.modelToDo(dataMediaPair);
            dataMediaPairDo.setId(0L);
            if (!this.dataMediaPairDao.checkUnique(dataMediaPairDo)) {
                return false;
            }
            this.dataMediaPairDao.insert(dataMediaPairDo);
            return true;
        }
        catch (Exception e) {
            logger.error("ERROR ## create dataMediaPair has an exception!", (Throwable)e);
            throw new ManagerException(e);
        }
    }

    @Override
    public void remove(Long dataMediaPairId) {
        Assert.assertNotNull((Object)dataMediaPairId);
        try {
            this.dataMediaPairDao.delete(dataMediaPairId);
        }
        catch (Exception e) {
            logger.error("ERROR ## remove dataMediaPair has an exception!", (Throwable)e);
            throw new ManagerException(e);
        }
    }

    @Override
    public void modify(DataMediaPair dataMediaPair) {
        Assert.assertNotNull((Object)dataMediaPair);
        try {
            DataMediaPairDO dataMediaPairDo = this.modelToDo(dataMediaPair);
            if (!this.dataMediaPairDao.checkUnique(dataMediaPairDo)) {
                String exceptionCause = "exist the same pair in the database.";
                logger.warn("WARN ## " + exceptionCause);
                throw new RepeatConfigureException(exceptionCause);
            }
            this.dataMediaPairDao.update(dataMediaPairDo);
        }
        catch (RepeatConfigureException rce) {
            throw rce;
        }
        catch (Exception e) {
            logger.error("ERROR ## modify dataMediaPair has an exception!", (Throwable)e);
            throw new ManagerException(e);
        }
    }

    @Override
    public List<DataMediaPair> listByIds(Long ... identities) {
        List<DataMediaPair> dataMediaPairs = new ArrayList<DataMediaPair>();
        try {
            List<DataMediaPairDO> dataMediaPairDos = null;
            if (identities.length < 1) {
                dataMediaPairDos = this.dataMediaPairDao.listAll();
                if (dataMediaPairDos.isEmpty()) {
                    logger.debug("DEBUG ## couldn't query any dataMediaPair, maybe hasn't create any dataMediaPair.");
                    return dataMediaPairs;
                }
            } else {
                dataMediaPairDos = this.dataMediaPairDao.listByMultiId(identities);
                if (dataMediaPairDos.isEmpty()) {
                    String exceptionCause = "couldn't query any dataMediaPair by dataMediaPairIds:" + Arrays.toString((Object[])identities);
                    logger.error("ERROR ## " + exceptionCause);
                    throw new ManagerException(exceptionCause);
                }
            }
            dataMediaPairs = this.doToModel(dataMediaPairDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query dataMediaPairs has an exception!", (Throwable)e);
            throw new ManagerException(e);
        }
        return dataMediaPairs;
    }

    @Override
    public List<DataMediaPair> listAll() {
        return this.listByIds(new Long[0]);
    }

    @Override
    public List<DataMediaPair> listByCondition(Map condition) {
        ArrayList<DataMediaPair> dataMediaPairs = new ArrayList();
        try {
            List<DataMediaPairDO> dataMediaPairDos = this.dataMediaPairDao.listByCondition(condition);
            if (dataMediaPairDos.isEmpty()) {
                logger.debug("DEBUG ## couldn't query any DataMediaPairs by the condition:" + JsonUtils.marshalToString((Object)condition));
                return dataMediaPairs;
            }
            dataMediaPairs = this.doToModel(dataMediaPairDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query dataMediaPairs by condition has an exception!", (Throwable)e);
            throw new ManagerException(e);
        }
        return dataMediaPairs;
    }

    @Override
    public DataMediaPair findById(Long dataMediaPairId) {
        Assert.assertNotNull((Object)dataMediaPairId);
        List<DataMediaPair> dataMediaPairs = this.listByIds(dataMediaPairId);
        if (dataMediaPairs.size() != 1) {
            String exceptionCause = "query dataMediaPairId:" + dataMediaPairId + " but return " + dataMediaPairs.size() + " Pairs.";
            logger.error("ERROR ## " + exceptionCause);
            throw new ManagerException(exceptionCause);
        }
        return dataMediaPairs.get(0);
    }

    @Override
    public List<DataMediaPair> listByPipelineId(Long pipelineId) {
        Assert.assertNotNull((Object)pipelineId);
        List<DataMediaPair> dataMediaPairs = new ArrayList<DataMediaPair>();
        try {
            List<DataMediaPairDO> dataMediaPairDos = this.dataMediaPairDao.listByPipelineId(pipelineId);
            if (dataMediaPairDos.isEmpty()) {
                logger.debug("DEBUG ## couldn't query any dataMediaPair, maybe hasn't create any dataMediaPair.");
                return dataMediaPairs;
            }
            dataMediaPairs = this.doToModel(dataMediaPairDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query dataMediaPairs by pipelineId:" + pipelineId + " has an exception!", (Throwable)e);
            throw new ManagerException(e);
        }
        return dataMediaPairs;
    }

    @Override
    public List<DataMediaPair> listByPipelineIdWithoutColumn(Long pipelineId) {
        Assert.assertNotNull((Object)pipelineId);
        List<DataMediaPair> dataMediaPairs = new ArrayList<DataMediaPair>();
        try {
            List<DataMediaPairDO> dataMediaPairDos = this.dataMediaPairDao.listByPipelineId(pipelineId);
            if (dataMediaPairDos.isEmpty()) {
                logger.debug("DEBUG ## couldn't query any dataMediaPair, maybe hasn't create any dataMediaPair.");
                return dataMediaPairs;
            }
            dataMediaPairs = this.doToModelWithoutOther(dataMediaPairDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query dataMediaPairs by pipelineId:" + pipelineId + " has an exception!", (Throwable)e);
            throw new ManagerException(e);
        }
        return dataMediaPairs;
    }

    @Override
    public List<DataMediaPair> listByDataMediaId(Long dataMediaId) {
        Assert.assertNotNull((Object)dataMediaId);
        List<DataMediaPair> dataMediaPairs = new ArrayList<DataMediaPair>();
        try {
            List<DataMediaPairDO> dataMediaPairDos = this.dataMediaPairDao.listByDataMediaId(dataMediaId);
            if (dataMediaPairDos.isEmpty()) {
                logger.debug("DEBUG ## couldn't query any dataMediaPair, maybe hasn't create any dataMediaPair.");
                return dataMediaPairs;
            }
            dataMediaPairs = this.doToModel(dataMediaPairDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query dataMediaPairs by dataMediaId:" + dataMediaId + " has an exception!", (Throwable)e);
            throw new ManagerException(e);
        }
        return dataMediaPairs;
    }

    @Override
    public int getCount() {
        return this.dataMediaPairDao.getCount();
    }

    @Override
    public int getCount(Map condition) {
        return this.dataMediaPairDao.getCount(condition);
    }

    private DataMediaPair doToModel(DataMediaPairDO dataMediaPairDo, List<ColumnPair> columnPairs, List<ColumnGroup> columnGroups) {
        DataMediaPair dataMediaPair = new DataMediaPair();
        try {
            dataMediaPair.setId(dataMediaPairDo.getId());
            dataMediaPair.setPipelineId(dataMediaPairDo.getPipelineId());
            dataMediaPair.setPullWeight(dataMediaPairDo.getPullWeight());
            dataMediaPair.setPushWeight(dataMediaPairDo.getPushWeight());
            if (StringUtils.isNotBlank((String)dataMediaPairDo.getFilter())) {
                dataMediaPair.setFilterData((ExtensionData)JsonUtils.unmarshalFromString((String)dataMediaPairDo.getFilter(), ExtensionData.class));
            }
            if (StringUtils.isNotBlank((String)dataMediaPairDo.getResolver())) {
                dataMediaPair.setResolverData((ExtensionData)JsonUtils.unmarshalFromString((String)dataMediaPairDo.getResolver(), ExtensionData.class));
            }
            dataMediaPair.setColumnPairs(columnPairs);
            dataMediaPair.setColumnGroups(columnGroups);
            dataMediaPair.setColumnPairMode(dataMediaPairDo.getColumnPairMode());
            dataMediaPair.setGmtCreate(dataMediaPairDo.getGmtCreate());
            dataMediaPair.setGmtModified(dataMediaPairDo.getGmtModified());
            List dataMedias = this.dataMediaService.listByIds(dataMediaPairDo.getSourceDataMediaId(), dataMediaPairDo.getTargetDataMediaId());
            if (null == dataMedias || dataMedias.size() != 2) {
                return dataMediaPair;
            }
            for (DataMedia dataMedia : dataMedias) {
                if (dataMedia.getId().equals(dataMediaPairDo.getSourceDataMediaId())) {
                    dataMediaPair.setSource(dataMedia);
                    continue;
                }
                if (!dataMedia.getId().equals(dataMediaPairDo.getTargetDataMediaId())) continue;
                dataMediaPair.setTarget(dataMedia);
            }
        }
        catch (Exception e) {
            logger.error("ERROR ## change the dataMediaPair Do to Model has an exception", (Throwable)e);
            throw new ManagerException(e);
        }
        return dataMediaPair;
    }

    private List<DataMediaPair> doToModel(List<DataMediaPairDO> dataMediaPairDos) {
        ArrayList<Long> dataMediaPairIds = new ArrayList<Long>();
        for (DataMediaPairDO dataMediaPairDo : dataMediaPairDos) {
            dataMediaPairIds.add(dataMediaPairDo.getId());
        }
        Map<Long, List<ColumnPair>> columnPairMap = this.dataColumnPairService.listByDataMediaPairIds(dataMediaPairIds.toArray(new Long[dataMediaPairIds.size()]));
        Map<Long, List<ColumnGroup>> columnPairGroupMap = this.dataColumnPairGroupService.listByDataMediaPairIds(dataMediaPairIds.toArray(new Long[dataMediaPairIds.size()]));
        ArrayList<DataMediaPair> dataMediaPairs = new ArrayList<DataMediaPair>();
        for (DataMediaPairDO dataMediaPairDo : dataMediaPairDos) {
            ArrayList<ColumnPair> columnPairs = columnPairMap.get(dataMediaPairDo.getId()) == null ? new ArrayList<ColumnPair>() : columnPairMap.get(dataMediaPairDo.getId());
            ArrayList<ColumnGroup> columnGroups = columnPairGroupMap.get(dataMediaPairDo.getId()) == null ? new ArrayList<ColumnGroup>() : columnPairGroupMap.get(dataMediaPairDo.getId());
            dataMediaPairs.add(this.doToModel(dataMediaPairDo, columnPairs, columnGroups));
        }
        return dataMediaPairs;
    }

    private List<DataMediaPair> doToModelWithoutOther(List<DataMediaPairDO> dataMediaPairDos) {
        ArrayList<DataMediaPair> dataMediaPairs = new ArrayList<DataMediaPair>();
        for (DataMediaPairDO dataMediaPairDo : dataMediaPairDos) {
            dataMediaPairs.add(this.doToModel(dataMediaPairDo, null, null));
        }
        return dataMediaPairs;
    }

    private DataMediaPairDO modelToDo(DataMediaPair dataMediaPair) {
        DataMediaPairDO dataMediaPairDo = new DataMediaPairDO();
        try {
            dataMediaPairDo.setId(dataMediaPair.getId());
            dataMediaPairDo.setPipelineId(dataMediaPair.getPipelineId());
            dataMediaPairDo.setSourceDataMediaId(dataMediaPair.getSource().getId());
            dataMediaPairDo.setTargetDataMediaId(dataMediaPair.getTarget().getId());
            dataMediaPairDo.setFilter(JsonUtils.marshalToString((Object)dataMediaPair.getFilterData()));
            dataMediaPairDo.setResolver(JsonUtils.marshalToString((Object)dataMediaPair.getResolverData()));
            dataMediaPairDo.setPullWeight(dataMediaPair.getPullWeight());
            dataMediaPairDo.setPushWeight(dataMediaPair.getPushWeight());
            dataMediaPairDo.setColumnPairMode(dataMediaPair.getColumnPairMode());
            dataMediaPairDo.setGmtCreate(dataMediaPair.getGmtCreate());
            dataMediaPairDo.setGmtModified(dataMediaPair.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## change the dataMediaPair Model to Do has an exception", (Throwable)e);
            throw new ManagerException(e);
        }
        return dataMediaPairDo;
    }

    public void setDataMediaPairDao(DataMediaPairDAO dataMediaPairDao) {
        this.dataMediaPairDao = dataMediaPairDao;
    }

    public void setDataMediaService(DataMediaService dataMediaService) {
        this.dataMediaService = dataMediaService;
    }

    public void setDataColumnPairService(DataColumnPairService dataColumnPairService) {
        this.dataColumnPairService = dataColumnPairService;
    }

    public void setDataColumnPairGroupService(DataColumnPairGroupService dataColumnPairGroupService) {
        this.dataColumnPairGroupService = dataColumnPairGroupService;
    }
}

