/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.config.datamedia.impl;

import com.alibaba.otter.manager.biz.common.DataSourceCreator;
import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.common.exceptions.RepeatConfigureException;
import com.alibaba.otter.manager.biz.config.datamedia.DataMediaService;
import com.alibaba.otter.manager.biz.config.datamedia.dal.DataMediaDAO;
import com.alibaba.otter.manager.biz.config.datamedia.dal.dataobject.DataMediaDO;
import com.alibaba.otter.manager.biz.config.datamediasource.DataMediaSourceService;
import com.alibaba.otter.shared.common.model.config.data.DataMedia;
import com.alibaba.otter.shared.common.model.config.data.DataMediaSource;
import com.alibaba.otter.shared.common.model.config.data.db.DbDataMedia;
import com.alibaba.otter.shared.common.model.config.data.mq.MqDataMedia;
import com.alibaba.otter.shared.common.utils.Assert;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import com.alibaba.otter.shared.common.utils.meta.DdlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class DataMediaServiceImpl
implements DataMediaService {
    private static final Logger logger = LoggerFactory.getLogger(DataMediaServiceImpl.class);
    private DataMediaDAO dataMediaDao;
    private DataMediaSourceService dataMediaSourceService;
    private DataSourceCreator dataSourceCreator;

    @Override
    public List<String> queryColumnByMediaId(Long dataMediaId) {
        return this.queryColumnByMedia(this.findById(dataMediaId));
    }

    @Override
    public List<String> queryColumnByMedia(DataMedia dataMedia) {
        ArrayList<String> columnResult = new ArrayList<String>();
        if (dataMedia.getSource().getType().isNapoli()) {
            return columnResult;
        }
        DataSource dataSource = this.dataSourceCreator.createDataSource(dataMedia.getSource());
        String schemaName = dataMedia.getNamespaceMode().getSingleValue();
        String tableName = dataMedia.getNameMode().getSingleValue();
        try {
            Table table = DdlUtils.findTable((JdbcTemplate)new JdbcTemplate(dataSource), (String)schemaName, (String)schemaName, (String)tableName);
            for (Column column : table.getColumns()) {
                columnResult.add(column.getName());
            }
        }
        catch (Exception e) {
            logger.error("ERROR ## DdlUtils find table happen error!", (Throwable)e);
        }
        return columnResult;
    }

    @Override
    public void create(DataMedia dataMedia) {
        Assert.assertNotNull((Object)dataMedia);
        try {
            DataMediaDO dataMediaDo = this.modelToDo(dataMedia);
            dataMediaDo.setId(0L);
            if (!this.dataMediaDao.checkUnique(dataMediaDo)) {
                String exceptionCause = "exist the same name dataMedia in the database.";
                logger.warn("WARN ## " + exceptionCause);
                throw new RepeatConfigureException(exceptionCause);
            }
            this.dataMediaDao.insert(dataMediaDo);
        }
        catch (RepeatConfigureException rce) {
            throw rce;
        }
        catch (Exception e) {
            logger.error("ERROR ## create dataMedia has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public Long createReturnId(DataMedia dataMedia) {
        Assert.assertNotNull((Object)dataMedia);
        try {
            DataMediaDO dataMediaDo = this.modelToDo(dataMedia);
            dataMediaDo.setId(0L);
            DataMediaDO dataMediaDoInDb = this.dataMediaDao.checkUniqueAndReturnExist(dataMediaDo);
            dataMediaDo = dataMediaDoInDb == null ? this.dataMediaDao.insert(dataMediaDo) : dataMediaDoInDb;
            return dataMediaDo.getId();
        }
        catch (RepeatConfigureException rce) {
            throw rce;
        }
        catch (Exception e) {
            logger.error("ERROR ## create dataMedia has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public void remove(Long dataMediaId) {
        Assert.assertNotNull((Object)dataMediaId);
        try {
            this.dataMediaDao.delete(dataMediaId);
        }
        catch (Exception e) {
            logger.error("ERROR ## remove dataMedia has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public void modify(DataMedia dataMedia) {
        Assert.assertNotNull((Object)dataMedia);
        try {
            DataMediaDO dataMediaDo = this.modelToDo(dataMedia);
            if (!this.dataMediaDao.checkUnique(dataMediaDo)) {
                String exceptionCause = "exist the same name dataMedia in the database.";
                logger.warn("WARN ## " + exceptionCause);
                throw new RepeatConfigureException(exceptionCause);
            }
            this.dataMediaDao.update(dataMediaDo);
        }
        catch (RepeatConfigureException rce) {
            throw rce;
        }
        catch (Exception e) {
            logger.error("ERROR ## modify dataMedia has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public List<DataMedia> listAll() {
        return this.listByIds(new Long[0]);
    }

    @Override
    public List<DataMedia> listByCondition(Map condition) {
        ArrayList<DataMedia> dataMedias = new ArrayList();
        try {
            List<DataMediaDO> dataMediaDos = this.dataMediaDao.listByCondition(condition);
            if (dataMediaDos.isEmpty()) {
                logger.debug("DEBUG ## couldn't query any dataMedias by the condition:" + JsonUtils.marshalToString((Object)condition));
                return dataMedias;
            }
            dataMedias = this.doToModel(dataMediaDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query dataMedias by condition has an exception!");
            throw new ManagerException(e);
        }
        return dataMedias;
    }

    @Override
    public DataMedia findById(Long dataMediaId) {
        Assert.assertNotNull((Object)dataMediaId);
        List<DataMedia> dataMedias = this.listByIds(dataMediaId);
        if (dataMedias.size() != 1) {
            String exceptionCause = "query dataMediaId:" + dataMediaId + " but return " + dataMedias.size() + " dataMedia.";
            logger.error("ERROR ## " + exceptionCause);
            throw new ManagerException(exceptionCause);
        }
        return dataMedias.get(0);
    }

    @Override
    public List<DataMedia> listByIds(Long ... identities) {
        List<DataMedia> dataMedias = new ArrayList<DataMedia>();
        try {
            List<DataMediaDO> dataMediaDos = null;
            if (identities.length < 1) {
                dataMediaDos = this.dataMediaDao.listAll();
                if (dataMediaDos.isEmpty()) {
                    logger.debug("DEBUG ## couldn't query any dataMedia, maybe hasn't create any dataMedia.");
                    return dataMedias;
                }
            } else {
                dataMediaDos = this.dataMediaDao.listByMultiId(identities);
                if (dataMediaDos.isEmpty()) {
                    String exceptionCause = "couldn't query any dataMedia by dataMediaIds:" + Arrays.toString((Object[])identities);
                    logger.error("ERROR ## " + exceptionCause);
                    throw new ManagerException(exceptionCause);
                }
            }
            dataMedias = this.doToModel(dataMediaDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query dataMedias has an exception!");
            throw new ManagerException(e);
        }
        return dataMedias;
    }

    @Override
    public List<DataMedia> listByDataMediaSourceId(Long dataMediaSourceId) {
        Assert.assertNotNull((Object)dataMediaSourceId);
        List<DataMediaDO> dataMediaDos = null;
        try {
            dataMediaDos = this.dataMediaDao.listByDataMediaSourceId(dataMediaSourceId);
            if (dataMediaDos.isEmpty()) {
                logger.debug("DEBUG ## couldn't query any dataMedia, maybe hasn't create any dataMedia.");
                return new ArrayList<DataMedia>();
            }
        }
        catch (Exception e) {
            logger.error("ERROR ## query dataMedias by sourceId:" + dataMediaSourceId + " has an exception!");
            throw new ManagerException(e);
        }
        return this.doToModel(dataMediaDos);
    }

    @Override
    public int getCount() {
        return this.dataMediaDao.getCount();
    }

    @Override
    public int getCount(Map condition) {
        return this.dataMediaDao.getCount(condition);
    }

    private DataMediaDO modelToDo(DataMedia dataMedia) {
        DataMediaDO dataMediaDo = new DataMediaDO();
        try {
            dataMediaDo.setId(dataMedia.getId());
            dataMediaDo.setName(dataMedia.getName());
            dataMediaDo.setNamespace(dataMedia.getNamespace());
            dataMediaDo.setDataMediaSourceId(dataMedia.getSource().getId());
            dataMediaDo.setProperties(JsonUtils.marshalToString((Object)dataMedia));
            dataMediaDo.setGmtCreate(dataMedia.getGmtCreate());
            dataMediaDo.setGmtModified(dataMedia.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## change the dataMedia Model to Do has an exception");
            throw new ManagerException(e);
        }
        return dataMediaDo;
    }

    private DataMedia doToModel(DataMediaDO dataMediaDo) {
        DataMedia dataMedia = null;
        try {
            DataMediaSource dataMediaSource = (DataMediaSource)this.dataMediaSourceService.findById(dataMediaDo.getDataMediaSourceId());
            if (dataMediaSource.getType().isMysql() || dataMediaSource.getType().isOracle()) {
                dataMedia = (DataMedia)JsonUtils.unmarshalFromString((String)dataMediaDo.getProperties(), DbDataMedia.class);
                dataMedia.setSource(dataMediaSource);
            } else if (dataMediaSource.getType().isNapoli() || dataMediaSource.getType().isMq()) {
                dataMedia = (DataMedia)JsonUtils.unmarshalFromString((String)dataMediaDo.getProperties(), MqDataMedia.class);
                dataMedia.setSource(dataMediaSource);
            }
            dataMedia.setId(dataMediaDo.getId());
            dataMedia.setGmtCreate(dataMediaDo.getGmtCreate());
            dataMedia.setGmtModified(dataMediaDo.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## change the dataMedia Do to Model has an exception");
            throw new ManagerException(e);
        }
        return dataMedia;
    }

    private List<DataMedia> doToModel(List<DataMediaDO> dataMediaDos) {
        ArrayList<DataMedia> dataMedias = new ArrayList<DataMedia>();
        for (DataMediaDO dataMediaDo : dataMediaDos) {
            dataMedias.add(this.doToModel(dataMediaDo));
        }
        return dataMedias;
    }

    public void setDataMediaDao(DataMediaDAO dataMediaDao) {
        this.dataMediaDao = dataMediaDao;
    }

    public void setDataMediaSourceService(DataMediaSourceService dataMediaSourceService) {
        this.dataMediaSourceService = dataMediaSourceService;
    }

    public void setDataSourceCreator(DataSourceCreator dataSourceCreator) {
        this.dataSourceCreator = dataSourceCreator;
    }
}

