/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.config.datamatrix.impl;

import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.common.exceptions.RepeatConfigureException;
import com.alibaba.otter.manager.biz.config.datamatrix.DataMatrixService;
import com.alibaba.otter.manager.biz.config.datamatrix.dal.DataMatrixDAO;
import com.alibaba.otter.manager.biz.config.datamatrix.dal.dataobject.DataMatrixDO;
import com.alibaba.otter.manager.biz.config.node.impl.NodeServiceImpl;
import com.alibaba.otter.shared.common.model.config.data.DataMatrix;
import com.alibaba.otter.shared.common.utils.Assert;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class DataMatrixServiceImpl
implements DataMatrixService {
    private static final Logger logger = LoggerFactory.getLogger(NodeServiceImpl.class);
    private DataMatrixDAO dataMatrixDao;
    private TransactionTemplate transactionTemplate;

    @Override
    public void create(final DataMatrix matrix) {
        Assert.assertNotNull((Object)matrix);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    DataMatrixDO matrixlDO = DataMatrixServiceImpl.this.modelToDo(matrix);
                    matrixlDO.setId(0L);
                    if (!DataMatrixServiceImpl.this.dataMatrixDao.checkUnique(matrixlDO)) {
                        String exceptionCause = "exist the same repeat canal in the database.";
                        logger.warn("WARN ## " + exceptionCause);
                        throw new RepeatConfigureException(exceptionCause);
                    }
                    DataMatrixServiceImpl.this.dataMatrixDao.insert(matrixlDO);
                }
                catch (RepeatConfigureException rce) {
                    throw rce;
                }
                catch (Exception e) {
                    logger.error("ERROR ## create canal has an exception!");
                    throw new ManagerException(e);
                }
            }
        });
    }

    @Override
    public void remove(final Long matrixId) {
        Assert.assertNotNull((Object)matrixId);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    DataMatrixServiceImpl.this.dataMatrixDao.delete(matrixId);
                }
                catch (Exception e) {
                    logger.error("ERROR ## remove canal(" + matrixId + ") has an exception!");
                    throw new ManagerException(e);
                }
            }
        });
    }

    @Override
    public void modify(final DataMatrix matrix) {
        Assert.assertNotNull((Object)matrix);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    DataMatrixDO matrixDo = DataMatrixServiceImpl.this.modelToDo(matrix);
                    if (!DataMatrixServiceImpl.this.dataMatrixDao.checkUnique(matrixDo)) {
                        String exceptionCause = "exist the same repeat matrix in the database.";
                        logger.warn("WARN ## " + exceptionCause);
                        throw new RepeatConfigureException(exceptionCause);
                    }
                    DataMatrixServiceImpl.this.dataMatrixDao.update(matrixDo);
                }
                catch (RepeatConfigureException rce) {
                    throw rce;
                }
                catch (Exception e) {
                    logger.error("ERROR ## modify canal(" + matrix.getId() + ") has an exception!");
                    throw new ManagerException(e);
                }
            }
        });
    }

    @Override
    public List<DataMatrix> listByIds(Long ... identities) {
        List<DataMatrix> matrixs = new ArrayList<DataMatrix>();
        try {
            List<DataMatrixDO> matrixDos = null;
            if (identities.length < 1) {
                matrixDos = this.dataMatrixDao.listAll();
                if (matrixDos.isEmpty()) {
                    logger.debug("DEBUG ## couldn't query any canal, maybe hasn't create any canal.");
                    return matrixs;
                }
            } else {
                matrixDos = this.dataMatrixDao.listByMultiId(identities);
                if (matrixDos.isEmpty()) {
                    String exceptionCause = "couldn't query any canal by matrixIds:" + Arrays.toString((Object[])identities);
                    logger.error("ERROR ## " + exceptionCause);
                    throw new ManagerException(exceptionCause);
                }
            }
            matrixs = this.doToModel(matrixDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query channels has an exception!");
            throw new ManagerException(e);
        }
        return matrixs;
    }

    @Override
    public List<DataMatrix> listAll() {
        return this.listByIds(new Long[0]);
    }

    @Override
    public DataMatrix findById(Long matrixId) {
        Assert.assertNotNull((Object)matrixId);
        List<DataMatrix> canals = this.listByIds(matrixId);
        if (canals.size() != 1) {
            String exceptionCause = "query matrixId:" + matrixId + " return null.";
            logger.error("ERROR ## " + exceptionCause);
            throw new ManagerException(exceptionCause);
        }
        return canals.get(0);
    }

    @Override
    public DataMatrix findByGroupKey(String groupKey) {
        Assert.assertNotNull((Object)groupKey);
        DataMatrixDO matrixDo = this.dataMatrixDao.findByGroupKey(groupKey);
        if (matrixDo == null) {
            String exceptionCause = "query name:" + groupKey + " return null.";
            logger.error("ERROR ## " + exceptionCause);
            throw new ManagerException(exceptionCause);
        }
        return this.doToModel(matrixDo);
    }

    @Override
    public int getCount(Map condition) {
        return this.dataMatrixDao.getCount(condition);
    }

    @Override
    public List<DataMatrix> listByCondition(Map condition) {
        List<DataMatrixDO> matrixDos = this.dataMatrixDao.listByCondition(condition);
        if (matrixDos.isEmpty()) {
            logger.debug("DEBUG ## couldn't query any canal by the condition:" + JsonUtils.marshalToString((Object)condition));
            return new ArrayList<DataMatrix>();
        }
        return this.doToModel(matrixDos);
    }

    private DataMatrixDO modelToDo(DataMatrix matrix) {
        DataMatrixDO matrixDo = new DataMatrixDO();
        try {
            matrixDo.setId(matrix.getId());
            matrixDo.setGroupKey(matrix.getGroupKey());
            matrixDo.setDescription(matrix.getDescription());
            matrixDo.setMaster(matrix.getMaster());
            matrixDo.setSlave(matrix.getSlave());
            matrixDo.setGmtCreate(matrix.getGmtCreate());
            matrixDo.setGmtModified(matrix.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## change the matrix Model to Do has an exception");
            throw new ManagerException(e);
        }
        return matrixDo;
    }

    private DataMatrix doToModel(DataMatrixDO matrixDo) {
        DataMatrix matrix = new DataMatrix();
        try {
            matrix.setId(matrixDo.getId());
            matrix.setGroupKey(matrixDo.getGroupKey());
            matrix.setDescription(matrixDo.getDescription());
            matrix.setMaster(matrixDo.getMaster());
            matrix.setSlave(matrixDo.getSlave());
            matrix.setGmtCreate(matrixDo.getGmtCreate());
            matrix.setGmtModified(matrixDo.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## change the canal Do to Model has an exception");
            throw new ManagerException(e);
        }
        return matrix;
    }

    private List<DataMatrix> doToModel(List<DataMatrixDO> matrixDos) {
        ArrayList<DataMatrix> matrixs = new ArrayList<DataMatrix>();
        for (DataMatrixDO matrixDo : matrixDos) {
            matrixs.add(this.doToModel(matrixDo));
        }
        return matrixs;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setDataMatrixDao(DataMatrixDAO dataMatrixDao) {
        this.dataMatrixDao = dataMatrixDao;
    }
}

