/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.config.datacolumnpair.impl;

import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.common.exceptions.RepeatConfigureException;
import com.alibaba.otter.manager.biz.config.datacolumnpair.DataColumnPairService;
import com.alibaba.otter.manager.biz.config.datacolumnpair.dal.DataColumnPairDAO;
import com.alibaba.otter.manager.biz.config.datacolumnpair.dal.dataobject.DataColumnPairDO;
import com.alibaba.otter.shared.common.model.config.data.Column;
import com.alibaba.otter.shared.common.model.config.data.ColumnPair;
import com.alibaba.otter.shared.common.utils.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataColumnPairServiceImpl
implements DataColumnPairService {
    private static final Logger logger = LoggerFactory.getLogger(DataColumnPairServiceImpl.class);
    private DataColumnPairDAO dataColumnPairDao;

    @Override
    public void create(ColumnPair entityObj) {
        Assert.assertNotNull((Object)entityObj);
        try {
            DataColumnPairDO dataColumnPairDo = this.modelToDo(entityObj);
            this.dataColumnPairDao.insert(dataColumnPairDo);
        }
        catch (RepeatConfigureException rcf) {
            throw rcf;
        }
        catch (Exception e) {
            logger.error("ERROR ## create dataColumnPair has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public void createBatch(List<ColumnPair> dataColumnPairs) {
        Assert.assertNotNull(dataColumnPairs);
        try {
            ArrayList<DataColumnPairDO> dataColumnPairDos = new ArrayList<DataColumnPairDO>();
            for (ColumnPair columnPair : dataColumnPairs) {
                DataColumnPairDO dataColumnPairDo = this.modelToDo(columnPair);
                dataColumnPairDos.add(dataColumnPairDo);
            }
            this.dataColumnPairDao.insertBatch(dataColumnPairDos);
        }
        catch (RepeatConfigureException rcf) {
            throw rcf;
        }
        catch (Exception e) {
            logger.error("ERROR ## create dataColumnPair has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public void remove(Long identity) {
        Assert.assertNotNull((Object)identity);
        try {
            this.dataColumnPairDao.delete(identity);
        }
        catch (Exception e) {
            logger.error("ERROR ## remove dataColumnPair has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public void modify(ColumnPair entityObj) {
        Assert.assertNotNull((Object)entityObj);
        try {
            DataColumnPairDO dataColumnPairDo = this.modelToDo(entityObj);
            this.dataColumnPairDao.update(dataColumnPairDo);
        }
        catch (RepeatConfigureException rce) {
            throw rce;
        }
        catch (Exception e) {
            logger.error("ERROR ## modify dataColumnPair has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public ColumnPair findById(Long identity) {
        Assert.assertNotNull((Object)identity);
        DataColumnPairDO columePairDo = (DataColumnPairDO)this.dataColumnPairDao.findById(identity);
        if (columePairDo == null) {
            return null;
        }
        return this.doToModel(columePairDo);
    }

    @Override
    public List<ColumnPair> listByIds(Long ... identities) {
        return null;
    }

    @Override
    public List<ColumnPair> listAll() {
        return null;
    }

    @Override
    public List<ColumnPair> listByDataMediaPairId(Long dataMediaPairId) {
        Assert.assertNotNull((Object)dataMediaPairId);
        List<ColumnPair> dataColumnPairs = new ArrayList<ColumnPair>();
        try {
            List<DataColumnPairDO> dataColumnPairDos = this.dataColumnPairDao.listByDataMediaPairId(dataMediaPairId);
            if (dataColumnPairDos.isEmpty()) {
                logger.debug("DEBUG ## couldn't query any dataColumnPair, maybe hasn't create any dataColumnPair.");
                return dataColumnPairs;
            }
            dataColumnPairs = this.doToModel(dataColumnPairDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query dataColumnPair by dataMediaId:" + dataMediaPairId + " has an exception!");
            throw new ManagerException(e);
        }
        return dataColumnPairs;
    }

    @Override
    public Map<Long, List<ColumnPair>> listByDataMediaPairIds(Long ... dataMediaPairIds) {
        Assert.assertNotNull((Object)dataMediaPairIds);
        HashMap<Long, List<ColumnPair>> dataColumnPairs = new HashMap<Long, List<ColumnPair>>();
        try {
            List<DataColumnPairDO> dataColumnPairDos = this.dataColumnPairDao.listByDataMediaPairIds(dataMediaPairIds);
            if (dataColumnPairDos.isEmpty()) {
                logger.debug("DEBUG ## couldn't query any dataColumnPair, maybe hasn't create any dataColumnPair.");
                return dataColumnPairs;
            }
            for (DataColumnPairDO dataColumnPairDo : dataColumnPairDos) {
                ArrayList<ColumnPair> columnPairs = (ArrayList<ColumnPair>)dataColumnPairs.get(dataColumnPairDo.getDataMediaPairId());
                if (columnPairs != null) {
                    if (columnPairs.contains(this.doToModel(dataColumnPairDo))) continue;
                    columnPairs.add(this.doToModel(dataColumnPairDo));
                    continue;
                }
                columnPairs = new ArrayList<ColumnPair>();
                columnPairs.add(this.doToModel(dataColumnPairDo));
                dataColumnPairs.put(dataColumnPairDo.getDataMediaPairId(), columnPairs);
            }
        }
        catch (Exception e) {
            logger.error("ERROR ## query dataColumnPair by dataMediaId:" + dataMediaPairIds + " has an exception!");
            throw new ManagerException(e);
        }
        return dataColumnPairs;
    }

    @Override
    public void removeByDataMediaPairId(Long dataMediaPairId) {
        Assert.assertNotNull((Object)dataMediaPairId);
        try {
            this.dataColumnPairDao.deleteByDataMediaPairId(dataMediaPairId);
        }
        catch (Exception e) {
            logger.error("ERROR ## remove dataColumnPair has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public List<ColumnPair> listByCondition(Map condition) {
        return null;
    }

    @Override
    public int getCount() {
        return 0;
    }

    @Override
    public int getCount(Map condition) {
        return 0;
    }

    private ColumnPair doToModel(DataColumnPairDO dataColumnPairDo) {
        Column sourceColumn = dataColumnPairDo.getSourceColumnName() == null ? null : new Column(dataColumnPairDo.getSourceColumnName());
        Column targetColumn = dataColumnPairDo.getTargetColumnName() == null ? null : new Column(dataColumnPairDo.getTargetColumnName());
        ColumnPair columnPair = new ColumnPair(sourceColumn, targetColumn);
        columnPair.setId(dataColumnPairDo.getId());
        columnPair.setDataMediaPairId(dataColumnPairDo.getDataMediaPairId());
        columnPair.setGmtCreate(dataColumnPairDo.getGmtCreate());
        columnPair.setGmtModified(dataColumnPairDo.getGmtModified());
        return columnPair;
    }

    private List<ColumnPair> doToModel(List<DataColumnPairDO> dataColumnPairDos) {
        ArrayList<ColumnPair> columnPairs = new ArrayList<ColumnPair>();
        for (DataColumnPairDO dataColumnPairDo : dataColumnPairDos) {
            columnPairs.add(this.doToModel(dataColumnPairDo));
        }
        return columnPairs;
    }

    private DataColumnPairDO modelToDo(ColumnPair dataColumnPair) {
        DataColumnPairDO dataColumnPairDo = new DataColumnPairDO();
        dataColumnPairDo.setId(dataColumnPair.getId());
        dataColumnPairDo.setSourceColumnName(dataColumnPair.getSourceColumn() == null ? null : dataColumnPair.getSourceColumn().getName());
        dataColumnPairDo.setTargetColumnName(dataColumnPair.getTargetColumn() == null ? null : dataColumnPair.getTargetColumn().getName());
        dataColumnPairDo.setDataMediaPairId(dataColumnPair.getDataMediaPairId());
        dataColumnPairDo.setGmtCreate(dataColumnPair.getGmtCreate());
        dataColumnPairDo.setGmtModified(dataColumnPair.getGmtModified());
        return dataColumnPairDo;
    }

    public DataColumnPairDAO getDataColumnPairDao() {
        return this.dataColumnPairDao;
    }

    public void setDataColumnPairDao(DataColumnPairDAO dataColumnPairDao) {
        this.dataColumnPairDao = dataColumnPairDao;
    }
}

