/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.config.datacolumnpair.impl;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.common.exceptions.RepeatConfigureException;
import com.alibaba.otter.manager.biz.config.datacolumnpair.DataColumnPairGroupService;
import com.alibaba.otter.manager.biz.config.datacolumnpair.DataColumnPairService;
import com.alibaba.otter.manager.biz.config.datacolumnpair.dal.DataColumnPairGroupDAO;
import com.alibaba.otter.manager.biz.config.datacolumnpair.dal.dataobject.DataColumnPairGroupDO;
import com.alibaba.otter.shared.common.model.config.data.ColumnGroup;
import com.alibaba.otter.shared.common.model.config.data.ColumnPair;
import com.alibaba.otter.shared.common.utils.Assert;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DataColumnPairGroupServiceImpl
implements DataColumnPairGroupService {
    private static final Logger logger = LoggerFactory.getLogger(DataColumnPairGroupServiceImpl.class);
    private DataColumnPairGroupDAO dataColumnPairGroupDao;
    private DataColumnPairService dataColumnPairService;

    @Override
    public void create(ColumnGroup entityObj) {
        Assert.assertNotNull((Object)entityObj);
        try {
            DataColumnPairGroupDO dataColumnPairGroupDo = this.modelToDo(entityObj);
            this.dataColumnPairGroupDao.insert(dataColumnPairGroupDo);
        }
        catch (RepeatConfigureException rcf) {
            throw rcf;
        }
        catch (Exception e) {
            logger.error("ERROR ## create dataColumnPairGroup has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public List<ColumnGroup> listByDataMediaPairId(Long dataMediaPairId) {
        Assert.assertNotNull((Object)dataMediaPairId);
        List<DataColumnPairGroupDO> dataColumnPairGroupDos = this.dataColumnPairGroupDao.ListByDataMediaPairId(dataMediaPairId);
        if (CollectionUtils.isEmpty(dataColumnPairGroupDos)) {
            return new ArrayList<ColumnGroup>();
        }
        return this.doToModel(dataColumnPairGroupDos);
    }

    @Override
    public Map<Long, List<ColumnGroup>> listByDataMediaPairIds(Long ... dataMediaPairIds) {
        Assert.assertNotNull((Object)dataMediaPairIds);
        HashMap<Long, List<ColumnGroup>> dataColumnGroups = new HashMap<Long, List<ColumnGroup>>();
        try {
            List<DataColumnPairGroupDO> dataColumnPairGroupDos = this.dataColumnPairGroupDao.ListByDataMediaPairIds(dataMediaPairIds);
            if (CollectionUtils.isEmpty(dataColumnPairGroupDos)) {
                logger.debug("DEBUG ## couldn't query any dataColumnPairGroup, maybe hasn't create any dataColumnPairGroup.");
                return dataColumnGroups;
            }
            for (DataColumnPairGroupDO dataColumnPairGroupDo : dataColumnPairGroupDos) {
                ArrayList<ColumnGroup> columnGroups = (ArrayList<ColumnGroup>)dataColumnGroups.get(dataColumnPairGroupDo.getDataMediaPairId());
                if (columnGroups != null) {
                    if (columnGroups.contains(this.doToModel(dataColumnPairGroupDo))) continue;
                    columnGroups.add(this.doToModel(dataColumnPairGroupDo));
                    continue;
                }
                columnGroups = new ArrayList<ColumnGroup>();
                columnGroups.add(this.doToModel(dataColumnPairGroupDo));
                dataColumnGroups.put(dataColumnPairGroupDo.getDataMediaPairId(), columnGroups);
            }
        }
        catch (Exception e) {
            logger.error("ERROR ## query dataColumnPairGroup by dataMediaId:" + dataMediaPairIds + " has an exception!");
            throw new ManagerException(e);
        }
        return dataColumnGroups;
    }

    @Override
    public void remove(Long identity) {
    }

    @Override
    public void removeByDataMediaPairId(Long dataMediaPairId) {
        Assert.assertNotNull((Object)dataMediaPairId);
        this.dataColumnPairGroupDao.deleteByDataMediaPairId(dataMediaPairId);
    }

    @Override
    public void modify(ColumnGroup entityObj) {
    }

    @Override
    public ColumnGroup findById(Long identity) {
        return null;
    }

    @Override
    public List<ColumnGroup> listByIds(Long ... identities) {
        return null;
    }

    @Override
    public List<ColumnGroup> listAll() {
        return null;
    }

    @Override
    public List<ColumnGroup> listByCondition(Map condition) {
        return null;
    }

    @Override
    public int getCount() {
        return 0;
    }

    @Override
    public int getCount(Map condition) {
        return 0;
    }

    private ColumnGroup doToModel(DataColumnPairGroupDO dataColumnPairGroupDo) {
        ColumnGroup columnGroup = new ColumnGroup();
        columnGroup.setId(dataColumnPairGroupDo.getId());
        List columnPairs = new ArrayList();
        if (StringUtils.isNotBlank((String)dataColumnPairGroupDo.getColumnPairContent())) {
            columnPairs = (List)JsonUtils.unmarshalFromString((String)dataColumnPairGroupDo.getColumnPairContent(), (TypeReference)new TypeReference<ArrayList<ColumnPair>>(){});
        }
        columnGroup.setColumnPairs(columnPairs);
        columnGroup.setDataMediaPairId(dataColumnPairGroupDo.getDataMediaPairId());
        columnGroup.setGmtCreate(dataColumnPairGroupDo.getGmtCreate());
        columnGroup.setGmtModified(dataColumnPairGroupDo.getGmtModified());
        return columnGroup;
    }

    private List<ColumnGroup> doToModel(List<DataColumnPairGroupDO> dataColumnPairGroupDos) {
        ArrayList<ColumnGroup> columnGroups = new ArrayList<ColumnGroup>();
        for (DataColumnPairGroupDO dataColumnPairGroupDO : dataColumnPairGroupDos) {
            columnGroups.add(this.doToModel(dataColumnPairGroupDO));
        }
        return columnGroups;
    }

    private DataColumnPairGroupDO modelToDo(ColumnGroup columnGroup) {
        DataColumnPairGroupDO dataColumnPairGroupDo = new DataColumnPairGroupDO();
        dataColumnPairGroupDo.setId(columnGroup.getId());
        dataColumnPairGroupDo.setColumnPairContent(JsonUtils.marshalToString((Object)columnGroup.getColumnPairs()));
        dataColumnPairGroupDo.setDataMediaPairId(columnGroup.getDataMediaPairId());
        dataColumnPairGroupDo.setGmtCreate(columnGroup.getGmtCreate());
        dataColumnPairGroupDo.setGmtModified(columnGroup.getGmtModified());
        return dataColumnPairGroupDo;
    }

    public DataColumnPairGroupDAO getDataColumnPairGroupDao() {
        return this.dataColumnPairGroupDao;
    }

    public void setDataColumnPairGroupDao(DataColumnPairGroupDAO dataColumnPairGroupDao) {
        this.dataColumnPairGroupDao = dataColumnPairGroupDao;
    }

    public DataColumnPairService getDataColumnPairService() {
        return this.dataColumnPairService;
    }

    public void setDataColumnPairService(DataColumnPairService dataColumnPairService) {
        this.dataColumnPairService = dataColumnPairService;
    }
}

