/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.config.channel.impl;

import com.alibaba.otter.manager.biz.common.exceptions.InvalidConfigureException;
import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.common.exceptions.RepeatConfigureException;
import com.alibaba.otter.manager.biz.config.channel.ChannelService;
import com.alibaba.otter.manager.biz.config.channel.dal.ChannelDAO;
import com.alibaba.otter.manager.biz.config.channel.dal.dataobject.ChannelDO;
import com.alibaba.otter.manager.biz.config.parameter.SystemParameterService;
import com.alibaba.otter.manager.biz.config.pipeline.PipelineService;
import com.alibaba.otter.manager.biz.remote.ConfigRemoteService;
import com.alibaba.otter.shared.arbitrate.ArbitrateManageService;
import com.alibaba.otter.shared.common.model.config.channel.Channel;
import com.alibaba.otter.shared.common.model.config.channel.ChannelStatus;
import com.alibaba.otter.shared.common.model.config.parameter.SystemParameter;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.common.model.config.pipeline.PipelineParameter;
import com.alibaba.otter.shared.common.utils.Assert;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class ChannelServiceImpl
implements ChannelService {
    private static final Logger logger = LoggerFactory.getLogger(ChannelServiceImpl.class);
    private SystemParameterService systemParameterService;
    private ArbitrateManageService arbitrateManageService;
    private TransactionTemplate transactionTemplate;
    private ConfigRemoteService configRemoteService;
    private PipelineService pipelineService;
    private ChannelDAO channelDao;

    @Override
    public void create(final Channel channel) {
        Assert.assertNotNull((Object)channel);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    ChannelDO channelDo = ChannelServiceImpl.this.modelToDo(channel);
                    channelDo.setId(0L);
                    if (!ChannelServiceImpl.this.channelDao.checkUnique(channelDo)) {
                        String exceptionCause = "exist the same name channel in the database.";
                        logger.warn("WARN ## " + exceptionCause);
                        throw new RepeatConfigureException(exceptionCause);
                    }
                    ChannelServiceImpl.this.channelDao.insert(channelDo);
                    ChannelServiceImpl.this.arbitrateManageService.channelEvent().init(channelDo.getId());
                }
                catch (RepeatConfigureException rce) {
                    throw rce;
                }
                catch (Exception e) {
                    logger.error("ERROR ## create channel has an exception ", (Throwable)e);
                    throw new ManagerException(e);
                }
            }
        });
    }

    @Override
    public void modify(Channel channel) {
        Assert.assertNotNull((Object)channel);
        try {
            ChannelDO channelDo = this.modelToDo(channel);
            if (!this.channelDao.checkUnique(channelDo)) {
                String exceptionCause = "exist the same name channel in the database.";
                logger.warn("WARN ## " + exceptionCause);
                throw new RepeatConfigureException(exceptionCause);
            }
            this.channelDao.update(channelDo);
        }
        catch (RepeatConfigureException rce) {
            throw rce;
        }
        catch (Exception e) {
            logger.error("ERROR ## modify channel has an exception ", (Throwable)e);
            throw new ManagerException(e);
        }
    }

    @Override
    public void remove(final Long channelId) {
        Assert.assertNotNull((Object)channelId);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    ChannelServiceImpl.this.arbitrateManageService.channelEvent().destory(channelId);
                    ChannelServiceImpl.this.channelDao.delete(channelId);
                }
                catch (Exception e) {
                    logger.error("ERROR ## remove channel has an exception ", (Throwable)e);
                    throw new ManagerException(e);
                }
            }
        });
    }

    @Override
    public List<Channel> listByIds(Long ... identities) {
        List<Channel> channels = new ArrayList<Channel>();
        try {
            List<ChannelDO> channelDos = null;
            if (identities.length < 1) {
                channelDos = this.channelDao.listAll();
                if (channelDos.isEmpty()) {
                    logger.debug("DEBUG ## couldn't query any channel, maybe hasn't create any channel.");
                    return channels;
                }
            } else {
                channelDos = this.channelDao.listByMultiId(identities);
                if (channelDos.isEmpty()) {
                    String exceptionCause = "couldn't query any channel by channelIds:" + Arrays.toString((Object[])identities);
                    logger.error("ERROR ## " + exceptionCause);
                    throw new ManagerException(exceptionCause);
                }
            }
            channels = this.doToModel(channelDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query channels has an exception!");
            throw new ManagerException(e);
        }
        return channels;
    }

    @Override
    public List<Channel> listAll() {
        return this.listByIds(new Long[0]);
    }

    @Override
    public List<Channel> listOnlyChannels(Long ... identities) {
        List<Channel> channels = new ArrayList<Channel>();
        try {
            List<ChannelDO> channelDos = null;
            if (identities.length < 1) {
                channelDos = this.channelDao.listAll();
                if (channelDos.isEmpty()) {
                    logger.debug("DEBUG ## couldn't query any channel, maybe hasn't create any channel.");
                    return channels;
                }
            } else {
                channelDos = this.channelDao.listByMultiId(identities);
                if (channelDos.isEmpty()) {
                    String exceptionCause = "couldn't query any channel by channelIds:" + Arrays.toString((Object[])identities);
                    logger.error("ERROR ## " + exceptionCause);
                    throw new ManagerException(exceptionCause);
                }
            }
            channels = this.doToModelOnlyChannels(channelDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query channels has an exception!");
            throw new ManagerException(e);
        }
        return channels;
    }

    @Override
    public List<Channel> listByCondition(Map condition) {
        List<ChannelDO> channelDos = this.channelDao.listByCondition(condition);
        if (channelDos.isEmpty()) {
            logger.debug("DEBUG ## couldn't query any channel by the condition:" + JsonUtils.marshalToString((Object)condition));
            return new ArrayList<Channel>();
        }
        return this.doToModel(channelDos);
    }

    @Override
    public List<Channel> listByConditionWithoutColumn(Map condition) {
        List<ChannelDO> channelDos = this.channelDao.listByCondition(condition);
        if (channelDos.isEmpty()) {
            logger.debug("DEBUG ## couldn't query any channel by the condition:" + JsonUtils.marshalToString((Object)condition));
            return new ArrayList<Channel>();
        }
        return this.doToModelWithColumn(channelDos);
    }

    @Override
    public List<Long> listAllChannelId() {
        List<ChannelDO> channelDos = this.channelDao.listChannelPks();
        ArrayList<Long> channelPks = new ArrayList<Long>();
        if (channelDos.isEmpty()) {
            logger.debug("DEBUG ## couldn't query any channel");
        }
        for (ChannelDO channelDo : channelDos) {
            channelPks.add(channelDo.getId());
        }
        return channelPks;
    }

    @Override
    public Channel findById(Long channelId) {
        Assert.assertNotNull((Object)channelId);
        List<Channel> channels = this.listByIds(channelId);
        if (channels.size() != 1) {
            String exceptionCause = "query channelId:" + channelId + " return null.";
            logger.error("ERROR ## " + exceptionCause);
            throw new ManagerException(exceptionCause);
        }
        return channels.get(0);
    }

    @Override
    public Channel findByIdWithoutColumn(Long channelId) {
        List<ChannelDO> channelDos = this.channelDao.listByMultiId(channelId);
        if (channelDos.size() != 1) {
            String exceptionCause = "query channelId:" + channelId + " return null.";
            logger.error("ERROR ## " + exceptionCause);
            throw new ManagerException(exceptionCause);
        }
        List<Channel> channels = this.doToModelWithColumn(channelDos);
        return channels.get(0);
    }

    @Override
    public Channel findByPipelineId(Long pipelineId) {
        Pipeline pipeline = (Pipeline)this.pipelineService.findById(pipelineId);
        Channel channel = this.findById(pipeline.getChannelId());
        return channel;
    }

    @Override
    public List<Channel> listByPipelineIds(Long ... pipelineIds) {
        ArrayList<Channel> channels = new ArrayList();
        try {
            List pipelines = this.pipelineService.listByIds(pipelineIds);
            ArrayList<Long> channelIds = new ArrayList<Long>();
            for (Pipeline pipeline : pipelines) {
                if (channelIds.contains(pipeline.getChannelId())) continue;
                channelIds.add(pipeline.getChannelId());
            }
            channels = this.listByIds(channelIds.toArray(new Long[channelIds.size()]));
        }
        catch (Exception e) {
            logger.error("ERROR ## list query channel by pipelineIds:" + pipelineIds.toString() + " has an exception!");
            throw new ManagerException(e);
        }
        return channels;
    }

    @Override
    public List<Channel> listByNodeId(Long nodeId) {
        return this.listByNodeId(nodeId, new ChannelStatus[0]);
    }

    @Override
    public List<Channel> listByNodeId(Long nodeId, ChannelStatus ... statuses) {
        List<Channel> channels = new ArrayList<Channel>();
        ArrayList<Channel> results = new ArrayList<Channel>();
        try {
            List<Pipeline> pipelines = this.pipelineService.listByNodeId(nodeId);
            ArrayList<Long> pipelineIds = new ArrayList<Long>();
            for (Pipeline pipeline : pipelines) {
                pipelineIds.add(pipeline.getId());
            }
            if (pipelineIds.isEmpty()) {
                return channels;
            }
            channels = this.listByPipelineIds(pipelineIds.toArray(new Long[pipelineIds.size()]));
            if (null == statuses || statuses.length == 0) {
                return channels;
            }
            for (Channel channel : channels) {
                for (ChannelStatus status : statuses) {
                    if (!channel.getStatus().equals((Object)status)) continue;
                    results.add(channel);
                }
            }
        }
        catch (Exception e) {
            logger.error("ERROR ## list query channel by nodeId:" + nodeId + " has an exception!");
            throw new ManagerException(e);
        }
        return results;
    }

    @Override
    public int getCount() {
        return this.channelDao.getCount();
    }

    @Override
    public int getCount(Map condition) {
        return this.channelDao.getCount(condition);
    }

    private void switchChannelStatus(final Long channelId, final ChannelStatus channelStatus) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    ChannelDO channelDo = (ChannelDO)ChannelServiceImpl.this.channelDao.findById(channelId);
                    if (null == channelDo) {
                        String exceptionCause = "query channelId:" + channelId + " return null.";
                        logger.error("ERROR ## " + exceptionCause);
                        throw new ManagerException(exceptionCause);
                    }
                    ChannelStatus oldStatus = ChannelServiceImpl.this.arbitrateManageService.channelEvent().status(channelDo.getId());
                    Channel channel = ChannelServiceImpl.this.doToModel(channelDo);
                    List pipelines = channel.getPipelines();
                    if (pipelines.size() > 1) {
                        boolean ddlSync = true;
                        boolean homeSync = true;
                        for (Pipeline pipeline : pipelines) {
                            homeSync &= pipeline.getParameters().isHome().booleanValue();
                            ddlSync &= pipeline.getParameters().getDdlSync().booleanValue();
                        }
                        if (ddlSync) {
                            throw new InvalidConfigureException(InvalidConfigureException.INVALID_TYPE.DDL);
                        }
                        if (homeSync) {
                            throw new InvalidConfigureException(InvalidConfigureException.INVALID_TYPE.HOME);
                        }
                    }
                    channel.setStatus(oldStatus);
                    ChannelStatus newStatus = channelStatus;
                    if (newStatus != null) {
                        if (newStatus.equals((Object)oldStatus)) {
                            return;
                        }
                        channel.setStatus(newStatus);
                    } else {
                        newStatus = oldStatus;
                    }
                    if (newStatus.isStop()) {
                        ChannelServiceImpl.this.arbitrateManageService.channelEvent().stop(channelId);
                    } else if (newStatus.isPause()) {
                        ChannelServiceImpl.this.arbitrateManageService.channelEvent().pause(channelId);
                    }
                    boolean result = ChannelServiceImpl.this.configRemoteService.notifyChannel(channel);
                    if (result && newStatus.isStart()) {
                        ChannelServiceImpl.this.arbitrateManageService.channelEvent().start(channelId);
                    }
                }
                catch (Exception e) {
                    logger.error("ERROR ## switch the channel(" + channelId + ") status has an exception.");
                    throw new ManagerException(e);
                }
            }
        });
    }

    @Override
    public void stopChannel(Long channelId) {
        this.switchChannelStatus(channelId, ChannelStatus.STOP);
    }

    @Override
    public void startChannel(Long channelId) {
        this.switchChannelStatus(channelId, ChannelStatus.START);
    }

    @Override
    public void notifyChannel(Long channelId) {
        this.switchChannelStatus(channelId, null);
    }

    private ChannelDO modelToDo(Channel channel) {
        ChannelDO channelDO = new ChannelDO();
        try {
            channelDO.setId(channel.getId());
            channelDO.setName(channel.getName());
            channelDO.setDescription(channel.getDescription());
            channelDO.setStatus(channel.getStatus());
            channelDO.setParameters(channel.getParameters());
            channelDO.setGmtCreate(channel.getGmtCreate());
            channelDO.setGmtModified(channel.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## change the channel Model to Do has an exception");
            throw new ManagerException(e);
        }
        return channelDO;
    }

    private Channel doToModel(ChannelDO channelDo) {
        Channel channel = new Channel();
        try {
            channel.setId(channelDo.getId());
            channel.setName(channelDo.getName());
            channel.setDescription(channelDo.getDescription());
            channel.setStatus(this.arbitrateManageService.channelEvent().status(channelDo.getId()));
            channel.setParameters(channelDo.getParameters());
            channel.setGmtCreate(channelDo.getGmtCreate());
            channel.setGmtModified(channelDo.getGmtModified());
            List<Pipeline> pipelines = this.pipelineService.listByChannelIds(channelDo.getId());
            SystemParameter systemParameter = this.systemParameterService.find();
            for (Pipeline pipeline : pipelines) {
                PipelineParameter parameter = new PipelineParameter();
                parameter.merge(systemParameter);
                parameter.merge(channel.getParameters());
                parameter.merge(pipeline.getParameters());
                pipeline.setParameters(parameter);
            }
            channel.setPipelines(pipelines);
        }
        catch (Exception e) {
            logger.error("ERROR ## change the channel DO to Model has an exception");
            throw new ManagerException(e);
        }
        return channel;
    }

    private List<Channel> doToModel(List<ChannelDO> channelDos) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        try {
            ArrayList<Long> channelIds = new ArrayList<Long>();
            for (ChannelDO channelDo : channelDos) {
                channelIds.add(channelDo.getId());
            }
            Long[] idArray = new Long[channelIds.size()];
            List<Pipeline> pipelines = this.pipelineService.listByChannelIds(channelIds.toArray(idArray));
            SystemParameter systemParameter = this.systemParameterService.find();
            for (ChannelDO channelDo : channelDos) {
                Channel channel = new Channel();
                channel.setId(channelDo.getId());
                channel.setName(channelDo.getName());
                channel.setDescription(channelDo.getDescription());
                ChannelStatus channelStatus = this.arbitrateManageService.channelEvent().status(channelDo.getId());
                channel.setStatus(null == channelStatus ? ChannelStatus.STOP : channelStatus);
                channel.setParameters(channelDo.getParameters());
                channel.setGmtCreate(channelDo.getGmtCreate());
                channel.setGmtModified(channelDo.getGmtModified());
                ArrayList<Pipeline> subPipelines = new ArrayList<Pipeline>();
                for (Pipeline pipeline : pipelines) {
                    if (!pipeline.getChannelId().equals(channelDo.getId())) continue;
                    PipelineParameter parameter = new PipelineParameter();
                    parameter.merge(systemParameter);
                    parameter.merge(channel.getParameters());
                    parameter.merge(pipeline.getParameters());
                    pipeline.setParameters(parameter);
                    subPipelines.add(pipeline);
                }
                channel.setPipelines(subPipelines);
                channels.add(channel);
            }
        }
        catch (Exception e) {
            logger.error("ERROR ## change the channels DO to Model has an exception");
            throw new ManagerException(e);
        }
        return channels;
    }

    private List<Channel> doToModelWithColumn(List<ChannelDO> channelDos) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        try {
            ArrayList<Long> channelIds = new ArrayList<Long>();
            for (ChannelDO channelDo : channelDos) {
                channelIds.add(channelDo.getId());
            }
            Long[] idArray = new Long[channelIds.size()];
            List<Pipeline> pipelines = this.pipelineService.listByChannelIdsWithoutColumn(channelIds.toArray(idArray));
            SystemParameter systemParameter = this.systemParameterService.find();
            for (ChannelDO channelDo : channelDos) {
                Channel channel = new Channel();
                channel.setId(channelDo.getId());
                channel.setName(channelDo.getName());
                channel.setDescription(channelDo.getDescription());
                ChannelStatus channelStatus = this.arbitrateManageService.channelEvent().status(channelDo.getId());
                channel.setStatus(null == channelStatus ? ChannelStatus.STOP : channelStatus);
                channel.setParameters(channelDo.getParameters());
                channel.setGmtCreate(channelDo.getGmtCreate());
                channel.setGmtModified(channelDo.getGmtModified());
                ArrayList<Pipeline> subPipelines = new ArrayList<Pipeline>();
                for (Pipeline pipeline : pipelines) {
                    if (!pipeline.getChannelId().equals(channelDo.getId())) continue;
                    PipelineParameter parameter = new PipelineParameter();
                    parameter.merge(systemParameter);
                    parameter.merge(channel.getParameters());
                    parameter.merge(pipeline.getParameters());
                    pipeline.setParameters(parameter);
                    subPipelines.add(pipeline);
                }
                channel.setPipelines(subPipelines);
                channels.add(channel);
            }
        }
        catch (Exception e) {
            logger.error("ERROR ## change the channels DO to Model has an exception");
            throw new ManagerException(e);
        }
        return channels;
    }

    private List<Channel> doToModelOnlyChannels(List<ChannelDO> channelDos) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        try {
            ArrayList<Long> channelIds = new ArrayList<Long>();
            for (ChannelDO channelDo : channelDos) {
                channelIds.add(channelDo.getId());
            }
            for (ChannelDO channelDo : channelDos) {
                Channel channel = new Channel();
                channel.setId(channelDo.getId());
                channel.setName(channelDo.getName());
                channel.setDescription(channelDo.getDescription());
                ChannelStatus channelStatus = this.arbitrateManageService.channelEvent().status(channelDo.getId());
                channel.setStatus(null == channelStatus ? ChannelStatus.STOP : channelStatus);
                channel.setParameters(channelDo.getParameters());
                channel.setGmtCreate(channelDo.getGmtCreate());
                channel.setGmtModified(channelDo.getGmtModified());
                ArrayList subPipelines = new ArrayList();
                channel.setPipelines(subPipelines);
                channels.add(channel);
            }
        }
        catch (Exception e) {
            logger.error("ERROR ## change the channels doToModelOnlyChannels has an exception");
            throw new ManagerException(e);
        }
        return channels;
    }

    public void setPipelineService(PipelineService pipelineService) {
        this.pipelineService = pipelineService;
    }

    public void setChannelDao(ChannelDAO channelDao) {
        this.channelDao = channelDao;
    }

    public void setArbitrateManageService(ArbitrateManageService arbitrateManageService) {
        this.arbitrateManageService = arbitrateManageService;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setConfigRemoteService(ConfigRemoteService configRemoteService) {
        this.configRemoteService = configRemoteService;
    }

    public void setSystemParameterService(SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }
}

