/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.config.canal.impl;

import com.alibaba.otter.canal.instance.manager.model.Canal;
import com.alibaba.otter.canal.instance.manager.model.CanalParameter;
import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.common.exceptions.RepeatConfigureException;
import com.alibaba.otter.manager.biz.config.autokeeper.AutoKeeperClusterService;
import com.alibaba.otter.manager.biz.config.canal.CanalService;
import com.alibaba.otter.manager.biz.config.canal.dal.CanalDAO;
import com.alibaba.otter.manager.biz.config.canal.dal.dataobject.CanalDO;
import com.alibaba.otter.manager.biz.config.node.impl.NodeServiceImpl;
import com.alibaba.otter.shared.arbitrate.ArbitrateViewService;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperCluster;
import com.alibaba.otter.shared.common.utils.Assert;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class CanalServiceImpl
implements CanalService {
    private static final Logger logger = LoggerFactory.getLogger(NodeServiceImpl.class);
    private CanalDAO canalDao;
    private TransactionTemplate transactionTemplate;
    private AutoKeeperClusterService autoKeeperClusterService;
    private ArbitrateViewService arbitrateViewService;

    @Override
    public void create(final Canal canal) {
        Assert.assertNotNull((Object)canal);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    CanalDO canalDO = CanalServiceImpl.this.modelToDo(canal);
                    canalDO.setId(0L);
                    if (!CanalServiceImpl.this.canalDao.checkUnique(canalDO)) {
                        String exceptionCause = "exist the same repeat canal in the database.";
                        logger.warn("WARN ## " + exceptionCause);
                        throw new RepeatConfigureException(exceptionCause);
                    }
                    CanalServiceImpl.this.canalDao.insert(canalDO);
                    canal.setId(canalDO.getId());
                }
                catch (RepeatConfigureException rce) {
                    throw rce;
                }
                catch (Exception e) {
                    logger.error("ERROR ## create canal has an exception!");
                    throw new ManagerException(e);
                }
            }
        });
    }

    @Override
    public void remove(final Long canalId) {
        Assert.assertNotNull((Object)canalId);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    Canal canal = CanalServiceImpl.this.findById(canalId);
                    CanalServiceImpl.this.canalDao.delete(canalId);
                    CanalServiceImpl.this.arbitrateViewService.removeCanal(canal.getName());
                }
                catch (Exception e) {
                    logger.error("ERROR ## remove canal(" + canalId + ") has an exception!");
                    throw new ManagerException(e);
                }
            }
        });
    }

    @Override
    public void modify(final Canal canal) {
        Assert.assertNotNull((Object)canal);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    CanalDO canalDo = CanalServiceImpl.this.modelToDo(canal);
                    if (!CanalServiceImpl.this.canalDao.checkUnique(canalDo)) {
                        String exceptionCause = "exist the same repeat canal in the database.";
                        logger.warn("WARN ## " + exceptionCause);
                        throw new RepeatConfigureException(exceptionCause);
                    }
                    CanalServiceImpl.this.canalDao.update(canalDo);
                }
                catch (RepeatConfigureException rce) {
                    throw rce;
                }
                catch (Exception e) {
                    logger.error("ERROR ## modify canal(" + canal.getId() + ") has an exception!");
                    throw new ManagerException(e);
                }
            }
        });
    }

    @Override
    public List<Canal> listByIds(Long ... identities) {
        List<Canal> canals = new ArrayList<Canal>();
        try {
            List<CanalDO> canalDos = null;
            if (identities.length < 1) {
                canalDos = this.canalDao.listAll();
                if (canalDos.isEmpty()) {
                    logger.debug("DEBUG ## couldn't query any canal, maybe hasn't create any canal.");
                    return canals;
                }
            } else {
                canalDos = this.canalDao.listByMultiId(identities);
                if (canalDos.isEmpty()) {
                    String exceptionCause = "couldn't query any canal by canalIds:" + Arrays.toString((Object[])identities);
                    logger.error("ERROR ## " + exceptionCause);
                    throw new ManagerException(exceptionCause);
                }
            }
            canals = this.doToModel(canalDos);
        }
        catch (Exception e) {
            logger.error("ERROR ## query channels has an exception!");
            throw new ManagerException(e);
        }
        return canals;
    }

    @Override
    public List<Canal> listAll() {
        return this.listByIds(new Long[0]);
    }

    @Override
    public Canal findById(Long canalId) {
        Assert.assertNotNull((Object)canalId);
        List<Canal> canals = this.listByIds(canalId);
        if (canals.size() != 1) {
            String exceptionCause = "query canalId:" + canalId + " return null.";
            logger.error("ERROR ## " + exceptionCause);
            throw new ManagerException(exceptionCause);
        }
        return canals.get(0);
    }

    @Override
    public Canal findByName(String name) {
        Assert.assertNotNull((Object)name);
        CanalDO canalDo = this.canalDao.findByName(name);
        if (canalDo == null) {
            String exceptionCause = "query name:" + name + " return null.";
            logger.error("ERROR ## " + exceptionCause);
            throw new ManagerException(exceptionCause);
        }
        return this.doToModel(canalDo);
    }

    @Override
    public int getCount(Map condition) {
        return this.canalDao.getCount(condition);
    }

    @Override
    public List<Canal> listByCondition(Map condition) {
        List<CanalDO> canalDos = this.canalDao.listByCondition(condition);
        if (canalDos.isEmpty()) {
            logger.debug("DEBUG ## couldn't query any canal by the condition:" + JsonUtils.marshalToString((Object)condition));
            return new ArrayList<Canal>();
        }
        return this.doToModel(canalDos);
    }

    private CanalDO modelToDo(Canal canal) {
        CanalDO canalDo = new CanalDO();
        try {
            canalDo.setId(canal.getId());
            canalDo.setName(canal.getName());
            canalDo.setStatus(canal.getStatus());
            canalDo.setDescription(canal.getDesc());
            canalDo.setParameters(canal.getCanalParameter());
            canalDo.setGmtCreate(canal.getGmtCreate());
            canalDo.setGmtModified(canal.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## change the canal Model to Do has an exception");
            throw new ManagerException(e);
        }
        return canalDo;
    }

    private Canal doToModel(CanalDO canalDo) {
        Canal canal = new Canal();
        try {
            canal.setId(canalDo.getId());
            canal.setName(canalDo.getName());
            canal.setStatus(canalDo.getStatus());
            canal.setDesc(canalDo.getDescription());
            CanalParameter parameter = canalDo.getParameters();
            AutoKeeperCluster zkCluster = this.autoKeeperClusterService.findAutoKeeperClusterById(parameter.getZkClusterId());
            if (zkCluster != null) {
                parameter.setZkClusters(Arrays.asList(StringUtils.join((Collection)zkCluster.getServerList(), (char)',')));
            }
            canal.setCanalParameter(canalDo.getParameters());
            canal.setGmtCreate(canalDo.getGmtCreate());
            canal.setGmtModified(canalDo.getGmtModified());
        }
        catch (Exception e) {
            logger.error("ERROR ## change the canal Do to Model has an exception");
            throw new ManagerException(e);
        }
        return canal;
    }

    private List<Canal> doToModel(List<CanalDO> canalDos) {
        ArrayList<Canal> canals = new ArrayList<Canal>();
        for (CanalDO canalDo : canalDos) {
            canals.add(this.doToModel(canalDo));
        }
        return canals;
    }

    public void setCanalDao(CanalDAO canalDao) {
        this.canalDao = canalDao;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setAutoKeeperClusterService(AutoKeeperClusterService autoKeeperClusterService) {
        this.autoKeeperClusterService = autoKeeperClusterService;
    }

    public void setArbitrateViewService(ArbitrateViewService arbitrateViewService) {
        this.arbitrateViewService = arbitrateViewService;
    }
}

