/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.config.alarm.impl;

import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.config.alarm.AlarmRuleService;
import com.alibaba.otter.manager.biz.config.alarm.dal.AlarmRuleDAO;
import com.alibaba.otter.manager.biz.config.alarm.dal.dataobject.AlarmRuleDO;
import com.alibaba.otter.manager.biz.config.alarm.dal.dataobject.AlarmRuleParameter;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRule;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRuleStatus;
import com.alibaba.otter.shared.common.utils.Assert;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmRuleServiceImpl
implements AlarmRuleService {
    private static final Logger logger = LoggerFactory.getLogger(AlarmRuleServiceImpl.class);
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private AlarmRuleDAO alarmRuleDao;

    @Override
    public void create(AlarmRule alarmRule) {
        Assert.assertNotNull((Object)alarmRule);
        this.alarmRuleDao.insert(this.modelToDo(alarmRule));
    }

    @Override
    public void modify(AlarmRule alarmRule) {
        AlarmRuleDO alarmRuleDo = this.modelToDo(alarmRule);
        this.alarmRuleDao.update(alarmRuleDo);
    }

    @Override
    public void remove(Long alarmRuleId) {
        this.alarmRuleDao.delete(alarmRuleId);
    }

    private void switchAlarmRuleStatus(Long alarmRuleId, AlarmRuleStatus alarmRuleStatus, String pauseTime) {
        AlarmRuleDO alarmRuleDo = this.alarmRuleDao.findById(alarmRuleId);
        if (null == alarmRuleDo) {
            String exceptionCause = "query alarmRule:" + alarmRuleId + " return null.";
            logger.error("ERROR ## " + exceptionCause);
            throw new ManagerException(exceptionCause);
        }
        alarmRuleDo.setStatus(alarmRuleStatus);
        if (alarmRuleDo.getAlarmRuleParameter() != null) {
            alarmRuleDo.getAlarmRuleParameter().setPauseTime(pauseTime);
        } else if (StringUtils.isNotEmpty((String)pauseTime)) {
            alarmRuleDo.setAlarmRuleParameter(new AlarmRuleParameter());
            alarmRuleDo.getAlarmRuleParameter().setPauseTime(pauseTime);
        }
        this.alarmRuleDao.update(alarmRuleDo);
    }

    @Override
    public void enableMonitor(Long alarmRuleId) {
        this.switchAlarmRuleStatus(alarmRuleId, AlarmRuleStatus.ENABLE, null);
    }

    @Override
    public void disableMonitor(Long alarmRuleId) {
        this.switchAlarmRuleStatus(alarmRuleId, AlarmRuleStatus.DISABLE, null);
    }

    @Override
    public void disableMonitor(Long alarmRuleId, String pauseTime) {
        this.switchAlarmRuleStatus(alarmRuleId, AlarmRuleStatus.ENABLE, pauseTime);
    }

    @Override
    public AlarmRule getAlarmRuleById(Long AlarmRuleId) {
        Assert.assertNotNull((Object)AlarmRuleId);
        return this.doToModel(this.alarmRuleDao.findById(AlarmRuleId));
    }

    @Override
    public List<AlarmRule> getAllAlarmRules(AlarmRuleStatus status) {
        Assert.assertNotNull((Object)status);
        List<AlarmRuleDO> alarmRuleDos = this.alarmRuleDao.listByStatus(status);
        return this.doToModel(alarmRuleDos);
    }

    @Override
    public Map<Long, List<AlarmRule>> getAlarmRules(AlarmRuleStatus status) {
        Assert.assertNotNull((Object)status);
        List<AlarmRule> alarmRules = this.getAllAlarmRules(status);
        HashMap<Long, List<AlarmRule>> result = new HashMap<Long, List<AlarmRule>>();
        for (AlarmRule alarmRule : alarmRules) {
            ArrayList<AlarmRule> rules = (ArrayList<AlarmRule>)result.get(alarmRule.getPipelineId());
            if (rules == null) {
                rules = new ArrayList<AlarmRule>();
            }
            if (!rules.contains(alarmRule)) {
                rules.add(alarmRule);
            }
            result.put(alarmRule.getPipelineId(), rules);
        }
        return result;
    }

    @Override
    public List<AlarmRule> getAlarmRules(Long pipelineId) {
        Assert.assertNotNull((Object)pipelineId);
        List<AlarmRuleDO> alarmRuleDos = this.alarmRuleDao.listByPipelineId(pipelineId);
        return this.doToModel(alarmRuleDos);
    }

    @Override
    public List<AlarmRule> getAlarmRules(Long pipelineId, AlarmRuleStatus status) {
        Assert.assertNotNull((Object)pipelineId);
        Assert.assertNotNull((Object)status);
        List<AlarmRuleDO> alarmRuleDos = this.alarmRuleDao.listByPipelineId(pipelineId, status);
        return this.doToModel(alarmRuleDos);
    }

    @Override
    public List<AlarmRule> listAllAlarmRules(Map condition) {
        List<AlarmRule> alarmRules = this.doToModel(this.alarmRuleDao.listAllByPipeline(condition));
        return alarmRules;
    }

    @Override
    public int getCount() {
        return this.alarmRuleDao.getCount();
    }

    private AlarmRule doToModel(AlarmRuleDO alarmRuleDo) {
        String pauseTime;
        AlarmRule alarmRule = new AlarmRule();
        alarmRule.setId(alarmRuleDo.getId());
        alarmRule.setMatchValue(alarmRuleDo.getMatchValue());
        alarmRule.setMonitorName(alarmRuleDo.getMonitorName());
        alarmRule.setReceiverKey(alarmRuleDo.getReceiverKey());
        alarmRule.setIntervalTime(Long.valueOf(alarmRuleDo.getAlarmRuleParameter() == null ? 1800L : alarmRuleDo.getAlarmRuleParameter().getIntervalTime()));
        String string = pauseTime = alarmRuleDo.getAlarmRuleParameter() == null ? null : alarmRuleDo.getAlarmRuleParameter().getPauseTime();
        if (StringUtils.isNotEmpty((String)pauseTime)) {
            SimpleDateFormat format = new SimpleDateFormat(TIMESTAMP_FORMAT);
            try {
                alarmRule.setPauseTime(format.parse(pauseTime));
            }
            catch (ParseException e) {
                throw new ManagerException(e);
            }
        }
        alarmRule.setAutoRecovery(Boolean.valueOf(alarmRuleDo.getAlarmRuleParameter() == null ? false : alarmRuleDo.getAlarmRuleParameter().getAutoRecovery()));
        alarmRule.setRecoveryThresold(Integer.valueOf(alarmRuleDo.getAlarmRuleParameter() == null ? 3 : alarmRuleDo.getAlarmRuleParameter().getRecoveryThresold()));
        alarmRule.setPipelineId(alarmRuleDo.getPipelineId());
        alarmRule.setStatus(alarmRuleDo.getStatus());
        alarmRule.setDescription(alarmRuleDo.getDescription());
        alarmRule.setGmtCreate(alarmRuleDo.getGmtCreate());
        alarmRule.setGmtModified(alarmRuleDo.getGmtModified());
        return alarmRule;
    }

    private List<AlarmRule> doToModel(List<AlarmRuleDO> alarmRuleDos) {
        ArrayList<AlarmRule> alarmRules = new ArrayList<AlarmRule>();
        for (AlarmRuleDO alarmRuleDo : alarmRuleDos) {
            alarmRules.add(this.doToModel(alarmRuleDo));
        }
        return alarmRules;
    }

    private AlarmRuleDO modelToDo(AlarmRule alarmRule) {
        AlarmRuleDO alarmRuleDo = new AlarmRuleDO();
        alarmRuleDo.setId(alarmRule.getId());
        alarmRuleDo.setMatchValue(alarmRule.getMatchValue());
        alarmRuleDo.setMonitorName(alarmRule.getMonitorName());
        alarmRuleDo.setReceiverKey(alarmRule.getReceiverKey());
        alarmRuleDo.setPipelineId(alarmRule.getPipelineId());
        alarmRuleDo.setStatus(alarmRule.getStatus());
        alarmRuleDo.setDescription(alarmRule.getDescription());
        alarmRuleDo.setGmtCreate(alarmRule.getGmtCreate());
        alarmRuleDo.setGmtModified(alarmRule.getGmtModified());
        AlarmRuleParameter alarmRuleParameter = new AlarmRuleParameter();
        alarmRuleParameter.setIntervalTime(alarmRule.getIntervalTime());
        if (alarmRule.getPauseTime() != null) {
            SimpleDateFormat format = new SimpleDateFormat(TIMESTAMP_FORMAT);
            alarmRuleParameter.setPauseTime(format.format(alarmRule.getPauseTime()));
        }
        alarmRuleParameter.setAutoRecovery(alarmRule.getAutoRecovery());
        alarmRuleParameter.setRecoveryThresold(alarmRule.getRecoveryThresold());
        alarmRuleDo.setAlarmRuleParameter(alarmRuleParameter);
        return alarmRuleDo;
    }

    public void setAlarmRuleDao(AlarmRuleDAO alarmRuleDao) {
        this.alarmRuleDao = alarmRuleDao;
    }
}

