/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.common.arbitrate;

import com.alibaba.otter.manager.biz.config.channel.ChannelService;
import com.alibaba.otter.manager.biz.monitor.PassiveMonitor;
import com.alibaba.otter.shared.arbitrate.ArbitrateManageService;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.NodeMonitor;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.listener.NodeListener;
import com.alibaba.otter.shared.common.model.config.alarm.MonitorName;
import com.alibaba.otter.shared.common.model.config.channel.Channel;
import com.alibaba.otter.shared.common.model.config.channel.ChannelStatus;
import com.alibaba.otter.shared.communication.model.arbitrate.NodeAlarmEvent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DeadNodeListener
implements NodeListener,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(DeadNodeListener.class);
    private volatile DelayQueue<DeadNodeDelayed> queue = new DelayQueue();
    private NodeMonitor nodeMonitor;
    private ArbitrateManageService arbitrateManageService;
    private PassiveMonitor exceptionRuleMonitor;
    private ChannelService channelService;
    private ExecutorService executor;
    private long checkTime = 60000L;
    private volatile List<Long> currentNodes = new ArrayList<Long>();

    public void afterPropertiesSet() throws Exception {
        this.nodeMonitor.addListener((NodeListener)this);
        this.executor = Executors.newFixedThreadPool(1);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    DeadNodeDelayed delay = null;
                    try {
                        delay = (DeadNodeDelayed)DeadNodeListener.this.queue.take();
                        DeadNodeListener.this.processDead(delay.getNid());
                        continue;
                    }
                    catch (Throwable e) {
                        logger.error(String.format("error happened with [%s]", delay.toString()), e);
                        continue;
                    }
                    break;
                }
            }
        });
    }

    public synchronized void processChanged(List<Long> nodes) {
        HashSet<Long> deadNodes = new HashSet<Long>();
        for (Long node : this.currentNodes) {
            if (nodes.contains(node)) continue;
            deadNodes.add(node);
        }
        this.currentNodes = nodes;
        if (deadNodes.size() > 0) {
            for (Long nid : deadNodes) {
                DeadNodeDelayed delayed = new DeadNodeDelayed(nid, this.checkTime);
                if (this.queue.contains(delayed)) continue;
                this.queue.add(new DeadNodeDelayed(nid, this.checkTime));
            }
        }
    }

    private void processDead(Long deadNode) {
        List aliveNodes = this.nodeMonitor.getAliveNodes(true);
        if (aliveNodes.contains(deadNode)) {
            logger.warn("dead node[{}] happend just one moment , check it's alived", (Object)deadNode);
            return;
        }
        ArrayList channelIds = Lists.newArrayList();
        List<Channel> channels = this.channelService.listByNodeId(deadNode, ChannelStatus.START);
        for (Channel channel : channels) {
            channelIds.add(channel.getId());
        }
        Collections.sort(channelIds);
        NodeAlarmEvent alarm = new NodeAlarmEvent();
        alarm.setPipelineId(Long.valueOf(-1L));
        alarm.setTitle(MonitorName.EXCEPTION.name());
        alarm.setMessage(String.format("nid:%s is dead and restart cids:%s", String.valueOf(deadNode), ((Object)channelIds).toString()));
        try {
            this.exceptionRuleMonitor.feed((Object)alarm, alarm.getPipelineId());
        }
        catch (Exception e) {
            logger.error(String.format("ERROR # exceptionRuleMonitor error for %s", alarm.toString()), (Throwable)e);
        }
        for (Long channelId : channelIds) {
            boolean result = this.arbitrateManageService.channelEvent().restart(channelId);
            if (!result) continue;
            this.channelService.notifyChannel(channelId);
        }
    }

    public void destroy() throws Exception {
        this.nodeMonitor.removeListener((NodeListener)this);
        this.executor.shutdownNow();
    }

    public void setNodeMonitor(NodeMonitor nodeMonitor) {
        this.nodeMonitor = nodeMonitor;
    }

    public void setArbitrateManageService(ArbitrateManageService arbitrateManageService) {
        this.arbitrateManageService = arbitrateManageService;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setExceptionRuleMonitor(PassiveMonitor exceptionRuleMonitor) {
        this.exceptionRuleMonitor = exceptionRuleMonitor;
    }

    public static class DeadNodeDelayed
    implements Delayed {
        private static final long MILL_ORIGIN = System.currentTimeMillis();
        private long nid;
        private long now;
        private long timeout;

        public DeadNodeDelayed(long nid, long timeout) {
            this.nid = nid;
            this.timeout = timeout;
            this.now = System.currentTimeMillis() - MILL_ORIGIN;
        }

        public long getNid() {
            return this.nid;
        }

        public long getNow() {
            return this.now;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long currNow = System.currentTimeMillis() - MILL_ORIGIN;
            long d = unit.convert(this.now + this.timeout - currNow, TimeUnit.MILLISECONDS);
            return d;
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof DeadNodeDelayed) {
                DeadNodeDelayed x = (DeadNodeDelayed)other;
                long diff = this.now + this.timeout - (x.now + x.timeout);
                return diff == 0L ? 0 : (diff < 0L ? 1 : -1);
            }
            long d = this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS);
            return d == 0L ? 0 : (d < 0L ? 1 : -1);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.nid ^ this.nid >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DeadNodeDelayed)) {
                return false;
            }
            DeadNodeDelayed other = (DeadNodeDelayed)obj;
            return this.nid == other.nid;
        }
    }
}

