/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.common.arbitrate;

import com.alibaba.otter.manager.biz.config.channel.ChannelService;
import com.alibaba.otter.manager.biz.config.node.NodeService;
import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfig;
import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigRegistry;
import com.alibaba.otter.shared.common.model.config.ConfigException;
import com.alibaba.otter.shared.common.model.config.channel.Channel;
import com.alibaba.otter.shared.common.model.config.node.Node;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.common.utils.cache.RefreshMemoryMirror;
import com.google.common.base.Function;
import com.google.common.collect.OtterMigrateMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public class ArbitrateConfigImpl
implements ArbitrateConfig,
InitializingBean {
    private static final Long DEFAULT_PERIOD = 60000L;
    private Long timeout = DEFAULT_PERIOD;
    private RefreshMemoryMirror<Long, Channel> channelCache;
    private Map<Long, Long> channelMapping;
    private ChannelService channelService;
    private NodeService nodeService;
    private RefreshMemoryMirror<Long, Node> nodeCache;

    public ArbitrateConfigImpl() {
        ArbitrateConfigRegistry.regist((ArbitrateConfig)this);
    }

    public Node currentNode() {
        return null;
    }

    public Node findNode(Long nid) {
        return (Node)this.nodeCache.get((Object)nid);
    }

    public Channel findChannel(Long channelId) {
        return (Channel)this.channelCache.get((Object)channelId);
    }

    public Channel findChannelByPipelineId(Long pipelineId) {
        Long channelId = this.channelMapping.get(pipelineId);
        return (Channel)this.channelCache.get((Object)channelId);
    }

    public Pipeline findOppositePipeline(Long pipelineId) {
        Long channelId = this.channelMapping.get(pipelineId);
        Channel channel = (Channel)this.channelCache.get((Object)channelId);
        List pipelines = channel.getPipelines();
        for (Pipeline pipeline : pipelines) {
            if (pipeline.getId().equals(pipelineId)) continue;
            return pipeline;
        }
        return null;
    }

    public Pipeline findPipeline(Long pipelineId) {
        Long channelId = this.channelMapping.get(pipelineId);
        Channel channel = (Channel)this.channelCache.get((Object)channelId);
        List pipelines = channel.getPipelines();
        for (Pipeline pipeline : pipelines) {
            if (!pipeline.getId().equals(pipelineId)) continue;
            return pipeline;
        }
        throw new ConfigException("no pipeline for pipelineId[" + pipelineId + "]");
    }

    public void afterPropertiesSet() throws Exception {
        this.channelMapping = OtterMigrateMap.makeComputingMap((Function)new Function<Long, Long>(){

            public Long apply(Long pipelineId) {
                Channel channel = ArbitrateConfigImpl.this.channelService.findByPipelineId(pipelineId);
                if (channel == null) {
                    throw new ConfigException("No Such Channel by pipelineId[" + pipelineId + "]");
                }
                ArbitrateConfigImpl.this.updateMapping(channel, pipelineId);
                ArbitrateConfigImpl.this.channelCache.put((Object)channel.getId(), (Object)channel);
                return channel.getId();
            }
        });
        this.channelCache = new RefreshMemoryMirror(this.timeout, (RefreshMemoryMirror.ComputeFunction)new RefreshMemoryMirror.ComputeFunction<Long, Channel>(){

            public Channel apply(Long key, Channel oldValue) {
                Channel channel = (Channel)ArbitrateConfigImpl.this.channelService.findById(key);
                if (channel == null) {
                    return oldValue;
                }
                ArbitrateConfigImpl.this.updateMapping(channel, null);
                return channel;
            }
        });
        this.nodeCache = new RefreshMemoryMirror(this.timeout, (RefreshMemoryMirror.ComputeFunction)new RefreshMemoryMirror.ComputeFunction<Long, Node>(){

            public Node apply(Long key, Node oldValue) {
                Node node = (Node)ArbitrateConfigImpl.this.nodeService.findById(key);
                if (node == null) {
                    return oldValue;
                }
                return node;
            }
        });
    }

    private void updateMapping(Channel channel, Long excludeId) {
        Long channelId = channel.getId();
        List pipelines = channel.getPipelines();
        for (Pipeline pipeline : pipelines) {
            if (excludeId != null && pipeline.getId().equals(excludeId)) continue;
            this.channelMapping.put(pipeline.getId(), channelId);
        }
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }
}

