/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.common.alarm;

import com.alibaba.otter.manager.biz.common.alarm.AbstractAlarmService;
import com.alibaba.otter.manager.biz.common.alarm.AlarmMessage;
import com.alibaba.otter.manager.biz.config.parameter.SystemParameterService;
import com.alibaba.otter.shared.common.model.config.parameter.SystemParameter;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class DefaultAlarmService
extends AbstractAlarmService {
    private static final String TITLE = "alarm_from_otter";
    private String username;
    private JavaMailSender mailSender;
    private SystemParameterService systemParameterService;

    @Override
    public void doSend(AlarmMessage data) throws Exception {
        SimpleMailMessage mail = new SimpleMailMessage();
        mail.setFrom(this.username);
        mail.setSubject(TITLE);
        mail.setText(data.getMessage());
        String[] receiveKeys = StringUtils.split((String)StringUtils.replace((String)data.getReceiveKey(), (String)";", (String)","), (String)",");
        SystemParameter systemParameter = this.systemParameterService.find();
        ArrayList<String> mailAddress = new ArrayList<String>();
        for (String receiveKey : receiveKeys) {
            String[] strs;
            String receiver = this.convertToReceiver(systemParameter, receiveKey);
            for (String str : strs = StringUtils.split((String)StringUtils.replace((String)receiver, (String)";", (String)","), (String)",")) {
                if (this.isMail(str)) {
                    if (str == null) continue;
                    mailAddress.add(str);
                    continue;
                }
                if (!this.isSms(str)) continue;
            }
        }
        if (!mailAddress.isEmpty()) {
            mail.setTo(mailAddress.toArray(new String[mailAddress.size()]));
            this.doSendMail(mail);
        }
    }

    private void doSendMail(SimpleMailMessage mail) {
        JavaMailSenderImpl mailSenderImpl;
        if (this.mailSender instanceof JavaMailSenderImpl && StringUtils.isNotEmpty((String)(mailSenderImpl = (JavaMailSenderImpl)this.mailSender).getUsername()) && StringUtils.isNotEmpty((String)mailSenderImpl.getPassword())) {
            this.mailSender.send(mail);
        }
    }

    private boolean isMail(String receiveKey) {
        return StringUtils.contains((String)receiveKey, (char)'@');
    }

    private boolean isSms(String receiveKey) {
        return false;
    }

    private String convertToReceiver(SystemParameter systemParameter, String receiveKey) {
        if (StringUtils.equalsIgnoreCase((String)systemParameter.getDefaultAlarmReceiveKey(), (String)receiveKey)) {
            return systemParameter.getDefaultAlarmReceiver();
        }
        return (String)systemParameter.getAlarmReceiver().get(receiveKey);
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setSystemParameterService(SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }
}

