/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.common.alarm;

import com.alibaba.otter.manager.biz.common.alarm.AlarmMessage;
import com.alibaba.otter.manager.biz.common.alarm.AlarmService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractAlarmService
implements AlarmService,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAlarmService.class);
    private BlockingQueue<AlarmMessage> queue = new LinkedBlockingQueue<AlarmMessage>(32400);
    private ExecutorService executor;
    private int period = 150;

    @Override
    public void sendAlarm(AlarmMessage data) {
        try {
            if (!this.queue.offer(data, 2L, TimeUnit.SECONDS)) {
                logger.error(String.format("alarm sent to queue error : [%s]", data.toString()));
            }
        }
        catch (Exception e) {
            logger.error(String.format("send alarm [%s] to drgoon agent error!", data.toString()), (Throwable)e);
        }
    }

    private void sendAlarmInternal() {
        AlarmMessage data = null;
        try {
            data = this.queue.take();
            this.doSend(data);
            logger.info(String.format("has sent alarm [%s] to drgoon agent.", data.toString()));
        }
        catch (InterruptedException e) {
            logger.warn("otter-sendAlarm-worker was interrupted", (Throwable)e);
        }
        catch (Exception e) {
            logger.error(String.format("send alarm [%s] to drgoon agent error!", data.toString()), (Throwable)e);
        }
    }

    protected abstract void doSend(AlarmMessage var1) throws Exception;

    public void afterPropertiesSet() throws Exception {
        this.executor = Executors.newFixedThreadPool(1);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    AbstractAlarmService.this.sendAlarmInternal();
                    LockSupport.parkNanos((long)AbstractAlarmService.this.period * 1000L * 1000L);
                }
            }
        });
    }

    public void destroy() throws Exception {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
            this.executor.awaitTermination(2L, TimeUnit.SECONDS);
        }
        if (!this.queue.isEmpty()) {
            int size = this.queue.size();
            logger.warn(String.format("there are %d alarms wait to be sent \n %s", size, this.dumpQueue()));
        }
    }

    protected String dumpQueue() {
        if (this.queue.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (AlarmMessage data : this.queue) {
            sb.append(data.toString()).append("\n");
        }
        return sb.toString();
    }

    public void setPeriod(int period) {
        this.period = period;
    }
}

