/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.common;

import com.alibaba.otter.common.push.datasource.DataSourceHanlder;
import com.alibaba.otter.shared.common.model.config.data.DataMediaSource;
import com.alibaba.otter.shared.common.model.config.data.DataMediaType;
import com.alibaba.otter.shared.common.model.config.data.db.DbMediaSource;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DataSourceCreator
implements DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceCreator.class);
    private int maxWait = 60000;
    private int minIdle = 0;
    private int initialSize = 1;
    private int maxActive = 5;
    private int maxIdle = 1;
    private int numTestsPerEvictionRun = -1;
    private int timeBetweenEvictionRunsMillis = 60000;
    private int removeAbandonedTimeout = 600;
    private int minEvictableIdleTimeMillis = 1800000;
    private List<DataSourceHanlder> dataSourceHandlers;

    public DataSource createDataSource(DataMediaSource dataMediaSource) {
        Assert.notNull((Object)dataMediaSource);
        DbMediaSource dbMediaSource = (DbMediaSource)dataMediaSource;
        DataSource customDataSource = this.preCreate(0L, dbMediaSource);
        if (customDataSource != null) {
            return customDataSource;
        }
        return this.createDataSource(dbMediaSource.getUrl(), dbMediaSource.getUsername(), dbMediaSource.getPassword(), dbMediaSource.getDriver(), dbMediaSource.getType(), dbMediaSource.getEncode());
    }

    public void destroyDataSource(DataSource dataSource) {
        try {
            if (this.letHandlerDestroyIfSupport(0L, dataSource)) {
                return;
            }
            if (dataSource == null) {
                return;
            }
            BasicDataSource basicDataSource = (BasicDataSource)dataSource;
            basicDataSource.close();
        }
        catch (SQLException e) {
            logger.error("ERROR ## close the datasource has an error", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
    }

    private DataSource preCreate(Long pipelineId, DbMediaSource dbMediaSource) {
        if (CollectionUtils.isEmpty(this.dataSourceHandlers)) {
            return null;
        }
        DataSource dataSource = null;
        for (DataSourceHanlder handler : this.dataSourceHandlers) {
            if (!handler.support(dbMediaSource) || (dataSource = handler.create(pipelineId, dbMediaSource)) == null) continue;
            return dataSource;
        }
        return null;
    }

    public boolean letHandlerDestroyIfSupport(Long pipelineId, DataSource source) {
        boolean destroied = false;
        if (CollectionUtils.isEmpty(this.dataSourceHandlers)) {
            return destroied;
        }
        for (DataSourceHanlder handler : this.dataSourceHandlers) {
            if (!handler.support(source)) continue;
            handler.destory(pipelineId);
            destroied = true;
            return destroied;
        }
        return destroied;
    }

    private DataSource createDataSource(String url, String userName, String password, String driverClassName, DataMediaType dataMediaType, String encoding) {
        BasicDataSource dbcpDs = new BasicDataSource();
        dbcpDs.setInitialSize(this.initialSize);
        dbcpDs.setMaxActive(this.maxActive);
        dbcpDs.setMaxIdle(this.maxIdle);
        dbcpDs.setMinIdle(this.minIdle);
        dbcpDs.setMaxWait((long)this.maxWait);
        dbcpDs.setRemoveAbandoned(true);
        dbcpDs.setLogAbandoned(true);
        dbcpDs.setRemoveAbandonedTimeout(this.removeAbandonedTimeout);
        dbcpDs.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        dbcpDs.setTestOnBorrow(false);
        dbcpDs.setTestOnReturn(false);
        dbcpDs.setTestWhileIdle(true);
        dbcpDs.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis);
        dbcpDs.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis);
        dbcpDs.setDriverClassName(driverClassName);
        dbcpDs.setUrl(url);
        dbcpDs.setUsername(userName);
        dbcpDs.setPassword(password);
        if (dataMediaType.isOracle()) {
            dbcpDs.addConnectionProperty("restrictGetTables", "true");
        } else if (dataMediaType.isMysql()) {
            dbcpDs.addConnectionProperty("useServerPrepStmts", "false");
            dbcpDs.addConnectionProperty("rewriteBatchedStatements", "true");
            dbcpDs.addConnectionProperty("zeroDateTimeBehavior", "convertToNull");
            dbcpDs.addConnectionProperty("yearIsDateType", "false");
            dbcpDs.addConnectionProperty("noDatetimeStringSync", "true");
            if (StringUtils.isNotEmpty((String)encoding)) {
                if (StringUtils.equalsIgnoreCase((String)encoding, (String)"utf8mb4")) {
                    dbcpDs.addConnectionProperty("characterEncoding", "utf8");
                    dbcpDs.setConnectionInitSqls(Arrays.asList("set names utf8mb4"));
                } else {
                    dbcpDs.addConnectionProperty("characterEncoding", encoding);
                }
            }
        } else {
            logger.error("ERROR ## Unknow database type");
        }
        return dbcpDs;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        this.removeAbandonedTimeout = removeAbandonedTimeout;
    }

    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public void setDataSourceHandlers(List<DataSourceHanlder> dataSourceHandlers) {
        this.dataSourceHandlers = dataSourceHandlers;
    }
}

