/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.autokeeper.impl;

import com.alibaba.otter.manager.biz.autokeeper.AutoKeeperStatService;
import com.alibaba.otter.manager.biz.autokeeper.impl.AutoKeeperData;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperConnectionStat;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperEphemeralStat;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperServerStat;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperWatchStat;
import java.util.ArrayList;
import java.util.List;

public class AutoKeeperStatServiceImpl
implements AutoKeeperStatService {
    private AutoKeeperData autoKeeperData;

    @Override
    public AutoKeeperServerStat findServerStat(String serverAddress) {
        return this.autoKeeperData.getServerStats().get(serverAddress);
    }

    @Override
    public AutoKeeperServerStat findServerStatBySessionId(String sessionId) {
        String serverAddress = this.autoKeeperData.getConnectionStats().get(sessionId).getServerAddress();
        return this.findServerStat(serverAddress);
    }

    @Override
    public AutoKeeperConnectionStat findConnectionBySessionId(String sessionId) {
        return this.autoKeeperData.getConnectionStats().get(sessionId);
    }

    @Override
    public AutoKeeperConnectionStat findConnectionByEphemeralPath(String path) {
        for (AutoKeeperConnectionStat connection : this.autoKeeperData.getConnectionStats().values()) {
            for (AutoKeeperEphemeralStat ephemeral : connection.getEphemeralStats()) {
                if (!ephemeral.getPaths().contains(path)) continue;
                return connection;
            }
        }
        return null;
    }

    @Override
    public List<AutoKeeperConnectionStat> findConnectionByWatcherPath(String path) {
        ArrayList<AutoKeeperConnectionStat> connections = new ArrayList<AutoKeeperConnectionStat>();
        for (AutoKeeperConnectionStat connection : this.autoKeeperData.getConnectionStats().values()) {
            for (AutoKeeperWatchStat watch : connection.getWatchStats()) {
                if (!watch.getPaths().contains(path)) continue;
                connections.add(connection);
            }
        }
        return connections;
    }

    public void setAutoKeeperData(AutoKeeperData autoKeeperData) {
        this.autoKeeperData = autoKeeperData;
    }
}

