/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.autokeeper.impl;

import com.alibaba.otter.manager.biz.autokeeper.impl.AutoKeeperPersist;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperConnectionStat;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperEphemeralStat;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperServerStat;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperWatchStat;
import com.google.common.collect.MapMaker;
import java.util.List;
import java.util.Map;

public class AutoKeeperData
implements AutoKeeperPersist {
    private Map<String, AutoKeeperServerStat> serverStats = new MapMaker().makeMap();
    private Map<String, AutoKeeperConnectionStat> connectionStats = new MapMaker().makeMap();

    public void joinServer(String address, AutoKeeperServerStat summary) {
        this.serverStats.put(address, summary);
    }

    public void joinConnection(String address, List<AutoKeeperConnectionStat> connections) {
        for (AutoKeeperConnectionStat connection : connections) {
            this.connectionStats.put(connection.getSessionId(), connection);
        }
        if (this.serverStats.containsKey(address)) {
            this.serverStats.get(address).getConnectionStats().addAll(connections);
        }
    }

    public void joinEphemeral(String address, List<AutoKeeperEphemeralStat> ephemerals) {
        for (AutoKeeperEphemeralStat ephemeral : ephemerals) {
            if (!this.connectionStats.containsKey(ephemeral.getSessionId())) continue;
            this.connectionStats.get(ephemeral.getSessionId()).getEphemeralStats().add(ephemeral);
        }
    }

    public void joinWatch(String address, List<AutoKeeperWatchStat> watches) {
        for (AutoKeeperWatchStat watch : watches) {
            if (!this.connectionStats.containsKey(watch.getSessionId())) continue;
            this.connectionStats.get(watch.getSessionId()).getWatchStats().add(watch);
        }
    }

    @Override
    public void persist() {
        this.serverStats.clear();
        this.connectionStats.clear();
    }

    public Map<String, AutoKeeperServerStat> getServerStats() {
        return this.serverStats;
    }

    public Map<String, AutoKeeperConnectionStat> getConnectionStats() {
        return this.connectionStats;
    }
}

