/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.autokeeper.impl;

import com.alibaba.otter.manager.biz.autokeeper.impl.AutoKeeperData;
import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.config.autokeeper.AutoKeeperClusterService;
import com.alibaba.otter.manager.biz.utils.RegexUtils;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperCluster;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperConnectionStat;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperEphemeralStat;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperQuorumType;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperServerStat;
import com.alibaba.otter.shared.common.model.autokeeper.AutoKeeperWatchStat;
import com.alibaba.otter.shared.common.utils.cmd.Exec;
import com.alibaba.otter.shared.common.utils.thread.NamedThreadFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;

public class AutoKeeperCollector
implements InitializingBean {
    @Resource(name="autoKeeperClusterService")
    private AutoKeeperClusterService autoKeeperClusterService;
    private static final String MODE_FOLLOWER = "Mode: follower";
    private static final String MODE_LEADERER = "Mode: leader";
    private static final String MODE_OBSERVER = "Mode: observer";
    private static final String MODE_STANDALONE = "Mode: standalone";
    private static final String NODE_COUNT = "Node count:";
    private static final String STRING_LATENCY = "Latency min/avg/max:";
    private static final String STRING_SENT = "Sent:";
    private static final String STRING_RECEIVED = "Received:";
    private static final String STRING_OUTSTANDING = "Outstanding:";
    private static final String COMMA = ",";
    private static final String BRACKETS = ")";
    private static final String COLON = ":";
    private static final String WRAP = "\n";
    private static final String CMD_STAT = "echo stat | nc %s %s";
    private static final String CMD_CONS = "echo cons | nc %s %s";
    private static final String CMD_DUMP = "echo dump | nc %s %s";
    private static final String CMD_WCHC = "echo wchc | nc %s %s";
    private static final long DEFAULT_COLLECT_INTERVAL = 300L;
    private long delay = 1L;
    private int singleSize = 1;
    private long collectInterval = 300L;
    private AutoKeeperData autoKeeperData;
    private ScheduledExecutorService collectorExecutor;

    public void collectorConnectionStat(String address) {
        List<String> netAddress = this.splitAddress(address);
        if (netAddress.isEmpty()) {
            return;
        }
        String ip = netAddress.get(0);
        String port = netAddress.get(1);
        String[] cmd = new String[]{"/bin/bash", "-c", String.format(CMD_CONS, ip, port)};
        String cmdresult = AutoKeeperCollector.collector(cmd);
        String[] result = cmdresult.split(WRAP);
        ArrayList<AutoKeeperConnectionStat> summary = new ArrayList<AutoKeeperConnectionStat>();
        for (String line : result) {
            String[] lineArray;
            if (StringUtils.isBlank((String)line) || 2 != (lineArray = line.split(COLON)).length) continue;
            AutoKeeperConnectionStat autoKeeperConnectionStat = new AutoKeeperConnectionStat();
            autoKeeperConnectionStat.setOriginalContent(line);
            String clientIp = StringUtils.trimToEmpty((String)line.split(COLON)[0].replace("/", ""));
            String sessionId = StringUtils.trimToEmpty((String)RegexUtils.findFirst(line.split(COLON)[1], "sid=(?s).*?[,)]")).replace("sid=", "").replace(COMMA, "").replace(BRACKETS, "");
            String queued = StringUtils.trimToEmpty((String)RegexUtils.findFirst(line.split(COLON)[1], "queued=(?s).*?[,)]")).replace("queued=", "").replace(COMMA, "").replace(BRACKETS, "");
            String receive = StringUtils.trimToEmpty((String)RegexUtils.findFirst(line.split(COLON)[1], "recved=(?s).*?[,)]")).replace("recved=", "").replace(COMMA, "").replace(BRACKETS, "");
            String sent = StringUtils.trimToEmpty((String)RegexUtils.findFirst(line.split(COLON)[1], "sent=(?s).*?[,)]")).replace("sent=", "").replace(COMMA, "").replace(BRACKETS, "");
            String minlat = StringUtils.trimToEmpty((String)RegexUtils.findFirst(line.split(COLON)[1], "minlat=(?s).*?[,)]")).replace("minlat=", "").replace(COMMA, "").replace(BRACKETS, "");
            String avglat = StringUtils.trimToEmpty((String)RegexUtils.findFirst(line.split(COLON)[1], "avglat=(?s).*?[,)]")).replace("avglat=", "").replace(COMMA, "").replace(BRACKETS, "");
            String maxlat = StringUtils.trimToEmpty((String)RegexUtils.findFirst(line.split(COLON)[1], "maxlat=(?s).*?[,)]")).replace("maxlat=", "").replace(COMMA, "").replace(BRACKETS, "");
            autoKeeperConnectionStat.setServerAddress(ip);
            autoKeeperConnectionStat.setClientAddress(clientIp);
            autoKeeperConnectionStat.setSessionId(sessionId);
            if (StringUtils.isNotEmpty((String)queued)) {
                autoKeeperConnectionStat.setQueued(Long.parseLong(queued));
            }
            if (StringUtils.isNotEmpty((String)receive)) {
                autoKeeperConnectionStat.setRecved(Long.parseLong(receive));
            }
            if (StringUtils.isNotEmpty((String)sent)) {
                autoKeeperConnectionStat.setSent(Long.parseLong(sent));
            }
            if (StringUtils.isNotEmpty((String)minlat)) {
                autoKeeperConnectionStat.setMinLatency(Long.parseLong(minlat));
            }
            if (StringUtils.isNotEmpty((String)avglat)) {
                autoKeeperConnectionStat.setAvgLatency(Long.parseLong(avglat));
            }
            if (StringUtils.isNotEmpty((String)maxlat)) {
                autoKeeperConnectionStat.setMaxLatency(Long.parseLong(maxlat));
            }
            summary.add(autoKeeperConnectionStat);
        }
        this.autoKeeperData.joinConnection(address, summary);
    }

    public void collectorServerStat(String address) {
        List<String> netAddress = this.splitAddress(address);
        if (netAddress.isEmpty()) {
            return;
        }
        String ip = netAddress.get(0);
        String port = netAddress.get(1);
        String[] cmd = new String[]{"/bin/bash", "-c", String.format(CMD_STAT, ip, port)};
        String cmdresult = AutoKeeperCollector.collector(cmd);
        String[] result = cmdresult.split(WRAP);
        AutoKeeperServerStat summary = new AutoKeeperServerStat();
        summary.setOriginalContent(cmdresult);
        for (String line : result) {
            if (line.contains(MODE_FOLLOWER)) {
                summary.setQuorumType(AutoKeeperQuorumType.FOLLOWER);
                continue;
            }
            if (line.contains(MODE_LEADERER)) {
                summary.setQuorumType(AutoKeeperQuorumType.LEADER);
                continue;
            }
            if (line.contains(MODE_STANDALONE)) {
                summary.setQuorumType(AutoKeeperQuorumType.STANDALONE);
                continue;
            }
            if (line.contains(MODE_OBSERVER)) {
                summary.setQuorumType(AutoKeeperQuorumType.OBSERVER);
                continue;
            }
            if (line.contains(STRING_LATENCY)) {
                List<String> latency = Arrays.asList(StringUtils.trimToEmpty((String)line.replace(STRING_LATENCY, "")).split("/"));
                summary.setMinLatency(Long.parseLong(latency.get(0)));
                summary.setAvgLatency(Long.parseLong(latency.get(1)));
                summary.setMaxLatency(Long.parseLong(latency.get(2)));
                continue;
            }
            if (line.contains(STRING_OUTSTANDING)) {
                summary.setQueued(Long.parseLong(StringUtils.trimToEmpty((String)line.replace(STRING_OUTSTANDING, ""))));
                continue;
            }
            if (line.contains(NODE_COUNT)) {
                summary.setNodeCount(Long.parseLong(StringUtils.trimToEmpty((String)line.replace(NODE_COUNT, ""))));
                continue;
            }
            if (line.contains(STRING_SENT)) {
                summary.setSent(Long.parseLong(StringUtils.trimToEmpty((String)line.replace(STRING_SENT, ""))));
                continue;
            }
            if (!line.contains(STRING_RECEIVED)) continue;
            summary.setRecved(Long.parseLong(StringUtils.trimToEmpty((String)line.replace(STRING_RECEIVED, ""))));
        }
        this.autoKeeperData.joinServer(address, summary);
    }

    public void collectorEphemeralStat(String address) {
        List<String> netAddress = this.splitAddress(address);
        if (netAddress.isEmpty()) {
            return;
        }
        String ip = netAddress.get(0);
        String port = netAddress.get(1);
        String[] cmd = new String[]{"/bin/bash", "-c", String.format(CMD_DUMP, ip, port)};
        String cmdresult = AutoKeeperCollector.collector(cmd);
        Map<String, List<String>> pathMap = this.groupSessionPath(cmdresult);
        ArrayList<AutoKeeperEphemeralStat> autoKeeperEphemeralStats = new ArrayList<AutoKeeperEphemeralStat>();
        for (Map.Entry<String, List<String>> entry : pathMap.entrySet()) {
            AutoKeeperEphemeralStat autoKeeperEphemeralStat = new AutoKeeperEphemeralStat();
            autoKeeperEphemeralStat.setSessionId(entry.getKey());
            autoKeeperEphemeralStat.setPaths(entry.getValue());
            autoKeeperEphemeralStats.add(autoKeeperEphemeralStat);
        }
        this.autoKeeperData.joinEphemeral(address, autoKeeperEphemeralStats);
    }

    public void collectorWatchStat(String address) {
        List<String> netAddress = this.splitAddress(address);
        if (netAddress.isEmpty()) {
            return;
        }
        String ip = netAddress.get(0);
        String port = netAddress.get(1);
        String[] cmd = new String[]{"/bin/bash", "-c", String.format(CMD_WCHC, ip, port)};
        String cmdresult = AutoKeeperCollector.collector(cmd);
        Map<String, List<String>> pathMap = this.groupSessionPath(cmdresult);
        ArrayList<AutoKeeperWatchStat> autoKeeperWatchStats = new ArrayList<AutoKeeperWatchStat>();
        for (Map.Entry<String, List<String>> entry : pathMap.entrySet()) {
            AutoKeeperWatchStat autoKeeperWatchStat = new AutoKeeperWatchStat();
            autoKeeperWatchStat.setSessionId(entry.getKey());
            autoKeeperWatchStat.setPaths(entry.getValue());
            autoKeeperWatchStats.add(autoKeeperWatchStat);
        }
        this.autoKeeperData.joinWatch(address, autoKeeperWatchStats);
    }

    public static String collector(String[] command) {
        Exec.Result result = null;
        try {
            result = Exec.execute((String[])command);
            if (result.getExitCode() == 0) {
                return result.getStdout();
            }
            return result.getStderr();
        }
        catch (Exception e) {
            throw new ManagerException(e);
        }
    }

    private List<String> splitAddress(String address) {
        List<String> ipPort = Arrays.asList(address.split(COLON));
        if (ipPort.size() != 2) {
            return new ArrayList<String>();
        }
        return ipPort;
    }

    private Map<String, List<String>> groupSessionPath(String cmdresult) {
        String[] result = cmdresult.split(WRAP);
        HashMap<String, List<String>> pathMap = new HashMap<String, List<String>>();
        String sessionId = "";
        for (String line : result) {
            if (StringUtils.isBlank((String)(line = StringUtils.trimToEmpty((String)line)))) continue;
            if (line.startsWith("0x")) {
                sessionId = line.replace(COLON, "");
                pathMap.put(sessionId, new ArrayList());
                continue;
            }
            if (!line.startsWith("/")) continue;
            List paths = (List)pathMap.get(sessionId);
            paths.add(line);
        }
        return pathMap;
    }

    public void afterPropertiesSet() throws Exception {
        this.collectorExecutor = Executors.newScheduledThreadPool(this.singleSize, (ThreadFactory)new NamedThreadFactory("collector-thread", true));
        this.startCollect();
    }

    private void startCollect() {
        this.collectorExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                List<AutoKeeperCluster> autoKeeperClusters = AutoKeeperCollector.this.autoKeeperClusterService.listAutoKeeperClusters();
                if (!autoKeeperClusters.isEmpty()) {
                    AutoKeeperCollector.this.autoKeeperData.persist();
                    for (AutoKeeperCluster autoKeeperCluster : autoKeeperClusters) {
                        List servers = autoKeeperCluster.getServerList();
                        for (String address : servers) {
                            AutoKeeperCollector.this.collectorServerStat(address);
                            AutoKeeperCollector.this.collectorConnectionStat(address);
                            AutoKeeperCollector.this.collectorWatchStat(address);
                            AutoKeeperCollector.this.collectorEphemeralStat(address);
                        }
                    }
                }
            }
        }, this.delay, this.collectInterval, TimeUnit.SECONDS);
    }

    public void setAutoKeeperClusterService(AutoKeeperClusterService autoKeeperClusterService) {
        this.autoKeeperClusterService = autoKeeperClusterService;
    }

    public void setAutoKeeperData(AutoKeeperData autoKeeperData) {
        this.autoKeeperData = autoKeeperData;
    }

    public void setCollectInterval(long collectInterval) {
        this.collectInterval = collectInterval;
    }
}

