/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler.jdbc;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcColumnValues;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;

public class JdbcDateColumnValues
extends JdbcColumnValues {
    String[] array;
    HoloConfig config;

    public JdbcDateColumnValues(TimestampUtils timestampUtils, int rowCount, HoloConfig config) {
        super(timestampUtils, rowCount);
        this.array = new String[rowCount];
        this.config = config;
    }

    @Override
    public void doSet(int row, Object in) throws SQLException {
        if (in instanceof String && this.config.isInputStringAsEpochMsForDatetimeColumn()) {
            Long value = null;
            try {
                value = Long.parseLong(String.valueOf(in));
            }
            catch (Exception ignore) {
                value = null;
            }
            if (value != null) {
                this.setDate(row, new java.sql.Date(value));
                return;
            }
        }
        if (in instanceof Number && this.config.isInputNumberAsEpochMsForDatetimeColumn()) {
            this.setDate(row, new java.sql.Date(((Number)in).longValue()));
        } else if (in instanceof java.sql.Date) {
            this.setDate(row, (java.sql.Date)in);
        } else {
            java.sql.Date tmpd;
            if (in instanceof Date) {
                tmpd = new java.sql.Date(((Date)in).getTime());
            } else {
                if (in instanceof LocalDate) {
                    this.setDate(row, (LocalDate)in);
                    return;
                }
                tmpd = this.timestampUtils.toDate(this.getDefaultCalendar(), in.toString());
            }
            this.setDate(row, tmpd);
        }
    }

    private void setDate(int i, LocalDate localDate) throws SQLException {
        this.array[i] = this.timestampUtils.toString(localDate);
    }

    public void setDate(int row, java.sql.Date x) throws SQLException {
        this.setDate(row, x, null);
    }

    public void setDate(int i, java.sql.Date d, Calendar cal) throws SQLException {
        if (d == null) {
            return;
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.array[i] = this.timestampUtils.toString(cal, d);
    }

    @Override
    public Object[] getArray() {
        return this.array;
    }
}

