/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.binlog;

import com.alibaba.hologres.client.utils.Tuple;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Committer {
    final BlockingQueue<Tuple<CompletableFuture<Void>, Long>> queue;
    long lastReadLsn = -1L;

    public Committer(BlockingQueue<Tuple<CompletableFuture<Void>, Long>> queue) {
        this.queue = queue;
    }

    public void updateLastReadLsn(long lastReadLsn) {
        this.lastReadLsn = lastReadLsn;
    }

    public CompletableFuture<Void> commit(long timeout) throws InterruptedException, TimeoutException {
        return this.commit(this.lastReadLsn, timeout);
    }

    public CompletableFuture<Void> commit(long lsn, long timeout) throws InterruptedException, TimeoutException {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        boolean ret = this.queue.offer(new Tuple(future, lsn), timeout, TimeUnit.MILLISECONDS);
        if (!ret) {
            throw new TimeoutException();
        }
        return future;
    }

    public long getLastReadLsn() {
        return this.lastReadLsn;
    }
}

