/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.blink.dataformat;

import com.alibaba.blink.dataformat.BinaryArray;
import com.alibaba.blink.dataformat.BinaryRow;
import com.alibaba.blink.dataformat.BinaryString;
import com.alibaba.blink.memory.DataOutputViewStreamWrapper;
import com.alibaba.blink.memory.MemorySegment;
import com.alibaba.blink.memory.MemorySegmentFactory;
import com.alibaba.blink.memory.MemorySegmentWritable;
import com.alibaba.blink.util.StringUtf8Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public abstract class BinaryWriter {
    protected MemorySegment segment;
    protected int cursor;
    protected DataOutputViewStreamWrapper outputView = new DataOutputViewStreamWrapper(new BinaryRowWriterOutputView());

    public static int roundNumberOfBytesToNearestWord(int numBytes) {
        int remainder = numBytes & 7;
        if (remainder == 0) {
            return numBytes;
        }
        return numBytes + (8 - remainder);
    }

    public abstract void setOffsetAndSize(int var1, int var2, long var3);

    public abstract int getFieldOffset(int var1);

    public void writeString(int pos, String input) {
        byte[] bytes = StringUtf8Utils.allocateBytes(input.length() * 3);
        int len = StringUtf8Utils.encodeUTF8(input, bytes);
        if (len <= 7) {
            BinaryWriter.writeLittleBytes(this.segment, this.getFieldOffset(pos), bytes, len);
        } else {
            this.writeBigBytes(pos, bytes, len);
        }
    }

    public void writeByteArray(int pos, byte[] input) {
        int len = input.length;
        if (len <= 7) {
            BinaryWriter.writeLittleBytes(this.segment, this.getFieldOffset(pos), input, len);
        } else {
            this.writeBigBytes(pos, input, len);
        }
    }

    public void writeBinaryString(int pos, BinaryString input) {
        if (input.numBytes() <= 7) {
            byte[] bytes = StringUtf8Utils.allocateBytes(input.numBytes());
            input.copyTo(bytes);
            BinaryWriter.writeLittleBytes(this.segment, this.getFieldOffset(pos), bytes, input.numBytes());
        } else {
            this.writeBigBinaryString(pos, input);
        }
    }

    public void writeSegs(int pos, MemorySegment[] segments, int offset, int size) {
        int roundedSize = BinaryWriter.roundNumberOfBytesToNearestWord(size);
        this.ensureCapacity(roundedSize);
        this.zeroOutPaddingBytes(size);
        if (segments.length == 1) {
            segments[0].copyTo(offset, this.segment, this.cursor, size);
        } else {
            this.writeSegsSlow(segments, offset, size);
        }
        this.setOffsetAndSize(pos, this.cursor, size);
        this.cursor += roundedSize;
    }

    public void writeBinaryArray(int pos, BinaryArray input) {
        this.writeSegs(pos, input.getSegments(), input.getBaseOffset(), input.getSizeInBytes());
    }

    void writeBigBytes(int pos, byte[] bytes) {
        this.writeBigBytes(pos, bytes, bytes.length);
    }

    private void writeBigBytes(int pos, byte[] bytes, int len) {
        int roundedSize = BinaryWriter.roundNumberOfBytesToNearestWord(len);
        this.ensureCapacity(roundedSize);
        this.zeroOutPaddingBytes(len);
        this.segment.put(this.cursor, bytes, 0, len);
        this.setOffsetAndSize(pos, this.cursor, len);
        this.cursor += roundedSize;
    }

    private void writeBigBinaryString(int pos, BinaryString str) {
        int size = str.numBytes();
        int roundedSize = BinaryWriter.roundNumberOfBytesToNearestWord(size);
        this.ensureCapacity(roundedSize);
        this.zeroOutPaddingBytes(size);
        if (str.getSegments().length == 1) {
            str.getSegments()[0].copyTo(str.getOffset(), this.segment, this.cursor, str.numBytes());
        } else {
            this.writeSegsSlow(str.getSegments(), str.getOffset(), size);
        }
        this.setOffsetAndSize(pos, this.cursor, size);
        this.cursor += roundedSize;
    }

    private void writeSegsSlow(MemorySegment[] segments, int offset, int size) {
        int needCopy = size;
        int fromOffset = offset;
        int toOffset = this.cursor;
        for (MemorySegment sourceSegment : segments) {
            int remain = sourceSegment.size() - fromOffset;
            if (remain > 0) {
                int copySize = Math.min(remain, needCopy);
                sourceSegment.copyTo(fromOffset, this.segment, toOffset, copySize);
                needCopy -= copySize;
                toOffset += copySize;
                fromOffset = 0;
                continue;
            }
            fromOffset -= sourceSegment.size();
        }
    }

    public static void writeLittleBytes(MemorySegment segment, int fieldOffset, byte[] bytes, int len) {
        int i;
        long firstByte = len | 0x80;
        long sevenBytes = 0L;
        if (BinaryRow.LITTLE_ENDIAN) {
            for (i = 0; i < len; ++i) {
                sevenBytes |= (0xFFL & (long)bytes[i]) << (int)((long)i * 8L);
            }
        } else {
            for (i = 0; i < len; ++i) {
                sevenBytes |= (0xFFL & (long)bytes[i]) << (int)((long)(6 - i) * 8L);
            }
        }
        long offsetAndSize = firstByte << 56 | sevenBytes;
        segment.putLong(fieldOffset, offsetAndSize);
    }

    public abstract void writeBoolean(int var1, boolean var2);

    public abstract void writeByte(int var1, byte var2);

    public abstract void writeShort(int var1, short var2);

    public abstract void writeInt(int var1, int var2);

    public abstract void writeLong(int var1, long var2);

    public abstract void writeFloat(int var1, float var2);

    public abstract void writeDouble(int var1, double var2);

    public abstract void writeChar(int var1, char var2);

    private void zeroBytes(int offset, int size) {
        for (int i = offset; i < offset + size; ++i) {
            this.segment.put(i, (byte)0);
        }
    }

    protected void zeroOutPaddingBytes(int numBytes) {
        if ((numBytes & 7) > 0) {
            this.segment.putLong(this.cursor + (numBytes >> 3 << 3), 0L);
        }
    }

    protected void ensureCapacity(int neededSize) {
        int length = this.cursor + neededSize;
        if (this.segment.size() < length) {
            this.grow(length);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.segment.size();
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        this.segment = MemorySegmentFactory.wrap(Arrays.copyOf(this.segment.getHeapMemory(), newCapacity));
        this.afterGrow();
    }

    public abstract void afterGrow();

    private class BinaryRowWriterOutputView
    extends OutputStream
    implements MemorySegmentWritable {
        private BinaryRowWriterOutputView() {
        }

        @Override
        public void write(int b) throws IOException {
            BinaryWriter.this.ensureCapacity(1);
            BinaryWriter.this.segment.put(BinaryWriter.this.cursor, (byte)b);
            ++BinaryWriter.this.cursor;
        }

        @Override
        public void write(byte[] b) throws IOException {
            BinaryWriter.this.ensureCapacity(b.length);
            BinaryWriter.this.segment.put(BinaryWriter.this.cursor, b, 0, b.length);
            BinaryWriter.this.cursor += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            BinaryWriter.this.ensureCapacity(len);
            BinaryWriter.this.segment.put(BinaryWriter.this.cursor, b, off, len);
            BinaryWriter.this.cursor += len;
        }

        @Override
        public void write(MemorySegment seg, int off, int len) throws IOException {
            BinaryWriter.this.ensureCapacity(len);
            seg.copyTo(off, BinaryWriter.this.segment, BinaryWriter.this.cursor, len);
            BinaryWriter.this.cursor += len;
        }
    }
}

