/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseAPIProxy;
import com.alibaba.hbase.client.AliHBaseTableInterface;
import com.alibaba.hbase.client.AliHBaseUEConnection;
import com.alibaba.lindorm.client.core.meta.ExternalIndexConfig;
import com.alibaba.lindorm.client.core.meta.ExternalIndexField;
import com.alibaba.lindorm.client.core.meta.ExternalIndexRowFormatterType;
import com.alibaba.lindorm.client.core.meta.ExternalIndexType;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AliHBaseUEClusterConnection;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilderBase;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class AliHBaseUETable
extends HTable
implements AliHBaseTableInterface,
RegionLocator {
    private TableName tableName;
    private AliHBaseUEConnection connection;
    private Configuration conf;
    private int operationTimeout;
    private AliHBaseAPIProxy proxy;
    private static AliHBaseUEClusterConnection superConnection = null;

    private static AliHBaseUEClusterConnection getSuperConnection(AliHBaseUEConnection connection) throws IOException {
        if (superConnection == null || superConnection.isClosed()) {
            superConnection = new AliHBaseUEClusterConnection(connection);
        }
        return superConnection;
    }

    public AliHBaseUETable(TableName tableName, AliHBaseUEConnection connection) throws IOException {
        super((ClusterConnection)AliHBaseUETable.getSuperConnection(connection), (TableBuilderBase)new HTableBuilder(tableName), null, null, (ExecutorService)new NoopExecutorService());
        this.tableName = tableName;
        this.connection = connection;
        this.conf = connection.getConfiguration();
        this.operationTimeout = connection.getOperationTimeout();
        this.proxy = connection.getAPIProxy(tableName);
    }

    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        return this.getRegionLocation(row, false);
    }

    public HRegionLocation getRegionLocation(byte[] row, boolean b) throws IOException {
        return this.proxy.getRegionLocation(row);
    }

    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        return this.proxy.getAllRegionLocations();
    }

    public byte[][] getStartKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getFirst();
    }

    public byte[][] getEndKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getSecond();
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return this.proxy.getStartEndKeys();
    }

    public TableName getName() {
        return this.tableName;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public TableDescriptor getDescriptor() throws IOException {
        return this.proxy.getDescriptor(this.tableName);
    }

    public boolean exists(Get get2) throws IOException {
        return this.proxy.exists(get2);
    }

    public boolean[] exists(List<Get> gets) throws IOException {
        Result[] results = this.get(gets);
        boolean[] existResult = new boolean[results.length];
        for (int i = 0; i < results.length; ++i) {
            existResult[i] = results[i].getRow() != null;
        }
        return existResult;
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException {
        this.proxy.batch(actions, results);
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException {
        throw new IOException("BatchCallback not supported, use put(List<Put> puts), get(List<Get> gets) or delete(List<Delete> deletes) respectively");
    }

    public Result get(Get get2) throws IOException {
        return this.proxy.get(get2);
    }

    public Result[] get(List<Get> gets) throws IOException {
        return this.proxy.get(gets);
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        return this.proxy.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    public void put(Put put2) throws IOException {
        this.proxy.put(put2);
    }

    public void put(List<Put> puts) throws IOException {
        this.proxy.put(puts);
    }

    public void delete(Delete delete) throws IOException {
        this.proxy.delete(delete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        this.proxy.delete(deletes);
    }

    public Table.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        return this.proxy.checkAndMutate(row, family);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put2) throws IOException {
        return this.checkAndPut(row, family, qualifier, CompareOperator.EQUAL, value, put2);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put2) throws IOException {
        return this.checkAndPut(row, family, qualifier, CompareOperator.valueOf((String)compareOp.name()), value, put2);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Put put2) throws IOException {
        return this.proxy.checkAndPut(row, family, qualifier, op, value, put2);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.checkAndDelete(row, family, qualifier, CompareOperator.EQUAL, value, delete);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        return this.checkAndDelete(row, family, qualifier, CompareOperator.valueOf((String)compareOp.name()), value, delete);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Delete delete) throws IOException {
        return this.proxy.checkAndDelete(row, family, qualifier, op, value, delete);
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations mutation) throws IOException {
        return this.checkAndMutate(row, family, qualifier, CompareOperator.valueOf((String)compareOp.name()), value, mutation);
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, RowMutations mutation) throws IOException {
        return this.checkAndMutate(row, family).qualifier(qualifier).ifMatches(op, value).thenMutate(mutation);
    }

    public void mutateRow(RowMutations rm) throws IOException {
        this.proxy.mutateRow(rm);
    }

    public Result append(Append append2) throws IOException {
        return this.proxy.append(append2);
    }

    public Result increment(Increment increment2) throws IOException {
        return this.proxy.increment(increment2);
    }

    public void close() throws IOException {
        this.proxy.close();
    }

    public long getRpcTimeout(TimeUnit unit) {
        return unit.convert(this.operationTimeout, TimeUnit.MILLISECONDS);
    }

    public long getReadRpcTimeout(TimeUnit unit) {
        return unit.convert(this.operationTimeout, TimeUnit.MILLISECONDS);
    }

    public long getWriteRpcTimeout(TimeUnit unit) {
        return unit.convert(this.operationTimeout, TimeUnit.MILLISECONDS);
    }

    public long getOperationTimeout(TimeUnit unit) {
        return unit.convert(this.operationTimeout, TimeUnit.MILLISECONDS);
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        return this.proxy.coprocessorService(row);
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        return this.proxy.coprocessorService(service, startKey, endKey, callable);
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.proxy.coprocessorService(service, startKey, endKey, callable, callback);
    }

    public void batch(List<? extends Row> actions, Object[] results, int rpcTimeout) throws InterruptedException, IOException {
        this.batch(actions, results);
    }

    public <R> void processBatchCallback(List<? extends Row> list, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.batchCallback(list, results, callback);
    }

    public RegionLocator getRegionLocator() {
        return this;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return new HTableDescriptor(this.getDescriptor());
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        Increment increment2 = new Increment(row).addColumn(family, qualifier, amount);
        Cell cell = this.increment(increment2).getColumnLatestCell(family, qualifier);
        return Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        Increment increment2 = new Increment(row).addColumn(family, qualifier, amount).setDurability(durability);
        Cell cell = this.increment(increment2).getColumnLatestCell(family, qualifier);
        return Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
    }

    public void validatePut(Put put2) throws IllegalArgumentException {
        super.validatePut(put2);
    }

    ExecutorService getPool() {
        return super.getPool();
    }

    public void clearRegionCache() {
        super.clearRegionCache();
    }

    public int getRpcTimeout() {
        return super.getRpcTimeout();
    }

    public void setRpcTimeout(int rpcTimeout) {
        super.setRpcTimeout(rpcTimeout);
    }

    public int getReadRpcTimeout() {
        return super.getReadRpcTimeout();
    }

    public void setReadRpcTimeout(int readRpcTimeout) {
        super.setReadRpcTimeout(readRpcTimeout);
    }

    public int getWriteRpcTimeout() {
        return super.getWriteRpcTimeout();
    }

    public void setWriteRpcTimeout(int writeRpcTimeout) {
        super.setWriteRpcTimeout(writeRpcTimeout);
    }

    public int getOperationTimeout() {
        return super.getOperationTimeout();
    }

    public void setOperationTimeout(int operationTimeout) {
        super.setOperationTimeout(operationTimeout);
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        throw new NotImplementedException("batchCoprocessorService is not implemented!");
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new NotImplementedException("batchCoprocessorService is not implemented!");
    }

    public boolean[] existsAll(List<Get> gets) throws IOException {
        return this.exists(gets);
    }

    @Override
    public void addExternalIndex(String targetIndexName, ExternalIndexType type, ExternalIndexRowFormatterType rowFormatterType, List<ExternalIndexField> fields) throws IOException {
        ExternalIndexConfig config = new ExternalIndexConfig(targetIndexName, type, rowFormatterType);
        this.addExternalIndex(config, fields);
    }

    @Override
    public void addExternalIndex(String targetIndexName, ExternalIndexType type, ExternalIndexRowFormatterType rowFormatterType, ExternalIndexField ... fields) throws IOException {
        ArrayList<ExternalIndexField> list = new ArrayList<ExternalIndexField>();
        for (ExternalIndexField field : fields) {
            list.add(field);
        }
        this.addExternalIndex(targetIndexName, type, rowFormatterType, list);
    }

    @Override
    public void addExternalIndex(ExternalIndexConfig config, List<ExternalIndexField> fields) throws IOException {
        this.proxy.addExternalIndex(config, fields);
    }

    @Override
    public void addExternalIndex(ExternalIndexConfig config, ExternalIndexField ... fields) throws IOException {
        ArrayList<ExternalIndexField> list = new ArrayList<ExternalIndexField>();
        for (ExternalIndexField field : fields) {
            list.add(field);
        }
        this.addExternalIndex(config, list);
    }

    @Override
    public void addExternalIndex(List<ExternalIndexField> fields) throws IOException {
        this.addExternalIndex(null, fields);
    }

    @Override
    public void addExternalIndex(ExternalIndexField ... fields) throws IOException {
        this.addExternalIndex((ExternalIndexConfig)null, fields);
    }

    @Override
    public void modifyExternalIndexAttr(ExternalIndexConfig config) throws IOException {
        this.proxy.alterExternalIndex(config);
    }

    @Override
    public void removeExternalIndex(List<String> fields) throws IOException {
        this.proxy.removeExternalIndex(fields);
    }

    @Override
    public void removeExternalIndex(String ... fields) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        for (String field : fields) {
            list.add(field);
        }
        this.removeExternalIndex(list);
    }

    @Override
    public void buildExternalIndex() throws IOException {
        this.proxy.buildExternalIndex();
    }

    @Override
    public void cancelBuildExternalIndex() throws IOException {
        this.proxy.cancelBuildExternalIndex();
    }

    @Override
    public void alterExternalIndex(String json) throws IOException {
        this.proxy.alterExternalIndex(json);
    }

    @Override
    public String describeExternalIndex() throws IOException {
        return this.proxy.describeExternalIndex();
    }

    private static class NoopExecutorService
    implements ExecutorService {
        private NoopExecutorService() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return null;
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return null;
        }

        @Override
        public Future<?> submit(Runnable task) {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        @Override
        public void execute(Runnable command) {
        }
    }

    private static class HTableBuilder
    extends TableBuilderBase {
        public HTableBuilder(TableName tableName) {
            super(tableName, new ConnectionConfiguration());
        }

        public Table build() {
            return null;
        }
    }
}

