/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.quota;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ClientQuotaContext
extends VersionedObjectWithAttributes {
    private int readCU = 0;
    private int writeCU = 0;
    private boolean isQuotaExceeded;
    private String info;
    private String callID;
    private boolean isBigScan;

    public ClientQuotaContext() {
    }

    public ClientQuotaContext(boolean isQuotaExceeded, boolean isBigScan, String info) {
        this.isQuotaExceeded = isQuotaExceeded;
        this.isBigScan = isBigScan;
        this.info = info;
    }

    public int getReadCU() {
        return this.readCU;
    }

    public int getWriteCU() {
        return this.writeCU;
    }

    public boolean isQuotaExceeded() {
        return this.isQuotaExceeded;
    }

    public boolean isNeedBackOff() {
        return this.isBigScan || this.isQuotaExceeded;
    }

    public String getInfo() {
        return this.info;
    }

    @Override
    public String toString() {
        return "callID=" + this.callID + "readCU=" + this.readCU + ", writeCU=" + this.writeCU + ", isQuotaExceeded=" + this.isQuotaExceeded + ", info=" + this.info;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.readCU);
        WritableUtils.writeVInt(out, this.writeCU);
        out.writeBoolean(this.isQuotaExceeded);
        out.writeBoolean(this.isBigScan);
        WritableUtils.writeString(out, this.info);
        WritableUtils.writeString(out, this.callID);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.readCU = WritableUtils.readVInt(in);
        this.writeCU = WritableUtils.readVInt(in);
        this.isQuotaExceeded = in.readBoolean();
        this.isBigScan = in.readBoolean();
        this.info = WritableUtils.readString(in);
        this.callID = WritableUtils.readString(in);
    }
}

