/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WByteArrayComparable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WRegexStringComparator
extends WByteArrayComparable {
    private static final Log LOG = LogFactory.getLog(WRegexStringComparator.class);
    private Charset charset = Charset.forName("UTF-8");
    private Pattern pattern;

    public WRegexStringComparator() {
    }

    public WRegexStringComparator(String expr) {
        super(EMPTYBYTES);
        this.pattern = Pattern.compile(expr, 32);
    }

    public WRegexStringComparator(String expr, Charset charset) {
        super(EMPTYBYTES);
        this.pattern = Pattern.compile(expr, 32);
        this.charset = charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        String expr = WritableUtils.readString(in);
        this.pattern = Pattern.compile(expr);
        String charset = WritableUtils.readString(in);
        if (charset.length() > 0) {
            try {
                this.charset = Charset.forName(charset);
            }
            catch (IllegalCharsetNameException e) {
                LOG.error((Object)"invalid charset", (Throwable)e);
            }
        }
    }

    public String getExpr() {
        return this.pattern.toString();
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public byte[] getValue() {
        return Bytes.toBytes(this.pattern.toString());
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.pattern.toString());
        WritableUtils.writeString(out, this.charset.name());
    }
}

