/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils.parser;

import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.parser.AbstractParser;
import com.alibaba.lindorm.client.core.utils.parser.Function;
import com.alibaba.lindorm.client.core.utils.parser.Mapper;
import com.alibaba.lindorm.client.core.utils.parser.ParseResult;
import com.alibaba.lindorm.client.core.utils.parser.Parser;
import com.alibaba.lindorm.client.core.utils.parser.Status;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LLParser
extends AbstractParser {
    public static final Parser EOF = new LLParser(new Function<String>(){

        @Override
        public ParseResult<String> apply(String input, int index) {
            if (index < input.length()) {
                return new ParseResult<String>(Status.FAILURE, index, "EOF");
            }
            return new ParseResult<Object>(Status.SUCCESS, null, index);
        }
    });
    public static final Parser WHITESPACES = LLParser.regex("\\s+");
    public static final Parser OPTIONAL_WHITESPACES = LLParser.regex("\\s*");

    public LLParser(Function function) {
        super(function);
    }

    public static Parser lazy(final Parser parser) {
        return new LLParser(new Function(){

            public ParseResult apply(String input, int index) {
                return ((LLParser)parser).action.apply(input, index);
            }
        });
    }

    public static Parser string(final String expected) {
        if (StringUtils.isNullOrEmpty(expected)) {
            throw new IllegalArgumentException("String can't be null nor empty.");
        }
        return new LLParser(new Function<String>(){

            @Override
            public ParseResult<String> apply(String input, int index) {
                int end = Math.min(input.length(), index + expected.length());
                String fetched = input.substring(index, end);
                if (expected.equals(fetched)) {
                    return new ParseResult<String>(Status.SUCCESS, fetched, end);
                }
                return new ParseResult<String>(Status.FAILURE, index, expected);
            }
        });
    }

    public static Parser regex(String patternString) {
        return LLParser.regex(patternString, 0);
    }

    public static Parser regex(final String patternString, final int group) {
        if (StringUtils.isNullOrEmpty(patternString)) {
            throw new IllegalArgumentException("Pattern can't be null nor empty.");
        }
        return new LLParser(new Function<String>(){
            Pattern pattern;
            {
                this.pattern = Pattern.compile("^(?:" + patternString + ")");
            }

            @Override
            public ParseResult<String> apply(String input, int index) {
                Matcher matcher = this.pattern.matcher(input);
                matcher.region(index, input.length());
                if (matcher.find()) {
                    String fetched = matcher.group(group);
                    return new ParseResult<String>(Status.SUCCESS, fetched, index + matcher.group(0).length());
                }
                return new ParseResult<String>(Status.FAILURE, index, "regular expression:" + patternString);
            }
        });
    }

    public static Parser sequence(final Parser ... parsers) {
        return new LLParser(new Function<List<Object>>(){

            @Override
            public ParseResult<List<Object>> apply(String input, int index) {
                ArrayList values = new ArrayList(parsers.length);
                ParseResult result = null;
                for (int i = 0; i < parsers.length; ++i) {
                    result = LLParser.merge(result, parsers[i].parse(input, index));
                    if (result.status == Status.FAILURE) {
                        return result;
                    }
                    values.add(result.value);
                    index = result.index;
                }
                return new ParseResult<List<Object>>(Status.SUCCESS, values, index);
            }
        });
    }

    private static ParseResult merge(ParseResult result, ParseResult newResult) {
        if (result == null) {
            return newResult;
        }
        if (newResult.index > result.index) {
            return newResult;
        }
        if (result.index > newResult.index) {
            return result;
        }
        LinkedHashSet<String> expected = new LinkedHashSet<String>(result.expected.size() + newResult.expected.size());
        if (newResult.index == result.index) {
            expected.addAll(result.expected);
            expected.addAll(newResult.expected);
        }
        return new ParseResult(newResult.status, newResult.value, newResult.index, new ArrayList<String>(expected));
    }

    public static Parser alternative(final Parser ... parsers) {
        return new LLParser(new Function(){

            public ParseResult apply(String input, int index) {
                ParseResult result = null;
                for (int i = 0; i < parsers.length; ++i) {
                    result = LLParser.merge(result, parsers[i].parse(input, index));
                    if (result.status != Status.SUCCESS) continue;
                    return result;
                }
                return result;
            }
        });
    }

    @Override
    public ParseResult parse(String input) {
        if (input == null) {
            throw new IllegalArgumentException("The input text is null.");
        }
        return this.skip(EOF).parse(input, 0);
    }

    @Override
    public Parser map(final Mapper mapper) {
        return new LLParser(new Function(){

            public ParseResult apply(String input, int index) {
                ParseResult result = LLParser.this.action.apply(input, index);
                if (result.status == Status.FAILURE) {
                    return result;
                }
                return new ParseResult(result.status, mapper.map(result.value), result.index);
            }
        });
    }

    @Override
    public Parser skip(Parser parser) {
        return LLParser.sequence(this, parser).map(new Mapper<List<Object>, Object>(){

            @Override
            public Object map(List<Object> values) {
                return values.get(0);
            }
        });
    }

    @Override
    public Parser then(Parser parser) {
        return LLParser.sequence(this, parser).map(new Mapper<List<Object>, Object>(){

            @Override
            public Object map(List<Object> values) {
                return values.get(1);
            }
        });
    }

    @Override
    public Parser or(Parser parser) {
        return LLParser.alternative(this, parser);
    }

    @Override
    public Parser many() {
        return new LLParser(new Function(){

            public ParseResult apply(String input, int index) {
                ArrayList values = new ArrayList();
                ParseResult result = null;
                while (index < input.length()) {
                    result = LLParser.merge(result, LLParser.this.parse(input, index));
                    if (result.status == Status.FAILURE) break;
                    if (index == result.index) {
                        throw new RuntimeException("Infinity loop.");
                    }
                    values.add(result.value);
                    index = result.index;
                }
                return new ParseResult(Status.SUCCESS, values, index);
            }
        });
    }

    @Override
    public Parser times(int num) {
        return this.times(num, num);
    }

    @Override
    public Parser times(final int min, final int max) {
        if (max < min) {
            throw new IllegalArgumentException("max can not be less than min.");
        }
        return new LLParser(new Function(){

            public ParseResult apply(String input, int index) {
                ArrayList values = new ArrayList();
                ParseResult result = null;
                for (int i = 0; i < max; ++i) {
                    result = LLParser.merge(result, LLParser.this.parse(input, index));
                    if (result.status == Status.FAILURE) {
                        if (i >= min) break;
                        return result;
                    }
                    values.add(result.value);
                    index = result.index;
                }
                return new ParseResult(Status.SUCCESS, values, index);
            }
        });
    }

    @Override
    public Parser atLeast(int num) {
        return this.times(num, Integer.MAX_VALUE);
    }

    @Override
    public Parser atMost(int num) {
        return this.times(0, num);
    }
}

