/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDate;
import com.alibaba.lindorm.client.core.types.LTime;
import com.alibaba.lindorm.client.core.types.LUnsignedLong;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.sql.Time;

public class LUnsignedTime
extends LDataType<Time> {
    public static final LUnsignedTime INSTANCE = new LUnsignedTime();

    private LUnsignedTime() {
        super(DataType.UNSIGNED_TIME, Time.class);
    }

    @Override
    public int getByteSize() {
        return 8;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return LDate.INSTANCE.isCastableTo(targetType);
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        long v = ((Time)value).getTime();
        if (v < 0L) {
            throw new IllegalDataException("Cannot set negative value for UNSIGNED_TIME type, actual value=" + v);
        }
        return LUnsignedLong.INSTANCE.toBytes(v, sortOrder);
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        Time v = (Time)LTime.INSTANCE.toObject(value, actualType);
        if (v.getTime() < 0L) {
            throw new IllegalDataException("Cannot set negative value for UNSIGNED_TIME type, actual value=" + v);
        }
        return v;
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        long v;
        try {
            v = (Long)LUnsignedLong.INSTANCE.toObject(value, offset, length, sortOrder);
        }
        catch (Throwable t) {
            throw new IllegalDataException("", t);
        }
        if (v < 0L) {
            throw new IllegalDataException("Cannot set negative value for UNSIGNED_TIME type, actual value=" + v);
        }
        return new Time(v);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_LONG_ARRAY;
    }

    @Override
    public Time randomData(DataGenerator dataGenerator) {
        return LTime.INSTANCE.randomData(dataGenerator);
    }
}

