/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LString
extends LDataType<String> {
    public static final LString INSTANCE = new LString();

    private LString() {
        super(DataType.STRING, String.class);
    }

    protected LString(DataType dataType) {
        super(dataType, LString.class);
    }

    @Override
    public int getByteSize() {
        throw new UnsupportedOperationException("Please call LDataType#estimateByteSize() for variable length data types");
    }

    @Override
    public int getByteSize(Object obj) {
        String value = (String)obj;
        return value == null ? 0 : value.length();
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = Bytes.toBytes((String)value);
        if (sortOrder == SortOrder.DESC) {
            DataTypeUtils.invert(ret, 0, ret, 0, ret.length);
        }
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        if (actualType == INSTANCE) {
            return value;
        }
        throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        if (sortOrder == SortOrder.DESC) {
            byte[] copy = new byte[length];
            DataTypeUtils.invert(value, offset, copy, 0, length);
            return Bytes.toString(copy);
        }
        return Bytes.toString(value, offset, length);
    }

    public static boolean isEmptyString(byte[] value, int offset, int length) {
        return length == 1 && SchemaUtils.isSeparatorByte(value[offset]);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_STRING_ARRAY;
    }

    @Override
    public String randomData(DataGenerator dataGenerator) {
        return StringUtils.random(dataGenerator.getRandom(), dataGenerator.getMaxLength());
    }
}

