/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice.index;

import com.alibaba.lindorm.client.core.tableservice.index.LIndexBaseDescriptor;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.schema.IndexState;
import com.alibaba.lindorm.client.schema.LindormSearchIndexDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LSearchIndexDescriptor
extends LIndexBaseDescriptor {
    private List<ColumnKey> indexedColumns = new ArrayList<ColumnKey>();

    public LSearchIndexDescriptor() {
    }

    public LSearchIndexDescriptor(String namespace, LindormSearchIndexDescriptor desc) {
        this.namespace = namespace;
        this.indexName = desc.getIndexName();
        this.dataTableName = desc.getDataTableName();
        this.indexedColumns = desc.getIndexedColumns();
        this.indexState = desc.getIndexState();
    }

    public List<ColumnKey> getIndexedColumns() {
        return this.indexedColumns;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.namespace);
        WritableUtils.writeString(out, this.indexName);
        WritableUtils.writeString(out, this.dataTableName);
        WritableUtils.writeString(out, this.indexState.name());
        WritableUtils.writeVInt(out, this.indexedColumns.size());
        for (ColumnKey indexedColumn : this.indexedColumns) {
            indexedColumn.writeTo(out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.namespace = WritableUtils.readString(in);
        this.indexName = WritableUtils.readString(in);
        this.dataTableName = WritableUtils.readString(in);
        this.indexState = IndexState.valueOf(WritableUtils.readString(in));
        int numIndexedColumns = WritableUtils.readVInt(in);
        this.indexedColumns = new ArrayList<ColumnKey>(numIndexedColumns);
        for (int i = 0; i < numIndexedColumns; ++i) {
            ColumnKey indexedColumn = new ColumnKey();
            indexedColumn.readFrom(in);
            this.indexedColumns.add(indexedColumn);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Search Index [").append(this.indexName).append("] on ").append(this.namespace).append(".").append(this.dataTableName).append("\n");
        builder.append("\tIndexed columns: [");
        for (int i = 0; i < this.indexedColumns.size(); ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            ColumnKey indexedColumn = this.indexedColumns.get(i);
            builder.append(indexedColumn);
        }
        builder.append("]");
        return builder.toString();
    }

    public LindormSearchIndexDescriptor toLindormSearchIndexDescriptor() {
        LindormSearchIndexDescriptor lsid = new LindormSearchIndexDescriptor(this.getIndexName(), this.getDataTableName());
        lsid.setIndexState(this.getIndexState());
        lsid.setIndexedColumns(new ArrayList<ColumnKey>(this.getIndexedColumns()));
        return lsid;
    }
}

