/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Attributes {
    public static String ROUTECACHEKEY = "CACHE";
    public static String SERVERBANLIST = "SERVER_BANLIST";
    public static String NEEDROUTE = "NEEDROUTE";
    public static String SINGLEIDC = "SINGLEIDC";
    public static String PRIORITYIDC = "PRIIDC";
    public static String GLITCHTIME = "GLITCH";
    public static byte[] EMPTYVALUE = LindormClientConstants.EMPTY_BYTE_ARRAY;
    protected Map<String, byte[]> attributes = new HashMap<String, byte[]>();

    public void setAttribute(String name, String value) {
        this.setAttribute(name, Bytes.toBytes(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, byte[] value) {
        Map<String, byte[]> map = this.attributes;
        synchronized (map) {
            if (value != null) {
                this.attributes.put(name, value);
            } else {
                this.attributes.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAttribute(String name) {
        Map<String, byte[]> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Map<String, byte[]> map = this.attributes;
        synchronized (map) {
            this.attributes.remove(name);
        }
    }

    public String getAttribute(String name, String defaultValue) {
        byte[] value = this.getAttribute(name);
        return value == null ? defaultValue : Bytes.toString(value);
    }

    public byte[] getAttribute(String name, byte[] defaultValue) {
        byte[] value = this.getAttribute(name);
        return value == null ? defaultValue : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttribute(String name) {
        Map<String, byte[]> map = this.attributes;
        synchronized (map) {
            return this.attributes.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, byte[]> getAttributesMap() {
        Map<String, byte[]> map = this.attributes;
        synchronized (map) {
            return Collections.unmodifiableMap(this.attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeAttributes(DataOutput out) throws IOException {
        Map<String, byte[]> map = this.attributes;
        synchronized (map) {
            if (this.attributes.isEmpty()) {
                WritableUtils.writeVInt(out, 0);
            } else {
                WritableUtils.writeVInt(out, this.attributes.size());
                for (Map.Entry<String, byte[]> attr : this.attributes.entrySet()) {
                    WritableUtils.writeString(out, attr.getKey());
                    Bytes.writeByteArray(out, attr.getValue());
                }
            }
        }
    }

    protected void readAttributes(DataInput in) throws IOException {
        int numAttributes = WritableUtils.readVInt(in);
        if (numAttributes > 0) {
            this.attributes = new HashMap<String, byte[]>(numAttributes);
            for (int i = 0; i < numAttributes; ++i) {
                String name = WritableUtils.readString(in);
                byte[] value = Bytes.readByteArray(in);
                this.attributes.put(name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String attributesToString() {
        StringBuilder ret = new StringBuilder();
        Map<String, byte[]> map = this.attributes;
        synchronized (map) {
            ret.append("[");
            for (Map.Entry<String, byte[]> entry : this.attributes.entrySet()) {
                ret.append(entry.getKey());
                ret.append(" => ");
                if (entry.getKey().equals(GLITCHTIME)) {
                    ret.append(Bytes.toInt(entry.getValue()));
                } else {
                    ret.append(Bytes.toStringBinary(entry.getValue()));
                }
                ret.append(",");
            }
            if (this.attributes.size() > 0) {
                ret.setLength(ret.length() - 1);
            }
            ret.append("]");
        }
        return ret.toString();
    }

    public boolean equalsAttributes(Attributes other) {
        return Attributes.hashCode(this.attributes) == Attributes.hashCode(other.attributes);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Attributes)) {
            return false;
        }
        return this.equalsAttributes((Attributes)obj);
    }

    public String toString() {
        return this.attributesToString();
    }

    private static int hashCode(Map<String, byte[]> map) {
        int result = 0;
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            result += entry.getKey().hashCode() ^ Arrays.hashCode(entry.getValue());
        }
        return result;
    }
}

