/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.AndExpression;
import com.alibaba.lindorm.client.core.expression.ComparisonExpression;
import com.alibaba.lindorm.client.core.expression.ExistExpression;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.InExpression;
import com.alibaba.lindorm.client.core.expression.LikeExpression;
import com.alibaba.lindorm.client.core.expression.NotExistExpression;
import com.alibaba.lindorm.client.core.expression.NotInExpression;
import com.alibaba.lindorm.client.core.expression.NotLikeExpression;
import com.alibaba.lindorm.client.core.expression.OrExpression;
import com.alibaba.lindorm.client.core.expression.RowComparisonExpression;
import com.alibaba.lindorm.client.core.utils.ReflectionUtils;
import java.util.HashMap;
import java.util.Map;

public enum ExpressionType {
    None(null),
    AndExpression(AndExpression.class),
    OrExpression(OrExpression.class),
    ComparisonExpression(ComparisonExpression.class),
    RowComparisonExpression(RowComparisonExpression.class),
    InExpression(InExpression.class),
    NotInExpression(NotInExpression.class),
    ExistExpression(ExistExpression.class),
    NotExistExpression(NotExistExpression.class),
    LikeExpression(LikeExpression.class),
    NotLikeExpression(NotLikeExpression.class);

    private final Class<? extends Expression> clazz;
    private static final Map<Class<? extends Expression>, ExpressionType> classToEnumMap;
    public static final int NONE_EXPRESSION_ORDINAL;

    private ExpressionType(Class<? extends Expression> clazz) {
        this.clazz = clazz;
    }

    public static int getOrdinal(Expression expr) {
        ExpressionType type = classToEnumMap.get(expr.getClass());
        if (type == null) {
            throw new RuntimeException("Unknown expression type " + expr.getClass());
        }
        return type.ordinal();
    }

    public static Expression fromOrdinal(int ordinal) {
        if (ordinal == NONE_EXPRESSION_ORDINAL) {
            return null;
        }
        return ReflectionUtils.newInstance(ExpressionType.values()[ordinal].clazz);
    }

    static {
        classToEnumMap = new HashMap<Class<? extends Expression>, ExpressionType>();
        for (ExpressionType type : ExpressionType.values()) {
            classToEnumMap.put(type.clazz, type);
        }
        NONE_EXPRESSION_ORDINAL = None.ordinal();
    }
}

