/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.SearchAdminService;
import com.alibaba.lindorm.client.core.AsyncDDLType;
import com.alibaba.lindorm.client.core.LindormBasicService;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.search.SearchFileType;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class LindormSearchAdminService
extends LindormBasicService
implements SearchAdminService {
    private static AtomicInteger searchAdminServiceCount = new AtomicInteger(0);
    private static final int MILLIS_IN_SECONDS = 1000;

    public LindormSearchAdminService(LindormClientConfig config) throws LindormException {
        super(config, "SearchAdminService" + searchAdminServiceCount.getAndIncrement());
    }

    public LindormSearchAdminService(LindormClientConfig config, String serviceName) throws LindormException {
        super(config, serviceName);
    }

    @Override
    public void addSearchIndexSchema(String tableName, String indexName, String elementPath) throws LindormException {
        this.addSearchIndexSchema(tableName, indexName, elementPath, null);
    }

    @Override
    public void addSearchIndexSchema(final String tableName, final String indexName, final String elementPath, final String jsonMap) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> addFieldTypeCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.addSearchIndexSchema(LindormSearchAdminService.this.namespace, tableName, indexName, elementPath, jsonMap);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(addFieldTypeCallable);
            this.blockingAndWaitForSuccess(this.getSearchIndexFullName(this.namespace, tableName, indexName), AsyncDDLType.SEARCH_INDEX_ADD_SCHEMA, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new LindormException(e);
        }
    }

    public String getSearchIndexFullName(String namespace, String dataTable, String index) {
        return namespace + "." + dataTable + "." + index;
    }

    private void blockingAndWaitForSuccess(String tableName, AsyncDDLType type, int blockTimeInSecond) throws LindormException {
        long startTime = System.currentTimeMillis();
        long blockTimeInMs = blockTimeInSecond;
        if (blockTimeInSecond != Integer.MAX_VALUE) {
            blockTimeInMs = blockTimeInSecond * 1000;
        }
        long retries = Math.max((long)this.maxRetryDDL, this.ddlPause == 0 ? 0L : blockTimeInMs / (long)this.ddlPause);
        long deadline = startTime + blockTimeInMs;
        int i = 0;
        while ((long)i < retries) {
            long remaining = deadline - System.currentTimeMillis();
            if (remaining <= 0L) {
                throw new LindormException("Timed out when waiting for table: " + tableName + " to finish operation: " + type);
            }
            try {
                long sleepTime = this.ddlPause;
                if (i > 60) {
                    sleepTime = this.ddlPause * 10;
                }
                sleepTime = sleepTime < remaining ? sleepTime : remaining;
                Thread.sleep(sleepTime);
                Pair<Integer, Integer> status = this.getOperationStatus(tableName, type);
                if (status.getFirst() == 0) {
                    return;
                }
                LOG.info((Object)("Progess of operation for : " + type + " " + tableName + ", undone idcs : " + status.getFirst() + " total idcs : " + status.getSecond()));
            }
            catch (LindormException e) {
                LOG.warn((Object)("failed to get table status for " + tableName + ", operation type: " + type + ", Retry count : " + i), (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new LindormException("Interrupt while waiting for " + tableName + " ddl operation to finish ", e);
            }
            ++i;
        }
        throw new LindormException("Retry exhausted for table operation " + tableName + " Max wait time : " + (System.currentTimeMillis() - startTime));
    }

    private Pair<Integer, Integer> getOperationStatus(final String collection, final AsyncDDLType type) throws LindormException {
        this.checkOpen();
        try {
            if (collection == null || collection.isEmpty()) {
                throw new LindormException("The name of the search index is null or emtpy.");
            }
            LServerCallable<Pair<Integer, Integer>> getOperationStatusCallable = new LServerCallable<Pair<Integer, Integer>>(OperationContext.OperationType.CHECKSTATE){

                @Override
                public Pair<Integer, Integer> call() throws Exception {
                    return this.server.getSearchIndexOperationStatus(collection, type);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(getOperationStatusCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void deleteSearchIndexSchema(final String tableName, final String indexName, final String elementPath) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> deleteFieldTypeCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.deleteSearchIndexSchema(LindormSearchAdminService.this.namespace, tableName, indexName, elementPath);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(deleteFieldTypeCallable);
            this.blockingAndWaitForSuccess(this.getSearchIndexFullName(this.namespace, tableName, indexName), AsyncDDLType.SEARCH_INDEX_DELETE_SCHEMA, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new LindormException(e);
        }
    }

    @Override
    public void modifySearchIndexSchema(final String tableName, final String indexName, final String elementPath, final String value) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> replaceFieldTypeCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.modifySearchIndexSchema(LindormSearchAdminService.this.namespace, tableName, indexName, elementPath, value);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(replaceFieldTypeCallable);
            this.blockingAndWaitForSuccess(this.getSearchIndexFullName(this.namespace, tableName, indexName), AsyncDDLType.SEARCH_INDEX_MODIFY_SCHEMA, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new LindormException(e);
        }
    }

    @Override
    public void addSearchIndexConfig(String tableName, String indexName, String elementPath) throws LindormException {
        this.addSearchIndexConfig(tableName, indexName, elementPath, null);
    }

    @Override
    public void addSearchIndexConfig(final String tableName, final String indexName, final String elementPath, final String jsonMap) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> addConfigCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.addSearchIndexConfig(LindormSearchAdminService.this.namespace, tableName, indexName, elementPath, jsonMap);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(addConfigCallable);
            this.blockingAndWaitForSuccess(this.getSearchIndexFullName(this.namespace, tableName, indexName), AsyncDDLType.SEARCH_INDEX_ADD_CONFIG, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new LindormException(e);
        }
    }

    @Override
    public void deleteSearchIndexConfig(final String tableName, final String indexName, final String elementPath) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> deleteConfigCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.deleteSearchIndexConfig(LindormSearchAdminService.this.namespace, tableName, indexName, elementPath);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(deleteConfigCallable);
            this.blockingAndWaitForSuccess(this.getSearchIndexFullName(this.namespace, tableName, indexName), AsyncDDLType.SEARCH_INDEX_DELETE_CONFIG, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new LindormException(e);
        }
    }

    @Override
    public void modifySearchIndexConfig(final String tableName, final String indexName, final String elementPath, final String value) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> modifyConfigCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.modifySearchIndexConfig(LindormSearchAdminService.this.namespace, tableName, indexName, elementPath, value);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(modifyConfigCallable);
            this.blockingAndWaitForSuccess(this.getSearchIndexFullName(this.namespace, tableName, indexName), AsyncDDLType.SEARCH_INDEX_MODIFY_CONFIG, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new LindormException(e);
        }
    }

    @Override
    public void reloadSearchIndex(final String tableName, final String indexName) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> reloadSearchIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.RELOAD){

                @Override
                public Void call() throws Exception {
                    this.server.reloadSearchIndex(LindormSearchAdminService.this.namespace, tableName, indexName);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(reloadSearchIndexCallable);
            this.blockingAndWaitForSuccess(this.getSearchIndexFullName(this.namespace, tableName, indexName), AsyncDDLType.SEARCH_INDEX_RELOAD, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new LindormException(e);
        }
    }

    @Override
    public String describeSearchIndexSchema(final String tableName, final String indexName, final SearchFileType type) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<String> callable = new LServerCallable<String>(OperationContext.OperationType.DESCRIBE){

                @Override
                public String call() throws Exception {
                    return this.server.describeSearchIndexSchema(LindormSearchAdminService.this.namespace, tableName, indexName, type);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (IOException e) {
            throw new LindormException(e);
        }
    }

    @Override
    public String describeSearchIndexConfig(final String tableName, final String indexName, final SearchFileType type) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<String> callable = new LServerCallable<String>(OperationContext.OperationType.DESCRIBE){

                @Override
                public String call() throws Exception {
                    return this.server.describeSearchIndexConfig(LindormSearchAdminService.this.namespace, tableName, indexName, type);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (IOException e) {
            throw new LindormException(e);
        }
    }
}

