/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient.dualservice;

import com.alibaba.hbase.haclient.dualservice.AutoSwitch;
import com.alibaba.hbase.haclient.dualservice.DualCallable;
import com.alibaba.hbase.haclient.dualservice.DualContext;
import com.alibaba.hbase.haclient.dualservice.DualMetrics;
import com.alibaba.hbase.haclient.dualservice.DualScannerCallable;
import com.alibaba.hbase.haclient.dualservice.DualScannerResult;
import com.alibaba.hbase.haclient.dualservice.DualTrace;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.util.Threads;

public class DualExecutor {
    private static final Log LOG = LogFactory.getLog(DualExecutor.class);
    private Configuration conf;
    private ThreadPoolExecutor dualActiveThreadPool = null;
    private ThreadPoolExecutor dualStandbyThreadPool = null;
    private int activeDualThreads;
    private int standbyDualThreads;
    private int activeQueueSize;
    private int standbyQueueSize;
    private float queueRate = 0.6f;
    private boolean traceEnable;
    private AutoSwitch autoSwitch;

    public DualExecutor(Configuration conf, AutoSwitch autoSwitch) {
        this.conf = conf;
        this.activeDualThreads = conf.getInt("hbase.dualservice.active.executor.thread", 100);
        this.activeQueueSize = conf.getInt("hbase.dualservice.active.executor.queue", 256);
        this.standbyDualThreads = conf.getInt("hbase.dualservice.standby.executor.thread", 10);
        this.standbyQueueSize = conf.getInt("hbase.dualservice.standby.executor.queue", 256);
        this.dualActiveThreadPool = new ThreadPoolExecutor(this.activeDualThreads, this.activeDualThreads, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.activeQueueSize), Threads.newDaemonThreadFactory((String)"DualService-Active-Executor"), new ThreadPoolExecutor.AbortPolicy());
        this.dualStandbyThreadPool = new ThreadPoolExecutor(this.standbyDualThreads, this.standbyDualThreads, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.standbyQueueSize), Threads.newDaemonThreadFactory((String)"DualService-Standby-Executor"), new ThreadPoolExecutor.AbortPolicy());
        this.traceEnable = conf.getBoolean("hbase.dualservice.trace.enable", true);
        this.autoSwitch = autoSwitch;
    }

    public static String createTableConfKey(String tableName, String confKey) {
        return tableName + "." + confKey;
    }

    private <T> DualContext<T> generateDualContext(HTable activeTable, byte[] tableName, int glitchTimeout, int operationTimeout, ActionType actionType, byte[] row) {
        DualContext dualContext = null;
        if (this.autoSwitch.isAutoSwitchEnable() && this.autoSwitch.needKeyInfo()) {
            HRegionLocation location = null;
            try {
                location = activeTable.getRegionLocator().getRegionLocation(row);
            }
            catch (IOException e) {
                this.autoSwitch.setLocateAvaliable(false);
                return new DualContext(tableName, glitchTimeout, operationTimeout, new byte[0], null, null);
            }
            byte[] key = null;
            key = location != null ? location.getRegionInfo().getStartKey() : new byte[]{};
            dualContext = new DualContext(tableName, glitchTimeout, operationTimeout, key, location, actionType);
        } else {
            dualContext = new DualContext(tableName, glitchTimeout, operationTimeout);
        }
        return dualContext;
    }

    public Result dualGet(HTable activeTable, HTable standbyTable, byte[] tableName, Get get2, int glitchTimeout, int operationTimeout) throws IOException {
        DualContext dualContext = this.generateDualContext(activeTable, tableName, glitchTimeout, operationTimeout, ActionType.GET, get2.getRow());
        AutoSwitch.ExecuteStrategy strategy = this.autoSwitch.getExecuteStrategy(dualContext);
        dualContext.setExecuteStrategy(strategy);
        DualCallable activeCallable = new DualCallable(dualContext, activeTable, get2, ActionType.GET, Role.ACTIVE);
        DualCallable standbyCallable = new DualCallable(dualContext, standbyTable, get2, ActionType.GET, Role.STANDBY);
        DualMetrics getMetrics = null;
        if (this.traceEnable) {
            getMetrics = DualTrace.getInstance().getMetrics(DualTrace.GET);
        }
        return (Result)this.doDualOperation(activeCallable, standbyCallable, dualContext, getMetrics);
    }

    public Void dualPut(HTable activeTable, HTable standbyTable, byte[] tableName, Put put2, int glitchTimeout, int operationTimeout) throws IOException {
        DualContext dualContext = this.generateDualContext(activeTable, tableName, glitchTimeout, operationTimeout, ActionType.PUT, put2.getRow());
        AutoSwitch.ExecuteStrategy strategy = this.autoSwitch.getExecuteStrategy(dualContext);
        dualContext.setExecuteStrategy(strategy);
        DualCallable activeCallable = new DualCallable(dualContext, activeTable, put2, ActionType.PUT, Role.ACTIVE);
        DualCallable standbyCallable = new DualCallable(dualContext, standbyTable, put2, ActionType.PUT, Role.STANDBY);
        DualMetrics putMetrics = null;
        if (this.traceEnable) {
            putMetrics = DualTrace.getInstance().getMetrics(DualTrace.PUT);
        }
        return (Void)this.doDualOperation(activeCallable, standbyCallable, dualContext, putMetrics);
    }

    public Void dualDelete(HTable activeTable, HTable standbyTable, byte[] tableName, Delete delete, int glitchTimeout, int operationTimeout) throws IOException {
        DualContext dualContext = this.generateDualContext(activeTable, tableName, glitchTimeout, operationTimeout, ActionType.DELETE, delete.getRow());
        AutoSwitch.ExecuteStrategy strategy = this.autoSwitch.getExecuteStrategy(dualContext);
        dualContext.setExecuteStrategy(strategy);
        DualCallable activeCallable = new DualCallable(dualContext, activeTable, delete, ActionType.DELETE, Role.ACTIVE);
        DualCallable standbyCallable = new DualCallable(dualContext, standbyTable, delete, ActionType.DELETE, Role.STANDBY);
        DualMetrics deleteMetrics = null;
        if (this.traceEnable) {
            deleteMetrics = DualTrace.getInstance().getMetrics(DualTrace.DELETE);
        }
        return (Void)this.doDualOperation(activeCallable, standbyCallable, dualContext, deleteMetrics);
    }

    public Result[] dualBatchGet(HTable activeTable, HTable standbyTable, byte[] tableName, List<Get> gets, int glitchTimeout, int operationTimeout) throws IOException {
        DualContext dualContext = new DualContext(tableName, glitchTimeout, operationTimeout);
        AutoSwitch.ExecuteStrategy strategy = this.autoSwitch.getExecuteStrategy(dualContext);
        dualContext.setExecuteStrategy(strategy);
        DualCallable activeCallable = new DualCallable(dualContext, activeTable, gets, ActionType.BATCHGET, Role.ACTIVE);
        DualCallable standbyCallable = new DualCallable(dualContext, standbyTable, gets, ActionType.BATCHGET, Role.STANDBY);
        DualMetrics batchGetMetrics = null;
        if (this.traceEnable) {
            batchGetMetrics = DualTrace.getInstance().getMetrics(DualTrace.BATCHGET);
        }
        return (Result[])this.doDualOperation(activeCallable, standbyCallable, dualContext, batchGetMetrics);
    }

    public Void dualBatchPut(HTable activeTable, HTable standbyTable, byte[] tableName, List<Put> puts, int glitchTimeout, int operationTimeout) throws IOException {
        DualContext dualContext = new DualContext(tableName, glitchTimeout, operationTimeout);
        AutoSwitch.ExecuteStrategy strategy = this.autoSwitch.getExecuteStrategy(dualContext);
        dualContext.setExecuteStrategy(strategy);
        DualCallable activeCallable = new DualCallable(dualContext, activeTable, puts, ActionType.BATCHPUT, Role.ACTIVE);
        DualCallable standbyCallable = new DualCallable(dualContext, standbyTable, puts, ActionType.BATCHPUT, Role.STANDBY);
        DualMetrics batchPutMetrics = null;
        if (this.traceEnable) {
            batchPutMetrics = DualTrace.getInstance().getMetrics(DualTrace.BATCHPUT);
        }
        return (Void)this.doDualOperation(activeCallable, standbyCallable, dualContext, batchPutMetrics);
    }

    public Void dualBatchDelete(HTable activeTable, HTable standbyTable, byte[] tableName, List<Delete> deletes, int glitchTimeout, int operationTimeout) throws IOException {
        DualContext dualContext = new DualContext(tableName, glitchTimeout, operationTimeout);
        AutoSwitch.ExecuteStrategy strategy = this.autoSwitch.getExecuteStrategy(dualContext);
        dualContext.setExecuteStrategy(strategy);
        DualCallable activeCallable = new DualCallable(dualContext, activeTable, deletes, ActionType.BATCHDELETE, Role.ACTIVE);
        DualCallable standbyCallable = new DualCallable(dualContext, standbyTable, deletes, ActionType.BATCHDELETE, Role.STANDBY);
        DualMetrics batchDeleteMetrics = null;
        if (this.traceEnable) {
            batchDeleteMetrics = DualTrace.getInstance().getMetrics(DualTrace.BATCHDELETE);
        }
        return (Void)this.doDualOperation(activeCallable, standbyCallable, dualContext, batchDeleteMetrics);
    }

    public DualScannerResult dualNext(ResultScanner activeScanner, ResultScanner standbyScanner, byte[] tableName, int glitchTimeout, int operationTimeout) throws IOException {
        DualContext dualContext = new DualContext(tableName, glitchTimeout, operationTimeout);
        AutoSwitch.ExecuteStrategy strategy = this.autoSwitch.getExecuteStrategy(dualContext);
        dualContext.setExecuteStrategy(strategy);
        DualScannerCallable activeCallable = new DualScannerCallable(dualContext, activeScanner, Role.ACTIVE);
        DualScannerCallable standbyCallable = new DualScannerCallable(dualContext, standbyScanner, Role.STANDBY);
        DualMetrics scanMetrics = null;
        if (this.traceEnable) {
            scanMetrics = DualTrace.getInstance().getMetrics(DualTrace.SCAN);
        }
        return (DualScannerResult)this.doDualOperation(activeCallable, standbyCallable, dualContext, scanMetrics);
    }

    private <T> T doDualOperation(Callable<T> activeCallable, Callable<T> standbyCallable, DualContext<T> dualContext, DualMetrics metrics) throws IOException {
        Future<T> activeFuture = null;
        Future<T> standbyFuture = null;
        AutoSwitch.ExecuteStrategy executeStrategy = dualContext.getExecuteStrategy();
        if (this.dualActiveThreadPool != null && (float)this.dualActiveThreadPool.getQueue().size() < this.queueRate * (float)this.activeQueueSize || this.dualStandbyThreadPool != null && (float)this.dualStandbyThreadPool.getQueue().size() < this.queueRate * (float)this.standbyQueueSize) {
            dualContext.start();
            T result = null;
            if (executeStrategy == AutoSwitch.ExecuteStrategy.DEFAULT) {
                try {
                    activeFuture = this.dualActiveThreadPool.submit(activeCallable);
                    result = dualContext.getResultInGlitchTimeout();
                }
                catch (Throwable t) {
                    dualContext.onActiveError(t);
                }
                if (dualContext.usePrimaryAsResult().booleanValue()) {
                    this.autoSwitch.update(dualContext);
                    if (result == null) {
                        result = dualContext.getActiveResult();
                    }
                    if (result == null) {
                        LOG.debug((Object)("result is null , context is " + dualContext.toString()));
                    }
                    T t = result;
                    return t;
                }
            } else {
                try {
                    standbyFuture = this.dualStandbyThreadPool.submit(standbyCallable);
                    result = dualContext.getResultInGlitchTimeout();
                }
                catch (Throwable t) {
                    dualContext.onStandbyError(t);
                }
                if (dualContext.useStandbyAsResult()) {
                    this.autoSwitch.update(dualContext);
                    if (result == null) {
                        result = dualContext.getStandbyResult();
                    }
                    if (result == null) {
                        LOG.debug((Object)("result is null , context is " + dualContext.toString()));
                    }
                    T t = result;
                    return t;
                }
            }
            boolean dualsubmit = false;
            if (executeStrategy == AutoSwitch.ExecuteStrategy.DEFAULT) {
                try {
                    standbyFuture = this.dualStandbyThreadPool.submit(standbyCallable);
                    dualsubmit = true;
                }
                catch (Throwable t) {
                    dualContext.onStandbyError(t);
                }
            } else {
                try {
                    activeFuture = this.dualActiveThreadPool.submit(activeCallable);
                    dualsubmit = true;
                }
                catch (Throwable t) {
                    dualContext.onActiveError(t);
                }
            }
            if (this.traceEnable && dualsubmit) {
                metrics.addDualExecuteHistogram();
            }
            dualContext.waitOperationTimeout();
            if (this.traceEnable && dualContext.useStandbyAsResult()) {
                metrics.addDualRealHistogram(System.currentTimeMillis() - dualContext.getStart());
            }
            this.autoSwitch.update(dualContext);
            T t = dualContext.getResult();
            return t;
        }
        if (executeStrategy == AutoSwitch.ExecuteStrategy.DEFAULT) {
            T result;
            LOG.debug((Object)"dual active and standby thread pool is full, disable dual service use active call");
            try {
                result = activeCallable.call();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return result;
        }
        LOG.debug((Object)"dual active and standby thread pool is full, disable dual service use standby call");
        try {
            T e = standbyCallable.call();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return e;
        finally {
            if (activeFuture != null && !activeFuture.isDone()) {
                activeFuture.cancel(true);
            }
            if (standbyFuture != null && !standbyFuture.isDone()) {
                standbyFuture.cancel(true);
            }
        }
    }

    public void close() {
        if (this.dualActiveThreadPool != null) {
            this.dualActiveThreadPool.shutdown();
        }
    }

    public static enum Role {
        ACTIVE,
        STANDBY;

    }

    public static enum ActionType {
        GET,
        PUT,
        DELETE,
        BATCHGET,
        BATCHPUT,
        BATCHDELETE;

    }
}

