/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient.dualservice;

import com.alibaba.hbase.haclient.dualservice.AutoSwitch;
import com.alibaba.hbase.haclient.dualservice.DualExecutor;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.util.Bytes;

public class DualContext<T> {
    private static final Log LOG = LogFactory.getLog(DualContext.class);
    private volatile T activeResult;
    private volatile T standbyResult;
    private Throwable activeError;
    private Throwable standbyError;
    private CountDownLatch countDown = new CountDownLatch(1);
    private final int glitchTimeout;
    private final int operationTimeout;
    private byte[] tableName;
    private long start;
    private volatile boolean hasValue = false;
    private Boolean usePrimaryAsResult = null;
    private byte[] key;
    private HRegionLocation location;
    private DualExecutor.ActionType actionType;
    private AutoSwitch.ExecuteStrategy executeStrategy = AutoSwitch.ExecuteStrategy.DEFAULT;
    private volatile boolean activeReturn = false;
    private volatile boolean standbyReturn = false;

    public DualContext(byte[] tableName, int glitchTimeout, int operationTimeout) {
        this.glitchTimeout = glitchTimeout;
        this.operationTimeout = operationTimeout;
        this.tableName = tableName;
    }

    public DualContext(byte[] tableName, int glitchTimeout, int operationTimeout, byte[] key, HRegionLocation location, DualExecutor.ActionType actionType) {
        this.glitchTimeout = glitchTimeout;
        this.operationTimeout = operationTimeout;
        this.tableName = tableName;
        this.key = key;
        this.location = location;
        this.actionType = actionType;
    }

    public void onActiveComplete(T result) {
        this.activeResult = result;
        this.hasValue = true;
        this.activeReturn = true;
        this.countDown.countDown();
    }

    public void onStandbyComplete(T result) {
        this.standbyResult = result;
        this.hasValue = true;
        this.standbyReturn = true;
        this.countDown.countDown();
    }

    public T getActiveResult() {
        return this.activeResult;
    }

    public T getStandbyResult() {
        return this.standbyResult;
    }

    public synchronized void onActiveError(Throwable error) {
        this.activeError = error;
        if (this.standbyError != null) {
            this.countDown.countDown();
        }
    }

    public synchronized void onStandbyError(Throwable error) {
        this.standbyError = error;
        if (this.activeError != null) {
            this.countDown.countDown();
        }
    }

    public T getResult() throws IOException {
        if (this.hasValue) {
            if (this.activeResult != null) {
                this.usePrimaryAsResult = true;
                return this.activeResult;
            }
            if (this.standbyResult != null) {
                this.usePrimaryAsResult = false;
                return this.standbyResult;
            }
            return null;
        }
        if (this.activeError == null) {
            this.activeError = new CallTimeoutException("OperationTimeout");
        }
        if (this.standbyError == null) {
            this.standbyError = new CallTimeoutException("OperationTimeout");
        }
        long now = System.currentTimeMillis();
        String msg = "Failed exectuing dual operation for table " + Bytes.toString((byte[])this.tableName) + " with active error=" + this.activeError.getMessage() + " and with standby error=" + this.standbyError.getMessage() + ", timeout=" + this.operationTimeout + ", wait=" + (now - this.start);
        throw new IOException(msg, this.activeError);
    }

    public T getResultInGlitchTimeout() throws IOException {
        try {
            if (this.countDown.await(this.glitchTimeout, TimeUnit.MILLISECONDS)) {
                if (this.hasValue && this.activeReturn) {
                    this.usePrimaryAsResult = true;
                    return this.activeResult;
                }
                if (this.hasValue && this.standbyReturn) {
                    return this.standbyResult;
                }
                LOG.debug((Object)"get result in glitch timeout, return null");
                return null;
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return null;
    }

    public void waitOperationTimeout() throws IOException {
        try {
            long remaining = 0L;
            remaining = Math.max(0L, (long)this.operationTimeout + this.start - System.currentTimeMillis());
            this.countDown.await(remaining += 10L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public byte[] getTableName() {
        return this.tableName;
    }

    public Boolean usePrimaryAsResult() {
        return this.hasValue && this.activeReturn;
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public long getStart() {
        return this.start;
    }

    public boolean useStandbyAsResult() {
        return this.hasValue && !this.activeReturn;
    }

    public boolean activeHasError() {
        return this.activeError != null;
    }

    public boolean standbyHasError() {
        return this.standbyError != null;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public HRegionLocation getLocation() {
        return this.location;
    }

    public void setLocations(HRegionLocation location) {
        this.location = location;
    }

    public DualExecutor.ActionType getActionType() {
        return this.actionType;
    }

    public AutoSwitch.ExecuteStrategy getExecuteStrategy() {
        return this.executeStrategy;
    }

    public void setExecuteStrategy(AutoSwitch.ExecuteStrategy executeStrategy) {
        this.executeStrategy = executeStrategy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("activeReturn : " + this.activeReturn);
        sb.append(", standbyReturn : " + this.standbyReturn);
        sb.append(", hasValue : " + this.hasValue);
        sb.append(", usePrimaryAsResult : " + this.usePrimaryAsResult);
        if (this.activeResult != null) {
            sb.append(", activeResult not null ");
        }
        if (this.standbyResult != null) {
            sb.append(", standbyResult not null ");
        }
        return sb.toString();
    }
}

