/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseAPIProxy;
import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.client.AliHBaseDirectImplFactory;
import com.alibaba.hbase.client.AliHBaseThriftImplFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;

public abstract class AliHBaseImplFactory {
    public abstract AliHBaseAPIProxy getHBaseAPIProxyImpl(TableName var1) throws IOException;

    public abstract void close() throws IOException;

    public abstract Configuration getConf();

    void setCULimit(int cuLimit) {
    }

    public static AliHBaseImplFactory create(Configuration conf) throws IOException {
        Class<?> clazz;
        String host;
        boolean useThrift = false;
        if (conf.get("hbase.client.endpoint") == null || AliHBaseConstants.isHBaseUEConnectionString(conf, conf.get("hbase.zookeeper.quorum"))) {
            conf.set("hbase.client.endpoint", conf.get("hbase.zookeeper.quorum"));
        }
        if ((host = conf.get("hbase.client.endpoint").trim()).startsWith("http://") || host.startsWith("https://")) {
            useThrift = true;
        }
        if (conf.get("hbase.client.use.thrift") != null) {
            useThrift = conf.getBoolean("hbase.client.use.thrift", false);
        }
        String factoryImplClassName = conf.get("hbase.hbaseue.factory.impl");
        if (useThrift) {
            return new AliHBaseThriftImplFactory(conf);
        }
        if (factoryImplClassName == null || factoryImplClassName.isEmpty()) {
            return new AliHBaseDirectImplFactory(conf);
        }
        try {
            clazz = Class.forName(factoryImplClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Configuration.class);
            constructor.setAccessible(true);
            return (AliHBaseImplFactory)constructor.newInstance(conf);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

