/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.spring.boot.autoconfigure;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceProperties;
import java.sql.SQLException;
import org.springframework.core.env.Environment;

public class DruidDataSourceBuilder {
    public static DruidDataSourceBuilder create() {
        return new DruidDataSourceBuilder();
    }

    @Deprecated
    public DruidDataSource build() {
        return new DruidDataSource();
    }

    public DruidDataSource build(Environment env, String prefix) {
        DruidDataSourceProperties properties = new DruidDataSourceProperties();
        properties.setUrl(env.getProperty(prefix + "url"));
        properties.setUsername(env.getProperty(prefix + "username"));
        properties.setPassword(env.getProperty(prefix + "password"));
        properties.setDriverClassName(env.getProperty(prefix + "driver-class-name"));
        properties.setInitialSize((Integer)env.getProperty(prefix + "initial-size", Integer.class));
        properties.setMaxActive((Integer)env.getProperty(prefix + "max-active", Integer.class));
        properties.setMinIdle((Integer)env.getProperty(prefix + "min-idle", Integer.class));
        properties.setMaxWait((Long)env.getProperty(prefix + "max-wait", Long.class));
        properties.setPoolPreparedStatements((Boolean)env.getProperty(prefix + "pool-prepared-statements", Boolean.class));
        properties.setMaxOpenPreparedStatements((Integer)env.getProperty(prefix + "max-open-prepared-statements", Integer.class));
        properties.setMaxPoolPreparedStatementPerConnectionSize((Integer)env.getProperty(prefix + "max-pool-prepared-statement-per-connection-size", Integer.class));
        properties.setValidationQuery(env.getProperty(prefix + "validation-query"));
        properties.setValidationQueryTimeout((Integer)env.getProperty(prefix + "validation-query-timeout", Integer.class));
        properties.setTestOnBorrow((Boolean)env.getProperty(prefix + "test-on-borrow", Boolean.class));
        properties.setTestOnReturn((Boolean)env.getProperty(prefix + "test-on-return", Boolean.class));
        properties.setTestWhileIdle((Boolean)env.getProperty(prefix + "test-while-idle", Boolean.class));
        properties.setTimeBetweenEvictionRunsMillis((Long)env.getProperty(prefix + "time-between-eviction-runs-millis", Long.class));
        properties.setMinEvictableIdleTimeMillis((Long)env.getProperty(prefix + "min-evictable-idle-time-millis", Long.class));
        properties.setMaxEvictableIdleTimeMillis((Long)env.getProperty(prefix + "max-evictable-idle-time-millis", Long.class));
        properties.setFilters(env.getProperty(prefix + "filters"));
        return this.build(properties);
    }

    DruidDataSource build(DruidDataSourceProperties properties) {
        DruidDataSource dataSource = new DruidDataSource();
        if (properties.getUrl() != null) {
            dataSource.setUrl(properties.getUrl());
        }
        if (properties.getUsername() != null) {
            dataSource.setUsername(properties.getUsername());
        }
        if (properties.getPassword() != null) {
            dataSource.setPassword(properties.getPassword());
        }
        if (properties.getDriverClassName() != null) {
            dataSource.setDriverClassName(properties.getDriverClassName());
        }
        if (properties.getInitialSize() != null) {
            dataSource.setInitialSize(properties.getInitialSize().intValue());
        }
        if (properties.getMaxActive() != null) {
            dataSource.setMaxActive(properties.getMaxActive().intValue());
        }
        if (properties.getMinIdle() != null) {
            dataSource.setMinIdle(properties.getMinIdle().intValue());
        }
        if (properties.getMaxWait() != null) {
            dataSource.setMaxWait(properties.getMaxWait().longValue());
        }
        if (properties.getPoolPreparedStatements() != null) {
            dataSource.setPoolPreparedStatements(properties.getPoolPreparedStatements().booleanValue());
        }
        if (properties.getMaxOpenPreparedStatements() != null) {
            dataSource.setMaxOpenPreparedStatements(properties.getMaxOpenPreparedStatements().intValue());
        }
        if (properties.getMaxPoolPreparedStatementPerConnectionSize() != null) {
            dataSource.setMaxPoolPreparedStatementPerConnectionSize(properties.getMaxPoolPreparedStatementPerConnectionSize().intValue());
        }
        if (properties.getValidationQuery() != null) {
            dataSource.setValidationQuery(properties.getValidationQuery());
        }
        if (properties.getValidationQueryTimeout() != null) {
            dataSource.setValidationQueryTimeout(properties.getValidationQueryTimeout().intValue());
        }
        if (properties.getTestWhileIdle() != null) {
            dataSource.setTestWhileIdle(properties.getTestWhileIdle().booleanValue());
        }
        if (properties.getTestOnBorrow() != null) {
            dataSource.setTestOnBorrow(properties.getTestOnBorrow().booleanValue());
        }
        if (properties.getTestOnReturn() != null) {
            dataSource.setTestOnReturn(properties.getTestOnReturn().booleanValue());
        }
        if (properties.getTimeBetweenEvictionRunsMillis() != null) {
            dataSource.setTimeBetweenEvictionRunsMillis(properties.getTimeBetweenEvictionRunsMillis().longValue());
        }
        if (properties.getMinEvictableIdleTimeMillis() != null) {
            dataSource.setMinEvictableIdleTimeMillis(properties.getMinEvictableIdleTimeMillis().longValue());
        }
        if (properties.getMaxEvictableIdleTimeMillis() != null) {
            dataSource.setMaxEvictableIdleTimeMillis(properties.getMaxEvictableIdleTimeMillis().longValue());
        }
        try {
            if (properties.getFilters() != null) {
                dataSource.setFilters(properties.getFilters());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dataSource;
    }
}

