package com.alibaba.ans.core;

import com.taobao.vipserver.client.core.Host;
import com.taobao.vipserver.client.core.HostListener;
import com.taobao.vipserver.client.core.VIPClient;
import com.taobao.vipserver.client.ipms.NodeReactor;
import com.taobao.vipserver.client.utils.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;

/*
* @program ans-client
* @decription
* @author jianwei.wjw
* @create 2018-05-24 02:52:57
*/
public class NamingService {
    /**
     * 以轮询(RR)的方式返回域名的一个有效（不包括健康但权重为0）Host
     * 返回结果受权重大小影响。
     * <strong>注意</strong>：所有的错误将会以异常的形式给出
     *
     * @param dom 域名字符串，如"www.taobao.com"
     * @return 一个Host对象，若想将 Host 转换成为 ip:port 的形式，可以使用 host#inetAddr()
     * @throws java.lang.Exception 找不到Host或者出现错误
     */
    public static Host srvHost(String dom) throws Exception {
        return VIPClient.srvHostWithTimeout(dom, -1L);
    }

    /**
     * 以轮询（RR）的方式返回域名对应clusters中的一个有效（不包括健康但权重为0）Host。
     * 返回结果受权重大小影响。
     * <strong>注意</strong>：所有的错误将会以异常的形式给出
     *
     * @param dom      域名字符串，如"www.taobao.com"
     * @param clusters 指定的虚拟集群名称，可以是多个用英文逗号隔开，如 “http,tcp“
     * @return 一个 Host 对象，若想将 Host 转换成为 ip:port 的形式，可以使用 host#inetAddr()
     * @throws java.lang.Exception 找不到Host或者出现错误
     */
    public static Host srvHost(String dom, String clusters) throws Exception {
        return VIPClient.srvHostWithTimeout(dom, clusters, -1L);
    }

    /**
     * 返回域名所有有效（不包括健康但权重为0）Host列表。
     * <strong>注意</strong>：
     * <ul>
     * <li>所有的错误将会以异常的形式给出</li>
     * <li>这个接口会按weight对Host进行复制及过滤，weight如有小数则采用进一法归为自然数。</li>
     * </ul>
     *
     * @param dom 域名字符串，如"www.taobao.com"
     * @return 一个 Host 对象列表，若想将 Host 转换成为 ip:port 的形式，可以使用 host#inetAddr()
     * @throws java.lang.Exception 操作失败
     */
    public static List<Host> srvHosts(String dom) throws Exception {
        return VIPClient.srvHostsWithTimeout(dom, -1);
    }

    /**
     * 返回域名指定clusters内的所有有效（不包括健康但权重为0）Host列表。
     * <strong>注意</strong>：
     * 所有的错误将会以异常的形式给出
     * 这个接口会按weight对Host进行复制及过滤，weight如有小数则采用进一法归为自然数。
     *
     * @param dom      域名字符串，如"www.taobao.com"
     * @param clusters 指定的虚拟集群名称，可以是多个用英文逗号隔开，如 “http,tcp“
     * @return 一个 Host 对象列表，若想将 Host 转换成为 ip:port 的形式，可以使用 host#inetAddr()
     * @throws java.lang.Exception 操作失败
     */
    public static List<Host> srvHosts(String dom, String clusters) throws Exception {
        return VIPClient.srvHostsWithTimeout(dom, clusters, -1L);
    }


    /**
     * 返回域名符合对应userId单元的所有有效（不包括健康但权重为0）Host列表。<p>
     * <strong>注意</strong>：
     * 所有的错误将会以异常的形式给出
     * 这个接口不会按weight对Host进行复制及过滤，权重为0的也会返回，即服务端的原始数据
     *
     * @param dom 域名字符串，如"www.taobao.com"
     * @return 一个 Host 对象列表，若想将 Host 转换成为 ip:port 的形式，可以使用 host#inetAddr()
     * @throws java.lang.Exception 操作失败
     */
    public static List<Host> getHosts(String dom) throws Exception {
        return VIPClient.getHosts(dom);
    }




    public static List<Host> getHosts(String dom, String clusters) throws Exception {
        return VIPClient.getHostsWithTimeout(dom, clusters, -1L);
    }

    /**
     * 监听一个域名Host变更，当Host变生变更时通知，并传入新的Host原生列表（未进行过滤操作，例如不会按权重将Host展开）
     *
     * @param dom      域名字符串，如"www.taobao.com"
     * @param listener 回调监听器
     */
    public static void listen(String dom, HostListener listener) {
        VIPClient.listen(dom, StringUtils.EMPTY, listener);
    }



    /**
     * 监听一个域名中所指定虚拟分组的Host变更，当Host变生变更时通知，并传入新的IP原生列表（未进行过滤操作，例如不会按权重将Host展开）
     *
     * @param dom      域名字符串，如"www.taobao.com"
     * @param clusters 虚拟集群列表，可以是多个，请使用英文逗号隔开，如：DEFAULT,TCP
     * @param listener 回调监听器
     */
    public static void listen(String dom, String clusters, HostListener listener) {
        VIPClient.listen(dom, clusters, listener);
    }

    public static void unlisten(String dom, HostListener listener) {
        VIPClient.unlisten(dom, listener);
    }


    /**
     * <p>向ANS服务端注册服务，并且定时向服务端发送健康检查心跳。
     *
     * @param serviceName     ANS服务名
     * @param ip      需要添加的IP，一般是本机IP
     * @param port    提供服务的端口
     * @param weight  本IP的权重
     * @param cluster 需要向哪个集群添加IP，如果没有自己配置特殊的集群，该字段可以为DEFAULT
     * @throws Exception 操作失败
     */
    public static void regDom(String serviceName, String ip, int port, float weight, String cluster) throws Exception {
        VIPClient.regDom(serviceName, ip, port, weight, cluster, new ArrayList<NodeReactor.Tag>());
    }

    /**
     * <p>向ANS服务端注册服务，并且定时向服务端发送健康检查心跳。</p>
     * @param serviceName ANS服务名
     * @param ip  需要添加的IP，一般是本机IP
     * @param port  提供服务的端口
     * @param weight 本IP的权重
     * @param cluster  需要向哪个集群添加IP，如果没有自己配置特殊的集群，该字段可以为DEFAULT
     * @param tags  该IP的标签
     * @throws Exception 操作失败
     */
    public static void regDom(String serviceName, String ip, int port, float weight, String cluster, List<NodeReactor.Tag> tags) throws Exception {
        VIPClient.regDom(serviceName, ip, port, weight, cluster, tags);
    }

    /**
     * 注销IP
     *
     * @param serviceNames 服务名列表
     * @param ip 服务ip
     * @param port 服务端口
     * @param cluster 该IP所属集群
     * @throws Exception 失败抛异常
     */
    public static void deRegDom(String serviceNames, String ip, int port, String cluster) throws Exception {
        VIPClient.deRegDom(serviceNames, ip, port, cluster);
    }

    /**
     * 获取已发布的服务名
     *
     * @return 已发布的服务名
     */
    public static Set<String> getPublishes() {
        return VIPClient.getPublishes();
    }

    /**
     * 获取订阅的服务名
     *
     * @return 订阅的服务名
     */
    public static Set<String> getDomsSubscribed() {
        return VIPClient.getDomsSubscribed();
    }

    public static void setListenerExecutor(ExecutorService executor) {
        VIPClient.setListenerExecutor(executor);
    }
}
