/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.instruction.op;

import com.ql.util.express.ArraySwap;
import com.ql.util.express.ExpressUtil;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.OperateData;
import com.ql.util.express.config.QLExpressRunStrategy;
import com.ql.util.express.exception.QLException;
import com.ql.util.express.instruction.OperateDataCacheManager;
import com.ql.util.express.instruction.op.OperatorBase;
import com.ql.util.express.instruction.opdata.OperateClass;
import com.ql.util.express.instruction.opdata.OperateDataVirClass;
import com.ql.util.express.parse.AppendingClassMethodManager;
import java.lang.reflect.Method;

public class OperatorMethod
extends OperatorBase {
    private String methodName;
    private static final Class<?> ARRAY_CLASS = Object[].class;

    public OperatorMethod() {
        this.name = "MethodCall";
    }

    public OperatorMethod(String methodName) {
        this.name = "MethodCall";
        this.methodName = methodName;
    }

    @Override
    public OperateData executeInner(InstructionSetContext parent, ArraySwap list) throws Exception {
        AppendingClassMethodManager.AppendingMethod appendingClassMethod;
        Object tmpObj;
        OperateData p0 = list.get(0);
        Object obj = p0.getObject(parent);
        if (obj instanceof OperateDataVirClass) {
            OperateDataVirClass vClass = (OperateDataVirClass)obj;
            OperateData[] parameters = new OperateData[list.length - 1];
            for (int i = 0; i < list.length - 1; ++i) {
                parameters[i] = list.get(i + 1);
            }
            return vClass.callSelfFunction(this.methodName, parameters);
        }
        if (obj == null) {
            if (QLExpressRunStrategy.isAvoidNullPointer()) {
                return null;
            }
            String msg = "\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6267\u884c\u65b9\u6cd5:";
            throw new QLException(msg + this.methodName);
        }
        Class[] types = new Class[list.length - 1];
        Class[] originalTypes = new Class[list.length - 1];
        Object[] objs = new Object[list.length - 1];
        for (int i = 0; i < types.length; ++i) {
            OperateData p = list.get(i + 1);
            tmpObj = p.getObject(parent);
            types[i] = p.getType(parent);
            originalTypes[i] = p.getType(parent);
            objs[i] = tmpObj;
        }
        AppendingClassMethodManager appendingClassMethodManager = parent.getExpressRunner().getAppendingClassMethodManager();
        if (appendingClassMethodManager != null && (appendingClassMethod = appendingClassMethodManager.getAppendingClassMethod(obj, this.methodName)) != null) {
            return appendingClassMethodManager.invoke(appendingClassMethod, parent, list, null);
        }
        if (QLExpressRunStrategy.isSandboxMode()) {
            throw new QLException("\u6ca1\u6709\u627e\u5230\u65b9\u6cd5:" + this.methodName);
        }
        Method method = null;
        if (p0 instanceof OperateClass) {
            method = ExpressUtil.findMethodWithCache((Class)obj, this.methodName, types, true, true);
        } else {
            if (obj instanceof Class) {
                method = ExpressUtil.findMethodWithCache((Class)obj, this.methodName, types, true, true);
            }
            if (method == null) {
                method = ExpressUtil.findMethodWithCache(obj.getClass(), this.methodName, types, true, false);
            }
        }
        if (method == null) {
            types = new Class[]{ARRAY_CLASS};
            method = p0 instanceof OperateClass ? ExpressUtil.findMethodWithCache((Class)obj, this.methodName, types, true, true) : ExpressUtil.findMethodWithCache(obj.getClass(), this.methodName, types, true, false);
            objs = new Object[]{objs};
        }
        if (method == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u6ca1\u6709\u627e\u5230").append(obj.getClass().getName()).append("\u7684\u65b9\u6cd5\uff1a").append(this.methodName).append("(");
            for (int i = 0; i < originalTypes.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                if (originalTypes[i] == null) {
                    stringBuilder.append("null");
                    continue;
                }
                stringBuilder.append(originalTypes[i].getName());
            }
            stringBuilder.append(")");
            throw new QLException(stringBuilder.toString());
        }
        QLExpressRunStrategy.assertSecurityRiskMethod(method);
        if (p0 instanceof OperateClass) {
            boolean oldA = method.isAccessible();
            method.setAccessible(true);
            tmpObj = method.invoke(null, ExpressUtil.transferArray(objs, method.getParameterTypes()));
            method.setAccessible(oldA);
        } else {
            boolean oldA = method.isAccessible();
            method.setAccessible(true);
            tmpObj = method.invoke(obj, ExpressUtil.transferArray(objs, method.getParameterTypes()));
            method.setAccessible(oldA);
        }
        return OperateDataCacheManager.fetchOperateData(tmpObj, method.getReturnType());
    }

    @Override
    public String toString() {
        return this.name + ":" + this.methodName;
    }
}

