/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.instruction;

import com.ql.util.express.CallResult;
import com.ql.util.express.ExpressLoader;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.InstructionSet;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.OperateData;
import com.ql.util.express.RunEnvironment;
import com.ql.util.express.instruction.IOperateDataCache;
import com.ql.util.express.instruction.RunnerDataCache;
import com.ql.util.express.instruction.opdata.OperateDataArrayItem;
import com.ql.util.express.instruction.opdata.OperateDataAttr;
import com.ql.util.express.instruction.opdata.OperateDataField;
import com.ql.util.express.instruction.opdata.OperateDataKeyValue;
import com.ql.util.express.instruction.opdata.OperateDataLocalVar;

public class OperateDataCacheManager {
    private static final ThreadLocal<RunnerDataCache> RUNNER_DATA_CACHE_THREAD_LOCAL = ThreadLocal.withInitial(RunnerDataCache::new);

    private OperateDataCacheManager() {
        throw new IllegalStateException("Utility class");
    }

    public static void push(ExpressRunner expressRunner) {
        RUNNER_DATA_CACHE_THREAD_LOCAL.get().push(expressRunner);
    }

    public static IOperateDataCache getOperateDataCache() {
        return RUNNER_DATA_CACHE_THREAD_LOCAL.get().getCache();
    }

    public static OperateData fetchOperateData(Object obj, Class<?> type) {
        return OperateDataCacheManager.getOperateDataCache().fetchOperateData(obj, type);
    }

    public static OperateDataAttr fetchOperateDataAttr(String name, Class<?> type) {
        return OperateDataCacheManager.getOperateDataCache().fetchOperateDataAttr(name, type);
    }

    public static OperateDataLocalVar fetchOperateDataLocalVar(String name, Class<?> type) {
        return OperateDataCacheManager.getOperateDataCache().fetchOperateDataLocalVar(name, type);
    }

    public static OperateDataField fetchOperateDataField(Object fieldObject, String fieldName) {
        return OperateDataCacheManager.getOperateDataCache().fetchOperateDataField(fieldObject, fieldName);
    }

    public static OperateDataArrayItem fetchOperateDataArrayItem(OperateData arrayObject, int index) {
        return OperateDataCacheManager.getOperateDataCache().fetchOperateDataArrayItem(arrayObject, index);
    }

    public static OperateDataKeyValue fetchOperateDataKeyValue(OperateData key, OperateData value) {
        return OperateDataCacheManager.getOperateDataCache().fetchOperateDataKeyValue(key, value);
    }

    public static RunEnvironment fetRunEnvironment(InstructionSet instructionSet, InstructionSetContext instructionSetContext, boolean isTrace) {
        return OperateDataCacheManager.getOperateDataCache().fetRunEnvironment(instructionSet, instructionSetContext, isTrace);
    }

    public static CallResult fetchCallResult(Object returnValue, boolean isExit) {
        return OperateDataCacheManager.getOperateDataCache().fetchCallResult(returnValue, isExit);
    }

    public static InstructionSetContext fetchInstructionSetContext(boolean isExpandToParent, ExpressRunner expressRunner, IExpressContext<String, Object> parent, ExpressLoader expressLoader, boolean isSupportDynamicFieldName) {
        return OperateDataCacheManager.getOperateDataCache().fetchInstructionSetContext(isExpandToParent, expressRunner, parent, expressLoader, isSupportDynamicFieldName);
    }

    public static long getFetchCount() {
        return OperateDataCacheManager.getOperateDataCache().getFetchCount();
    }

    public static void resetCache() {
        OperateDataCacheManager.getOperateDataCache().resetCache();
        RUNNER_DATA_CACHE_THREAD_LOCAL.get().pop();
    }
}

