/*
 * Decompiled with CFR 0.152.
 */
package com.alanbuttars.commons.util.validators;

public class Arguments {
    private Arguments() {
    }

    public static void verify(boolean expression) {
        Arguments.verify(expression, null);
    }

    public static void verify(boolean expression, String message) {
        if (!expression) {
            if (message == null) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(message);
        }
    }

    public static void verifyNonNull(Object argument) {
        Arguments.verifyNonNull(argument, null);
    }

    public static void verifyNonNull(Object argument, String message) {
        Arguments.verify(argument != null, message);
    }

    public static void verifyNonEmpty(String argument) {
        Arguments.verifyNonEmpty(argument, null);
    }

    public static void verifyNonEmpty(String argument, String message) {
        Arguments.verify(argument != null && !argument.trim().isEmpty(), message);
    }

    public static void verifyPositive(Number number) {
        Arguments.verifyPositive(number, null);
    }

    public static void verifyPositive(Number number, String message) {
        Arguments.verify(number.longValue() > 0L, message);
    }

    public static void verifyNonNegativeNumber(Number number) {
        Arguments.verifyNonNegativeNumber(number, null);
    }

    public static void verifyNonNegativeNumber(Number number, String message) {
        Arguments.verify(number.longValue() >= 0L, message);
    }
}

