/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.sessionauthentication;

import com.adyen.model.sessionauthentication.JSON;
import com.adyen.model.sessionauthentication.Resource;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

@JsonPropertyOrder(value={"resources", "roles"})
public class Policy {
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    private Set<Resource> resources;
    public static final String JSON_PROPERTY_ROLES = "roles";
    private Set<String> roles;

    public Policy resources(Set<Resource> resources) {
        this.resources = resources;
        return this;
    }

    public Policy addResourcesItem(Resource resourcesItem) {
        if (this.resources == null) {
            this.resources = new LinkedHashSet<Resource>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Set<Resource> getResources() {
        return this.resources;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResources(Set<Resource> resources) {
        this.resources = resources;
    }

    public Policy roles(Set<String> roles) {
        this.roles = roles;
        return this;
    }

    public Policy addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new LinkedHashSet<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Set<String> getRoles() {
        return this.roles;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy policy = (Policy)o;
        return Objects.equals(this.resources, policy.resources) && Objects.equals(this.roles, policy.roles);
    }

    public int hashCode() {
        return Objects.hash(this.resources, this.roles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Policy {\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Policy fromJson(String jsonString) throws JsonProcessingException {
        return (Policy)JSON.getMapper().readValue(jsonString, Policy.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

