/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "bankAccountUUID", "description", "metadata", "payoutMethodCode", "payoutSchedule", "payoutScheduleReason", "payoutSpeed"})
public class CreateAccountRequest {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D = "bankAccountUUID";
    private String bankAccountUUID;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = null;
    public static final String JSON_PROPERTY_PAYOUT_METHOD_CODE = "payoutMethodCode";
    private String payoutMethodCode;
    public static final String JSON_PROPERTY_PAYOUT_SCHEDULE = "payoutSchedule";
    private PayoutScheduleEnum payoutSchedule;
    public static final String JSON_PROPERTY_PAYOUT_SCHEDULE_REASON = "payoutScheduleReason";
    private String payoutScheduleReason;
    public static final String JSON_PROPERTY_PAYOUT_SPEED = "payoutSpeed";
    private PayoutSpeedEnum payoutSpeed = PayoutSpeedEnum.STANDARD;

    public CreateAccountRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of Account Holder under which to create the account.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public CreateAccountRequest bankAccountUUID(String bankAccountUUID) {
        this.bankAccountUUID = bankAccountUUID;
        return this;
    }

    @ApiModelProperty(value="The bankAccountUUID of the bank account held by the account holder to couple the account with. Scheduled payouts in currencies matching the currency of this bank account will be sent to this bank account. Payouts in different currencies will be sent to a matching bank account of the account holder.")
    @JsonProperty(value="bankAccountUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankAccountUUID() {
        return this.bankAccountUUID;
    }

    @JsonProperty(value="bankAccountUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountUUID(String bankAccountUUID) {
        this.bankAccountUUID = bankAccountUUID;
    }

    public CreateAccountRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A description of the account, maximum 256 characters. You can use alphanumeric characters (A-Z, a-z, 0-9), white spaces, and underscores `_`.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateAccountRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public CreateAccountRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="A set of key and value pairs for general use by the merchant. The keys do not have specific names and may be used for storing miscellaneous data as desired. > Note that during an update of metadata, the omission of existing key-value pairs will result in the deletion of those key-value pairs.")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public CreateAccountRequest payoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
        return this;
    }

    @ApiModelProperty(value="The payout method code held by the account holder to couple the account with. Scheduled card payouts will be sent using this payout method code.")
    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutMethodCode() {
        return this.payoutMethodCode;
    }

    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
    }

    public CreateAccountRequest payoutSchedule(PayoutScheduleEnum payoutSchedule) {
        this.payoutSchedule = payoutSchedule;
        return this;
    }

    @ApiModelProperty(value="The payout schedule of the prospective account. >Permitted values: `DEFAULT`, `HOLD`, `DAILY`, `WEEKLY`, `MONTHLY`.")
    @JsonProperty(value="payoutSchedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PayoutScheduleEnum getPayoutSchedule() {
        return this.payoutSchedule;
    }

    @JsonProperty(value="payoutSchedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutSchedule(PayoutScheduleEnum payoutSchedule) {
        this.payoutSchedule = payoutSchedule;
    }

    public CreateAccountRequest payoutScheduleReason(String payoutScheduleReason) {
        this.payoutScheduleReason = payoutScheduleReason;
        return this;
    }

    @ApiModelProperty(value="The reason for the payout schedule choice. >Required if the payoutSchedule is `HOLD`.")
    @JsonProperty(value="payoutScheduleReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutScheduleReason() {
        return this.payoutScheduleReason;
    }

    @JsonProperty(value="payoutScheduleReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutScheduleReason(String payoutScheduleReason) {
        this.payoutScheduleReason = payoutScheduleReason;
    }

    public CreateAccountRequest payoutSpeed(PayoutSpeedEnum payoutSpeed) {
        this.payoutSpeed = payoutSpeed;
        return this;
    }

    @ApiModelProperty(value="Speed with which payouts for this account are processed. Permitted values: `STANDARD`, `SAME_DAY`.")
    @JsonProperty(value="payoutSpeed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PayoutSpeedEnum getPayoutSpeed() {
        return this.payoutSpeed;
    }

    @JsonProperty(value="payoutSpeed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutSpeed(PayoutSpeedEnum payoutSpeed) {
        this.payoutSpeed = payoutSpeed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAccountRequest createAccountRequest = (CreateAccountRequest)o;
        return Objects.equals(this.accountHolderCode, createAccountRequest.accountHolderCode) && Objects.equals(this.bankAccountUUID, createAccountRequest.bankAccountUUID) && Objects.equals(this.description, createAccountRequest.description) && Objects.equals(this.metadata, createAccountRequest.metadata) && Objects.equals(this.payoutMethodCode, createAccountRequest.payoutMethodCode) && Objects.equals((Object)this.payoutSchedule, (Object)createAccountRequest.payoutSchedule) && Objects.equals(this.payoutScheduleReason, createAccountRequest.payoutScheduleReason) && Objects.equals((Object)this.payoutSpeed, (Object)createAccountRequest.payoutSpeed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderCode, this.bankAccountUUID, this.description, this.metadata, this.payoutMethodCode, this.payoutSchedule, this.payoutScheduleReason, this.payoutSpeed});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAccountRequest {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    bankAccountUUID: ").append(this.toIndentedString(this.bankAccountUUID)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    payoutMethodCode: ").append(this.toIndentedString(this.payoutMethodCode)).append("\n");
        sb.append("    payoutSchedule: ").append(this.toIndentedString((Object)this.payoutSchedule)).append("\n");
        sb.append("    payoutScheduleReason: ").append(this.toIndentedString(this.payoutScheduleReason)).append("\n");
        sb.append("    payoutSpeed: ").append(this.toIndentedString((Object)this.payoutSpeed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateAccountRequest fromJson(String jsonString) throws JsonProcessingException {
        return (CreateAccountRequest)JSON.getMapper().readValue(jsonString, CreateAccountRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PayoutSpeedEnum {
        INSTANT("INSTANT"),
        SAME_DAY("SAME_DAY"),
        STANDARD("STANDARD");

        private String value;

        private PayoutSpeedEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayoutSpeedEnum fromValue(String value) {
            for (PayoutSpeedEnum b : PayoutSpeedEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PayoutScheduleEnum {
        BIWEEKLY_ON_1ST_AND_15TH_AT_MIDNIGHT("BIWEEKLY_ON_1ST_AND_15TH_AT_MIDNIGHT"),
        DAILY("DAILY"),
        DAILY_AU("DAILY_AU"),
        DAILY_EU("DAILY_EU"),
        DAILY_SG("DAILY_SG"),
        DAILY_US("DAILY_US"),
        HOLD("HOLD"),
        MONTHLY("MONTHLY"),
        WEEKLY("WEEKLY"),
        WEEKLY_MON_TO_FRI_AU("WEEKLY_MON_TO_FRI_AU"),
        WEEKLY_MON_TO_FRI_EU("WEEKLY_MON_TO_FRI_EU"),
        WEEKLY_MON_TO_FRI_US("WEEKLY_MON_TO_FRI_US"),
        WEEKLY_ON_TUE_FRI_MIDNIGHT("WEEKLY_ON_TUE_FRI_MIDNIGHT"),
        WEEKLY_SUN_TO_THU_AU("WEEKLY_SUN_TO_THU_AU"),
        WEEKLY_SUN_TO_THU_US("WEEKLY_SUN_TO_THU_US");

        private String value;

        private PayoutScheduleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayoutScheduleEnum fromValue(String value) {
            for (PayoutScheduleEnum b : PayoutScheduleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

