/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"cardNumber", "countryCode", "encryptedCardNumber", "merchantAccount", "supportedBrands"})
public class CardDetailsRequest {
    public static final String JSON_PROPERTY_CARD_NUMBER = "cardNumber";
    private String cardNumber;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_ENCRYPTED_CARD_NUMBER = "encryptedCardNumber";
    private String encryptedCardNumber;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_SUPPORTED_BRANDS = "supportedBrands";
    private List<String> supportedBrands;

    public CardDetailsRequest cardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
        return this;
    }

    @JsonProperty(value="cardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardNumber() {
        return this.cardNumber;
    }

    @JsonProperty(value="cardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public CardDetailsRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public CardDetailsRequest encryptedCardNumber(String encryptedCardNumber) {
        this.encryptedCardNumber = encryptedCardNumber;
        return this;
    }

    @JsonProperty(value="encryptedCardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEncryptedCardNumber() {
        return this.encryptedCardNumber;
    }

    @JsonProperty(value="encryptedCardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptedCardNumber(String encryptedCardNumber) {
        this.encryptedCardNumber = encryptedCardNumber;
    }

    public CardDetailsRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public CardDetailsRequest supportedBrands(List<String> supportedBrands) {
        this.supportedBrands = supportedBrands;
        return this;
    }

    public CardDetailsRequest addSupportedBrandsItem(String supportedBrandsItem) {
        if (this.supportedBrands == null) {
            this.supportedBrands = new ArrayList<String>();
        }
        this.supportedBrands.add(supportedBrandsItem);
        return this;
    }

    @JsonProperty(value="supportedBrands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSupportedBrands() {
        return this.supportedBrands;
    }

    @JsonProperty(value="supportedBrands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportedBrands(List<String> supportedBrands) {
        this.supportedBrands = supportedBrands;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardDetailsRequest cardDetailsRequest = (CardDetailsRequest)o;
        return Objects.equals(this.cardNumber, cardDetailsRequest.cardNumber) && Objects.equals(this.countryCode, cardDetailsRequest.countryCode) && Objects.equals(this.encryptedCardNumber, cardDetailsRequest.encryptedCardNumber) && Objects.equals(this.merchantAccount, cardDetailsRequest.merchantAccount) && Objects.equals(this.supportedBrands, cardDetailsRequest.supportedBrands);
    }

    public int hashCode() {
        return Objects.hash(this.cardNumber, this.countryCode, this.encryptedCardNumber, this.merchantAccount, this.supportedBrands);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardDetailsRequest {\n");
        sb.append("    cardNumber: ").append(this.toIndentedString(this.cardNumber)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    encryptedCardNumber: ").append(this.toIndentedString(this.encryptedCardNumber)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    supportedBrands: ").append(this.toIndentedString(this.supportedBrands)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CardDetailsRequest fromJson(String jsonString) throws JsonProcessingException {
        return (CardDetailsRequest)JSON.getMapper().readValue(jsonString, CardDetailsRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

